/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.IOException;
import java.io.Writer;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.IgnoredPropertyInfo;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MultiplexMappingInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.SafeTagList;
import org.jfree.xml.writer.XMLWriterSupport;

public class ModelWriter {
    private static SafeTagList safeTags;
    private XMLWriterSupport writerSupport = new XMLWriterSupport(ModelWriter.getSafeTags(), 0);
    private DescriptionModel model;

    public static SafeTagList getSafeTags() {
        if (safeTags == null) {
            safeTags = new SafeTagList();
            safeTags.add("objects");
            safeTags.add("object");
            safeTags.add("constructor");
            safeTags.add("element-property");
            safeTags.add("lookup");
            safeTags.add("attribute-property");
            safeTags.add("parameter");
            safeTags.add("include");
            safeTags.add("ignore");
            safeTags.add("manual");
            safeTags.add("mapping");
            safeTags.add("type");
        }
        return safeTags;
    }

    public DescriptionModel getModel() {
        return this.model;
    }

    public void setModel(DescriptionModel descriptionModel) {
        this.model = descriptionModel;
    }

    public static void writeXMLHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write(XMLWriterSupport.getLineSeparator());
        writer.write("<!-- CVSTag: $Id: ModelWriter.java,v 1.6 2003/11/22 20:39:29 taqua Exp $ -->");
        writer.write(XMLWriterSupport.getLineSeparator());
    }

    public void write(Writer writer) throws IOException {
        this.writerSupport.writeTag(writer, "objects");
        for (int i = 0; i < this.model.size(); ++i) {
            ClassDescription classDescription = this.model.get(i);
            this.writeClassDescription(writer, classDescription);
        }
        this.writerSupport.writeCloseTag(writer, "objects");
    }

    protected void writeManualMapping(Writer writer) throws IOException {
        ManualMappingInfo[] manualMappingInfoArray = this.model.getMappingModel().getManualMapping();
        for (int i = 0; i < manualMappingInfoArray.length; ++i) {
            ManualMappingInfo manualMappingInfo = manualMappingInfoArray[i];
            AttributeList attributeList = new AttributeList();
            attributeList.setAttribute("class", manualMappingInfo.getBaseClass().getName());
            attributeList.setAttribute("read-handler", manualMappingInfo.getReadHandler().getName());
            attributeList.setAttribute("write-handler", manualMappingInfo.getWriteHandler().getName());
            this.getWriterSupport().writeCloseTag(writer, "manual");
        }
    }

    protected void writeMultiplexMapping(Writer writer) throws IOException {
        MultiplexMappingInfo[] multiplexMappingInfoArray = this.model.getMappingModel().getMultiplexMapping();
        for (int i = 0; i < multiplexMappingInfoArray.length; ++i) {
            MultiplexMappingInfo multiplexMappingInfo = multiplexMappingInfoArray[i];
            TypeInfo[] typeInfoArray = multiplexMappingInfo.getChildClasses();
            if (typeInfoArray.length < 2) continue;
            AttributeList attributeList = new AttributeList();
            attributeList.setAttribute("base-class", multiplexMappingInfo.getBaseClass().getName());
            attributeList.setAttribute("type-attribute", multiplexMappingInfo.getTypeAttribute());
            this.getWriterSupport().writeTag(writer, "mapping", attributeList, false);
            for (int j = 0; j < typeInfoArray.length; ++j) {
                AttributeList attributeList2 = new AttributeList();
                attributeList2.setAttribute("name", typeInfoArray[j].getName());
                attributeList2.setAttribute("class", typeInfoArray[j].getType().getName());
                this.getWriterSupport().writeTag(writer, "type", attributeList2, true);
            }
            this.getWriterSupport().writeCloseTag(writer, "mapping");
        }
    }

    protected void writeClassDescription(Writer writer, ClassDescription classDescription) throws IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("class", classDescription.getName());
        if (classDescription.getRegisterKey() != null) {
            attributeList.setAttribute("register-name", classDescription.getRegisterKey());
        }
        if (classDescription.isPreserve()) {
            attributeList.setAttribute("ignore", "true");
        }
        this.writerSupport.writeTag(writer, "object", attributeList, false);
        TypeInfo[] typeInfoArray = classDescription.getConstructorDescription();
        if (typeInfoArray != null && typeInfoArray.length != 0) {
            this.writerSupport.writeTag(writer, "constructor");
            for (int i = 0; i < typeInfoArray.length; ++i) {
                AttributeList attributeList2 = new AttributeList();
                attributeList2.setAttribute("class", typeInfoArray[i].getType().getName());
                attributeList2.setAttribute("property", typeInfoArray[i].getName());
            }
            this.writerSupport.writeCloseTag(writer, "constructor");
        }
        PropertyInfo[] propertyInfoArray = classDescription.getProperties();
        for (int i = 0; i < propertyInfoArray.length; ++i) {
            this.writePropertyInfo(writer, propertyInfoArray[i]);
        }
        this.writerSupport.writeCloseTag(writer, "object");
    }

    private void writePropertyInfo(Writer writer, PropertyInfo propertyInfo) throws IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("name", propertyInfo.getName());
        if (propertyInfo instanceof IgnoredPropertyInfo) {
            this.writerSupport.writeTag(writer, "ignore", attributeList, true);
            return;
        }
        if (propertyInfo.getPropertyType().equals(PropertyType.ATTRIBUTE)) {
            attributeList.setAttribute("attribute", propertyInfo.getXmlName());
            attributeList.setAttribute("handler", propertyInfo.getXmlHandler());
            this.writerSupport.writeTag(writer, "attribute-property", attributeList, true);
        } else if (propertyInfo.getPropertyType().equals(PropertyType.ELEMENT)) {
            writer.write("        <!-- property type is " + propertyInfo.getType() + " -->");
            writer.write(System.getProperty("line.separator", "\n"));
            attributeList.setAttribute("element", propertyInfo.getXmlName());
            this.writerSupport.writeTag(writer, "element-property", attributeList, true);
        } else {
            attributeList.setAttribute("lookup", propertyInfo.getXmlName());
            this.writerSupport.writeTag(writer, "lookup", attributeList, true);
        }
    }

    public XMLWriterSupport getWriterSupport() {
        return this.writerSupport;
    }
}

