/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextLine;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class CategoryAxis
extends Axis
implements Cloneable,
Serializable {
    public static final boolean DEFAULT_VERTICAL_CATEGORY_LABELS = false;
    public static final double DEFAULT_AXIS_MARGIN = 0.05;
    public static final double DEFAULT_CATEGORY_MARGIN = 0.2;
    public static final Paint DEFAULT_AXIS_LINE_PAINT = Color.gray;
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private double categoryMargin = 0.2;
    private boolean axisLineVisible = true;
    private transient Paint axisLinePaint = DEFAULT_AXIS_LINE_PAINT;
    private transient Stroke axisLineStroke = new BasicStroke(1.0f);
    private int categoryLabelPositionOffset;
    private CategoryLabelPosition topCategoryLabelPosition;
    private CategoryLabelPosition bottomCategoryLabelPosition;
    private CategoryLabelPosition leftCategoryLabelPosition;
    private CategoryLabelPosition rightCategoryLabelPosition;

    public CategoryAxis(String string) {
        super(string);
        this.setTickMarksVisible(false);
        this.categoryLabelPositionOffset = 4;
        this.topCategoryLabelPosition = new CategoryLabelPosition(RectangleAnchor.BOTTOM, TextBlockAnchor.BOTTOM_CENTER, TextAnchor.BOTTOM_CENTER, 0.0);
        this.bottomCategoryLabelPosition = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.TOP_CENTER, TextAnchor.TOP_CENTER, 0.0);
        this.leftCategoryLabelPosition = new CategoryLabelPosition(RectangleAnchor.RIGHT, TextBlockAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, 0.0);
        this.rightCategoryLabelPosition = new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, 0.0);
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(double d) {
        this.categoryMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isVerticalCategoryLabels() {
        return false;
    }

    public void setVerticalCategoryLabels(boolean bl) {
        if (bl) {
            double d = 1.5707963267948966;
            double d2 = -d;
            this.topCategoryLabelPosition = new CategoryLabelPosition(this.topCategoryLabelPosition.getCategoryAnchor(), TextBlockAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, d);
            this.bottomCategoryLabelPosition = new CategoryLabelPosition(this.bottomCategoryLabelPosition.getCategoryAnchor(), TextBlockAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, d2);
            this.leftCategoryLabelPosition = new CategoryLabelPosition(this.leftCategoryLabelPosition.getCategoryAnchor(), TextBlockAnchor.CENTER_RIGHT, this.leftCategoryLabelPosition.getRotationAnchor(), d);
            this.rightCategoryLabelPosition = new CategoryLabelPosition(this.rightCategoryLabelPosition.getCategoryAnchor(), TextBlockAnchor.CENTER_LEFT, this.rightCategoryLabelPosition.getRotationAnchor(), d2);
        } else {
            this.topCategoryLabelPosition = new CategoryLabelPosition(this.topCategoryLabelPosition.getCategoryAnchor(), this.topCategoryLabelPosition.getLabelAnchor(), this.topCategoryLabelPosition.getRotationAnchor(), 0.0);
            this.bottomCategoryLabelPosition = new CategoryLabelPosition(this.bottomCategoryLabelPosition.getCategoryAnchor(), this.bottomCategoryLabelPosition.getLabelAnchor(), this.bottomCategoryLabelPosition.getRotationAnchor(), 0.0);
            this.leftCategoryLabelPosition = new CategoryLabelPosition(this.leftCategoryLabelPosition.getCategoryAnchor(), this.leftCategoryLabelPosition.getLabelAnchor(), this.leftCategoryLabelPosition.getRotationAnchor(), 0.0);
            this.rightCategoryLabelPosition = new CategoryLabelPosition(this.rightCategoryLabelPosition.getCategoryAnchor(), this.rightCategoryLabelPosition.getLabelAnchor(), this.rightCategoryLabelPosition.getRotationAnchor(), 0.0);
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean getSkipCategoryLabelsToFit() {
        return false;
    }

    public void setSkipCategoryLabelsToFit(boolean bl) {
    }

    public boolean isAxisLineVisible() {
        return this.axisLineVisible;
    }

    public void setAxisLineVisible(boolean bl) {
        this.axisLineVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getCategoryLabelPositionOffset() {
        return this.categoryLabelPositionOffset;
    }

    public void setCategoryLabelPositionOffset(int n) {
        this.categoryLabelPositionOffset = n;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public CategoryLabelPosition getTopCategoryLabelPosition() {
        return this.topCategoryLabelPosition;
    }

    public void setTopCategoryLabelPosition(CategoryLabelPosition categoryLabelPosition) {
        this.topCategoryLabelPosition = categoryLabelPosition;
    }

    public CategoryLabelPosition getBottomCategoryLabelPosition() {
        return this.bottomCategoryLabelPosition;
    }

    public void setBottomCategoryLabelPosition(CategoryLabelPosition categoryLabelPosition) {
        this.bottomCategoryLabelPosition = categoryLabelPosition;
    }

    public CategoryLabelPosition getLeftCategoryLabelPosition() {
        return this.leftCategoryLabelPosition;
    }

    public void setLeftCategoryLabelPosition(CategoryLabelPosition categoryLabelPosition) {
        this.leftCategoryLabelPosition = categoryLabelPosition;
    }

    public CategoryLabelPosition getRightCategoryLabelPosition() {
        return this.rightCategoryLabelPosition;
    }

    public void setRightCategoryLabelPosition(CategoryLabelPosition categoryLabelPosition) {
        this.rightCategoryLabelPosition = categoryLabelPosition;
    }

    public double getCategoryJava2DCoordinate(CategoryAnchor categoryAnchor, int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        if (categoryAnchor == CategoryAnchor.START) {
            d = this.getCategoryStart(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.MIDDLE) {
            d = this.getCategoryMiddle(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.END) {
            d = this.getCategoryEnd(n, n2, rectangle2D, rectangleEdge);
        }
        return d;
    }

    public double getCategoryStart(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d = rectangle2D.getX() + rectangle2D.getWidth() * this.getLowerMargin();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d = rectangle2D.getMinY() + rectangle2D.getHeight() * this.getLowerMargin();
        }
        double d2 = this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
        double d3 = this.calculateCategoryGapSize(n2, rectangle2D, rectangleEdge);
        return d += (double)n * (d2 + d3);
    }

    public double getCategoryMiddle(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge) / 2.0;
    }

    public double getCategoryEnd(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
    }

    protected double calculateCategorySize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d = d2 * (1.0 - this.getLowerMargin() - this.getUpperMargin() - this.getCategoryMargin());
            d /= (double)n;
        } else {
            d = d2 * (1.0 - this.getLowerMargin() - this.getUpperMargin());
        }
        return d;
    }

    protected double calculateCategoryGapSize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d = d2 * this.getCategoryMargin() / (double)(n - 1);
        }
        return d;
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        Object object;
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            object = new AxisState();
            this.refreshTicks(graphics2D, (AxisState)object, rectangle2D, rectangle2D, rectangleEdge);
            if (rectangleEdge == RectangleEdge.TOP) {
                d = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                d2 = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d2 = ((AxisState)object).getMax();
            }
        }
        object = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d3 = 0.0;
        double d4 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d3 = ((RectangularShape)object).getHeight();
            axisSpace.add(d3 + d, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = ((RectangularShape)object).getWidth();
            axisSpace.add(d4 + d2, rectangleEdge);
        }
        return axisSpace;
    }

    public void configure() {
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (!this.isVisible()) {
            return new AxisState(d);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        AxisState axisState = new AxisState(d);
        axisState = this.drawCategoryLabels(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    protected AxisState drawCategoryLabels(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState) {
        if (axisState == null) {
            throw new IllegalArgumentException("null state not permitted.");
        }
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            graphics2D.setPaint(this.getTickLabelPaint());
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CategoryTick categoryTick = (CategoryTick)iterator.next();
                graphics2D.setPaint(this.getTickLabelPaint());
                CategoryLabelPosition categoryLabelPosition = null;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                if (rectangleEdge == RectangleEdge.TOP) {
                    d = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = axisState.getCursor() - (double)this.categoryLabelPositionOffset;
                    d3 = d4 - axisState.getMax();
                    categoryLabelPosition = this.topCategoryLabelPosition;
                } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                    d = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d3 = axisState.getCursor() + (double)this.categoryLabelPositionOffset;
                    d4 = d3 + axisState.getMax();
                    categoryLabelPosition = this.bottomCategoryLabelPosition;
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    d3 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = axisState.getCursor() - (double)this.categoryLabelPositionOffset;
                    d = d2 - axisState.getMax();
                    categoryLabelPosition = this.leftCategoryLabelPosition;
                } else if (rectangleEdge == RectangleEdge.RIGHT) {
                    d3 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d = axisState.getCursor() + (double)this.categoryLabelPositionOffset;
                    d2 = d - axisState.getMax();
                    categoryLabelPosition = this.rightCategoryLabelPosition;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
                double[] dArray = RectangleAnchor.coordinates(double_, categoryLabelPosition.getCategoryAnchor());
                TextBlock textBlock = categoryTick.getLabel();
                textBlock.draw(graphics2D, (float)dArray[0], (float)dArray[1], categoryLabelPosition.getLabelAnchor(), (float)dArray[0], (float)dArray[1], categoryLabelPosition.getAngle());
                ++n;
            }
            if (rectangleEdge.equals(RectangleEdge.TOP)) {
                double d = axisState.getMax();
                axisState.cursorUp(d);
            } else if (rectangleEdge.equals(RectangleEdge.BOTTOM)) {
                double d = axisState.getMax();
                axisState.cursorDown(d);
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                double d = axisState.getMax();
                axisState.cursorLeft(d);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double d = axisState.getMax();
                axisState.cursorRight(d);
            }
        }
        return axisState;
    }

    protected void drawAxisLine(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Line2D.Double double_ = null;
        if (rectangleEdge == RectangleEdge.TOP) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(this.axisLinePaint);
        graphics2D.setStroke(this.axisLineStroke);
        graphics2D.draw(double_);
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<CategoryTick> arrayList = new ArrayList<CategoryTick>();
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        List list = categoryPlot.getCategories();
        double d = 0.0;
        if (list != null) {
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Comparable comparable = (Comparable)iterator.next();
                TextBlock textBlock = this.createLabel(comparable, 0.0, rectangleEdge);
                CategoryLabelPosition categoryLabelPosition = null;
                if (rectangleEdge == RectangleEdge.TOP) {
                    categoryLabelPosition = this.topCategoryLabelPosition;
                    d = Math.max(d, this.calculateTextBlockHeight(textBlock, categoryLabelPosition, graphics2D));
                } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                    categoryLabelPosition = this.bottomCategoryLabelPosition;
                    d = Math.max(d, this.calculateTextBlockHeight(textBlock, categoryLabelPosition, graphics2D));
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    categoryLabelPosition = this.leftCategoryLabelPosition;
                    d = Math.max(d, this.calculateTextBlockWidth(textBlock, categoryLabelPosition, graphics2D));
                } else if (rectangleEdge == RectangleEdge.RIGHT) {
                    categoryLabelPosition = this.rightCategoryLabelPosition;
                    d = Math.max(d, this.calculateTextBlockWidth(textBlock, categoryLabelPosition, graphics2D));
                }
                CategoryTick categoryTick = new CategoryTick(comparable, textBlock, categoryLabelPosition.getLabelAnchor(), categoryLabelPosition.getRotationAnchor(), categoryLabelPosition.getAngle());
                arrayList.add(categoryTick);
                ++n;
            }
        }
        axisState.setMax(d + (double)this.categoryLabelPositionOffset);
        return arrayList;
    }

    protected TextBlock createLabel(Comparable comparable, double d, RectangleEdge rectangleEdge) {
        TextBlock textBlock = new TextBlock();
        TextLine textLine = new TextLine(comparable.toString(), this.getTickLabelFont());
        textBlock.addLine(textLine);
        return textBlock;
    }

    protected double calculateTextBlockWidth(TextBlock textBlock, CategoryLabelPosition categoryLabelPosition, Graphics2D graphics2D) {
        Insets insets = this.getTickLabelInsets();
        Dimension dimension = textBlock.calculateDimensions(graphics2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
        Shape shape = RefineryUtilities.rotateShape(double_, graphics2D, categoryLabelPosition.getAngle(), 0.0f, 0.0f);
        double d = shape.getBounds2D().getWidth() + (double)insets.top + (double)insets.bottom;
        return d;
    }

    protected double calculateTextBlockHeight(TextBlock textBlock, CategoryLabelPosition categoryLabelPosition, Graphics2D graphics2D) {
        Insets insets = this.getTickLabelInsets();
        Dimension dimension = textBlock.calculateDimensions(graphics2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
        Shape shape = RefineryUtilities.rotateShape(double_, graphics2D, categoryLabelPosition.getAngle(), 0.0f, 0.0f);
        double d = shape.getBounds2D().getHeight() + (double)insets.top + (double)insets.bottom;
        return d;
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        return object;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CategoryAxis) {
            CategoryAxis categoryAxis = (CategoryAxis)object;
            if (super.equals(object)) {
                boolean bl = this.lowerMargin == categoryAxis.lowerMargin;
                boolean bl2 = this.upperMargin == categoryAxis.upperMargin;
                boolean bl3 = this.categoryMargin == categoryAxis.categoryMargin;
                return bl && bl2 && bl3;
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.axisLinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.axisLineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.axisLinePaint = SerialUtilities.readPaint(objectInputStream);
        this.axisLineStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

