/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanelConstants;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.ChartPropertyEditPanel;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.ui.RefineryUtilities;

public class ChartPanel
extends JPanel
implements ChartPanelConstants,
ChartChangeListener,
ChartProgressListener,
ActionListener,
MouseListener,
MouseMotionListener,
Printable {
    private JFreeChart chart;
    private List chartMouseListeners;
    private boolean useBuffer;
    private boolean refreshBuffer;
    private Image chartBuffer;
    private int chartBufferHeight;
    private int chartBufferWidth;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private JPopupMenu popup;
    private ChartRenderingInfo info;
    private double scaleX;
    private double scaleY;
    private Rectangle2D zoomRectangle = null;
    private Point2D zoomPoint = null;
    private boolean fillZoomRectangle = false;
    private boolean horizontalZoom = false;
    private boolean verticalZoom = false;
    private boolean horizontalAxisTrace = false;
    private boolean verticalAxisTrace = false;
    private JMenuItem zoomInBothMenuItem;
    private JMenuItem zoomInHorizontalMenuItem;
    private JMenuItem zoomInVerticalMenuItem;
    private JMenuItem zoomOutBothMenuItem;
    private JMenuItem zoomOutHorizontalMenuItem;
    private JMenuItem zoomOutVerticalMenuItem;
    private JMenuItem autoRangeBothMenuItem;
    private JMenuItem autoRangeHorizontalMenuItem;
    private JMenuItem autoRangeVerticalMenuItem;
    private Line2D verticalTraceLine;
    private Line2D horizontalTraceLine;
    private boolean enforceFileExtensions;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.LocalizationBundle");
    private Rectangle2D available = new Rectangle2D.Double();
    private Rectangle2D chartArea = new Rectangle2D.Double();

    public ChartPanel(JFreeChart jFreeChart) {
        this(jFreeChart, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart jFreeChart, boolean bl) {
        this(jFreeChart, 680, 420, 300, 200, 800, 600, bl, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart jFreeChart, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(jFreeChart, 680, 420, 300, 200, 800, 600, false, bl, bl2, bl3, bl4, bl5);
    }

    public ChartPanel(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.chart = jFreeChart;
        this.chartMouseListeners = new ArrayList();
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(n, n2));
        this.useBuffer = bl;
        this.refreshBuffer = false;
        this.chart.addChangeListener(this);
        this.minimumDrawWidth = n3;
        this.minimumDrawHeight = n4;
        this.maximumDrawWidth = n5;
        this.maximumDrawHeight = n6;
        this.popup = null;
        if (bl2 || bl3 || bl4 || bl5) {
            this.popup = this.createPopupMenu(bl2, bl3, bl4, bl5);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setDisplayToolTips(bl6);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.enforceFileExtensions = true;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart jFreeChart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
            this.chart.removeProgressListener(this);
        }
        this.chart = jFreeChart;
        this.chart.addChangeListener(this);
        this.chart.addProgressListener(this);
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        Plot plot = jFreeChart.getPlot();
        ValueAxis valueAxis = this.getHorizontalValueAxis(plot);
        this.horizontalZoom = this.horizontalZoom && valueAxis != null;
        ValueAxis valueAxis2 = this.getVerticalValueAxis(plot);
        this.verticalZoom = this.verticalZoom && valueAxis2 != null;
        this.repaint();
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int n) {
        this.minimumDrawWidth = n;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int n) {
        this.maximumDrawWidth = n;
    }

    public void setMinimumDrawHeight(int n) {
        this.minimumDrawHeight = n;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int n) {
        this.maximumDrawHeight = n;
    }

    protected double getScaleX() {
        return this.scaleX;
    }

    protected double getScaleY() {
        return this.scaleY;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.info;
    }

    public void setMouseZoomable(boolean bl) {
        this.setMouseZoomable(bl, true);
    }

    public void setMouseZoomable(boolean bl, boolean bl2) {
        this.setHorizontalZoom(bl);
        this.setVerticalZoom(bl);
        this.setFillZoomRectangle(bl2);
    }

    public void setHorizontalZoom(boolean bl) {
        Plot plot = this.chart.getPlot();
        ValueAxis valueAxis = this.getHorizontalValueAxis(plot);
        this.horizontalZoom = bl && valueAxis != null;
    }

    public void setFillZoomRectangle(boolean bl) {
        this.fillZoomRectangle = bl;
    }

    public void setVerticalZoom(boolean bl) {
        Plot plot = this.chart.getPlot();
        ValueAxis valueAxis = this.getVerticalValueAxis(plot);
        this.verticalZoom = bl && valueAxis != null;
    }

    public void setHorizontalAxisTrace(boolean bl) {
        this.horizontalAxisTrace = bl;
    }

    public void setVerticalAxisTrace(boolean bl) {
        this.verticalAxisTrace = bl;
    }

    public boolean isEnforceFileExtensions() {
        return this.enforceFileExtensions;
    }

    public void setEnforceFileExtensions(boolean bl) {
        this.enforceFileExtensions = bl;
    }

    public void setDisplayToolTips(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        EntityCollection entityCollection;
        String string = null;
        if (this.info != null && (entityCollection = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity chartEntity = entityCollection.getEntity((int)((double)(mouseEvent.getX() - insets.left) / this.scaleX), (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY));
            if (chartEntity != null) {
                string = chartEntity.getToolTipText();
            }
        }
        return string;
    }

    public Point translateJava2DToScreen(Point2D point2D) {
        Insets insets = this.getInsets();
        int n = (int)(point2D.getX() * this.scaleX + (double)insets.left);
        int n2 = (int)(point2D.getY() * this.scaleY + (double)insets.top);
        return new Point(n, n2);
    }

    public Point2D translateScreenToJava2D(Point point) {
        Insets insets = this.getInsets();
        double d = (point.getX() - (double)insets.left) / this.scaleX;
        double d2 = (point.getY() - (double)insets.top) / this.scaleY;
        return new Point2D.Double(d, d2);
    }

    public ChartEntity getEntityForPoint(int n, int n2) {
        ChartEntity chartEntity = null;
        if (this.info != null) {
            Insets insets = this.getInsets();
            double d = (double)(n - insets.left) / this.scaleX;
            double d2 = (double)(n2 - insets.top) / this.scaleY;
            EntityCollection entityCollection = this.info.getEntityCollection();
            chartEntity = entityCollection != null ? entityCollection.getEntity(d, d2) : null;
        }
        return chartEntity;
    }

    public void setRefreshBuffer(boolean bl) {
        this.refreshBuffer = bl;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        this.available.setRect(insets.left, insets.top, dimension.getWidth() - (double)insets.left - (double)insets.right, dimension.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean bl = false;
        double d = this.available.getWidth();
        double d2 = this.available.getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (d < (double)this.minimumDrawWidth) {
            this.scaleX = d / (double)this.minimumDrawWidth;
            d = this.minimumDrawWidth;
            bl = true;
        } else if (d > (double)this.maximumDrawWidth) {
            this.scaleX = d / (double)this.maximumDrawWidth;
            d = this.maximumDrawWidth;
            bl = true;
        }
        if (d2 < (double)this.minimumDrawHeight) {
            this.scaleY = d2 / (double)this.minimumDrawHeight;
            d2 = this.minimumDrawHeight;
            bl = true;
        } else if (d2 > (double)this.maximumDrawHeight) {
            this.scaleY = d2 / (double)this.maximumDrawHeight;
            d2 = this.maximumDrawHeight;
            bl = true;
        }
        this.chartArea.setRect(0.0, 0.0, d, d2);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != this.available.getWidth() || (double)this.chartBufferHeight != this.available.getHeight()) {
                this.chartBufferWidth = (int)this.available.getWidth();
                this.chartBufferHeight = (int)this.available.getHeight();
                this.chartBuffer = this.createImage(this.chartBufferWidth, this.chartBufferHeight);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                Graphics2D graphics2D2 = (Graphics2D)this.chartBuffer.getGraphics();
                if (bl) {
                    AffineTransform affineTransform = graphics2D2.getTransform();
                    AffineTransform affineTransform2 = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                    graphics2D2.transform(affineTransform2);
                    this.chart.draw(graphics2D2, this.chartArea, this.info);
                    graphics2D2.setTransform(affineTransform);
                } else {
                    this.chart.draw(graphics2D2, double_, this.info);
                }
                this.refreshBuffer = false;
            }
            graphics2D.drawImage(this.chartBuffer, insets.left, insets.right, this);
        } else {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(insets.left, insets.top);
            if (bl) {
                AffineTransform affineTransform3 = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                graphics2D.transform(affineTransform3);
            }
            this.chart.draw(graphics2D, this.chartArea, this.info);
            graphics2D.setTransform(affineTransform);
        }
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        this.refreshBuffer = true;
        this.repaint();
    }

    public void chartProgress(ChartProgressEvent chartProgressEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("PROPERTIES")) {
            this.attemptEditChartProperties();
        } else if (string.equals("SAVE")) {
            try {
                this.doSaveAs();
            }
            catch (IOException iOException) {
                System.err.println("ChartPanel.doSaveAs: i/o exception = " + iOException.getMessage());
            }
        } else if (string.equals("PRINT")) {
            this.createChartPrintJob();
        } else if (string.equals("ZOOM_IN_BOTH")) {
            this.zoomInBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (string.equals("ZOOM_IN_HORIZONTAL")) {
            this.zoomInHorizontal(this.zoomPoint.getX());
        } else if (string.equals("ZOOM_IN_VERTICAL")) {
            this.zoomInVertical(this.zoomPoint.getY());
        } else if (string.equals("ZOOM_OUT_BOTH")) {
            this.zoomOutBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (string.equals("ZOOM_HORIZONTAL_BOTH")) {
            this.zoomOutHorizontal(this.zoomPoint.getX());
        } else if (string.equals("ZOOM_VERTICAL_BOTH")) {
            this.zoomOutVertical(this.zoomPoint.getY());
        } else if (string.equals("AUTO_RANGE_BOTH")) {
            this.autoRangeBoth();
        } else if (string.equals("AUTO_RANGE_HORIZONTAL")) {
            this.autoRangeHorizontal();
        } else if (string.equals("AUTO_RANGE_VERTICAL")) {
            this.autoRangeVertical();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.zoomRectangle == null) {
            this.zoomPoint = RefineryUtilities.getPointInRectangle(mouseEvent.getX(), mouseEvent.getY(), this.getScaledDataArea());
            if (mouseEvent.isPopupTrigger() && this.popup != null) {
                this.displayPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.zoomRectangle != null) {
            if (Math.abs((double)mouseEvent.getX() - this.zoomPoint.getX()) >= 20.0) {
                if ((double)mouseEvent.getX() < this.zoomPoint.getX() || (double)mouseEvent.getY() < this.zoomPoint.getY()) {
                    this.autoRangeBoth();
                } else {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    Rectangle2D rectangle2D = this.getScaledDataArea();
                    if (!this.verticalZoom) {
                        d4 = this.zoomPoint.getX();
                        d3 = rectangle2D.getMinY();
                        d2 = Math.min(this.zoomRectangle.getWidth(), rectangle2D.getMaxX() - this.zoomPoint.getX());
                        d = rectangle2D.getHeight();
                    } else if (!this.horizontalZoom) {
                        d4 = rectangle2D.getMinX();
                        d3 = this.zoomPoint.getY();
                        d2 = rectangle2D.getWidth();
                        d = Math.min(this.zoomRectangle.getHeight(), rectangle2D.getMaxY() - this.zoomPoint.getY());
                    } else {
                        d4 = this.zoomPoint.getX();
                        d3 = this.zoomPoint.getY();
                        d2 = Math.min(this.zoomRectangle.getWidth(), rectangle2D.getMaxX() - this.zoomPoint.getX());
                        d = Math.min(this.zoomRectangle.getHeight(), rectangle2D.getMaxY() - this.zoomPoint.getY());
                    }
                    Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d3, d2, d);
                    this.zoom(double_);
                }
                this.zoomPoint = null;
                this.zoomRectangle = null;
            } else {
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                graphics2D.setXORMode(Color.gray);
                if (this.fillZoomRectangle) {
                    graphics2D.fill(this.zoomRectangle);
                } else {
                    graphics2D.draw(this.zoomRectangle);
                }
                graphics2D.dispose();
                this.zoomRectangle = null;
            }
        } else if (mouseEvent.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        this.chart.handleClick(n, n2, this.info);
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        object = new ChartMouseEvent(this.getChart(), mouseEvent, chartEntity);
        Iterator iterator = this.chartMouseListeners.iterator();
        while (iterator.hasNext()) {
            ChartMouseListener chartMouseListener = (ChartMouseListener)iterator.next();
            chartMouseListener.chartMouseClicked((ChartMouseEvent)object);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Object object;
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(mouseEvent.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(mouseEvent.getY());
        }
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        object = new ChartMouseEvent(this.getChart(), mouseEvent, chartEntity);
        Iterator iterator = this.chartMouseListeners.iterator();
        while (iterator.hasNext()) {
            ChartMouseListener chartMouseListener = (ChartMouseListener)iterator.next();
            chartMouseListener.chartMouseMoved((ChartMouseEvent)object);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setXORMode(Color.gray);
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                graphics2D.fill(this.zoomRectangle);
            } else {
                graphics2D.draw(this.zoomRectangle);
            }
        }
        Rectangle2D rectangle2D = this.getScaledDataArea();
        if (this.horizontalZoom && this.verticalZoom) {
            double d = Math.min((double)mouseEvent.getX(), rectangle2D.getMaxX());
            double d2 = Math.min((double)mouseEvent.getY(), rectangle2D.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), d - this.zoomPoint.getX(), d2 - this.zoomPoint.getY());
        } else if (this.horizontalZoom) {
            double d = Math.min((double)mouseEvent.getX(), rectangle2D.getMaxX());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), rectangle2D.getMinY(), d - this.zoomPoint.getX(), rectangle2D.getHeight());
        } else if (this.verticalZoom) {
            double d = Math.min((double)mouseEvent.getY(), rectangle2D.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(rectangle2D.getMinX(), this.zoomPoint.getY(), rectangle2D.getWidth(), d - this.zoomPoint.getY());
        }
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                graphics2D.fill(this.zoomRectangle);
            } else {
                graphics2D.draw(this.zoomRectangle);
            }
        }
        graphics2D.dispose();
    }

    public void zoomInBoth(double d, double d2) {
        this.zoomInHorizontal(d);
        this.zoomInVertical(d2);
    }

    private ValueAxis getHorizontalValueAxis(Plot plot) {
        Plot plot2;
        if (plot == null) {
            return null;
        }
        ValueAxis valueAxis = null;
        if (plot instanceof CategoryPlot && ((CategoryPlot)(plot2 = (CategoryPlot)plot)).getOrientation() == PlotOrientation.HORIZONTAL) {
            valueAxis = ((CategoryPlot)plot2).getRangeAxis();
        }
        if (plot instanceof XYPlot) {
            plot2 = (XYPlot)plot;
            if (((XYPlot)plot2).getOrientation() == PlotOrientation.HORIZONTAL) {
                valueAxis = ((XYPlot)plot2).getRangeAxis();
            } else if (((XYPlot)plot2).getOrientation() == PlotOrientation.VERTICAL) {
                valueAxis = ((XYPlot)plot2).getDomainAxis();
            }
        }
        if (plot instanceof FastScatterPlot) {
            plot2 = (FastScatterPlot)plot;
            valueAxis = ((FastScatterPlot)plot2).getDomainAxis();
        }
        return valueAxis;
    }

    private ValueAxis getVerticalValueAxis(Plot plot) {
        Plot plot2;
        if (plot == null) {
            return null;
        }
        ValueAxis valueAxis = null;
        if (plot instanceof CategoryPlot && ((CategoryPlot)(plot2 = (CategoryPlot)plot)).getOrientation() == PlotOrientation.VERTICAL) {
            valueAxis = ((CategoryPlot)plot2).getRangeAxis();
        }
        if (plot instanceof XYPlot) {
            plot2 = (XYPlot)plot;
            if (((XYPlot)plot2).getOrientation() == PlotOrientation.HORIZONTAL) {
                valueAxis = ((XYPlot)plot2).getDomainAxis();
            } else if (((XYPlot)plot2).getOrientation() == PlotOrientation.VERTICAL) {
                valueAxis = ((XYPlot)plot2).getRangeAxis();
            }
        }
        if (plot instanceof FastScatterPlot) {
            plot2 = (FastScatterPlot)plot;
            valueAxis = ((FastScatterPlot)plot2).getRangeAxis();
        }
        return valueAxis;
    }

    public void zoomInHorizontal(double d) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            valueAxisPlot.zoomHorizontalAxes(0.5);
        }
    }

    public void zoomInVertical(double d) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            valueAxisPlot.zoomVerticalAxes(0.5);
        }
    }

    public void zoomOutBoth(double d, double d2) {
        this.zoomOutHorizontal(d);
        this.zoomOutVertical(d2);
    }

    public void zoomOutHorizontal(double d) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            valueAxisPlot.zoomHorizontalAxes(2.0);
        }
    }

    public void zoomOutVertical(double d) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            valueAxisPlot.zoomVerticalAxes(2.0);
        }
    }

    public void zoom(Rectangle2D rectangle2D) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (rectangle2D.getHeight() > 0.0 && rectangle2D.getWidth() > 0.0) {
            Rectangle2D rectangle2D2 = this.getScaledDataArea();
            d = (rectangle2D.getMinX() - rectangle2D2.getMinX()) / rectangle2D2.getWidth();
            d2 = (rectangle2D.getMaxX() - rectangle2D2.getMinX()) / rectangle2D2.getWidth();
            d3 = (rectangle2D2.getMaxY() - rectangle2D.getMaxY()) / rectangle2D2.getHeight();
            d4 = (rectangle2D2.getMaxY() - rectangle2D.getMinY()) / rectangle2D2.getHeight();
            Plot plot = this.chart.getPlot();
            if (plot instanceof ValueAxisPlot) {
                ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
                valueAxisPlot.zoomHorizontalAxes(d, d2);
                valueAxisPlot.zoomVerticalAxes(d3, d4);
            }
        }
    }

    public void autoRangeBoth() {
        this.autoRangeHorizontal();
        this.autoRangeVertical();
    }

    public void autoRangeHorizontal() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            valueAxisPlot.zoomHorizontalAxes(0.0);
        }
    }

    public void autoRangeVertical() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            valueAxisPlot.zoomVerticalAxes(0.0);
        }
    }

    public Rectangle2D getScaledDataArea() {
        Rectangle2D rectangle2D = this.info.getPlotInfo().getDataArea();
        Insets insets = this.getInsets();
        double d = rectangle2D.getX() * this.scaleX + (double)insets.left;
        double d2 = rectangle2D.getY() * this.scaleY + (double)insets.top;
        double d3 = rectangle2D.getWidth() * this.scaleX;
        double d4 = rectangle2D.getHeight() * this.scaleY;
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private void drawHorizontalAxisTrace(int n) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        Rectangle2D rectangle2D = this.getScaledDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinX() < n && n < (int)rectangle2D.getMaxX()) {
            if (this.verticalTraceLine != null) {
                graphics2D.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            }
            graphics2D.draw(this.verticalTraceLine);
        }
    }

    private void drawVerticalAxisTrace(int n) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        Rectangle2D rectangle2D = this.getScaledDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinY() < n && n < (int)rectangle2D.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                graphics2D.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            }
            graphics2D.draw(this.horizontalTraceLine);
        }
    }

    private void attemptEditChartProperties() {
        ChartPropertyEditPanel chartPropertyEditPanel = new ChartPropertyEditPanel(this.chart);
        int n = JOptionPane.showConfirmDialog(this, chartPropertyEditPanel, localizationResources.getString("Chart_Properties"), 2, -1);
        if (n == 0) {
            chartPropertyEditPanel.updateChartProperties(this.chart);
        }
    }

    public void doSaveAs() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(localizationResources.getString("PNG_Image_Files"), ".png");
        jFileChooser.addChoosableFileFilter(extensionFileFilter);
        jFileChooser.addChoosableFileFilter(new ExtensionFileFilter("All files", ""));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            if (this.isEnforceFileExtensions() && !string.endsWith(".png")) {
                string = string + ".png";
            }
            ChartUtilities.saveChartAsPNG(new File(string), this.chart, this.getWidth(), this.getHeight());
        }
    }

    public void createChartPrintJob() {
        PageFormat pageFormat;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat2 = printerJob.pageDialog(pageFormat = printerJob.defaultPage());
        if (pageFormat2 != pageFormat) {
            printerJob.setPrintable(this, pageFormat2);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog(this, printerException);
                }
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        this.chart.draw(graphics2D, new Rectangle2D.Double(d, d2, d3, d4), null);
        return 0;
    }

    public void addChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartMouseListeners.add(chartMouseListener);
    }

    public void removeChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartMouseListeners.remove(chartMouseListener);
    }

    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu("Chart:");
        boolean bl5 = false;
        if (bl) {
            jMenuItem = new JMenuItem(localizationResources.getString("Properties..."));
            jMenuItem.setActionCommand("PROPERTIES");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl2) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenuItem(localizationResources.getString("Save_as..."));
            jMenuItem.setActionCommand("SAVE");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl3) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenuItem(localizationResources.getString("Print..."));
            jMenuItem.setActionCommand("PRINT");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl4) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenu(localizationResources.getString("Zoom_In"));
            this.zoomInBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomInBothMenuItem.setActionCommand("ZOOM_IN_BOTH");
            this.zoomInBothMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInBothMenuItem);
            ((JMenu)jMenuItem).addSeparator();
            this.zoomInHorizontalMenuItem = new JMenuItem(localizationResources.getString("Horizontal_Axis"));
            this.zoomInHorizontalMenuItem.setActionCommand("ZOOM_IN_HORIZONTAL");
            this.zoomInHorizontalMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInHorizontalMenuItem);
            this.zoomInVerticalMenuItem = new JMenuItem(localizationResources.getString("Vertical_Axis"));
            this.zoomInVerticalMenuItem.setActionCommand("ZOOM_IN_VERTICAL");
            this.zoomInVerticalMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInVerticalMenuItem);
            jPopupMenu.add(jMenuItem);
            JMenu jMenu = new JMenu(localizationResources.getString("Zoom_Out"));
            this.zoomOutBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomOutBothMenuItem.setActionCommand("ZOOM_OUT_BOTH");
            this.zoomOutBothMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutBothMenuItem);
            jMenu.addSeparator();
            this.zoomOutHorizontalMenuItem = new JMenuItem(localizationResources.getString("Horizontal_Axis"));
            this.zoomOutHorizontalMenuItem.setActionCommand("ZOOM_HORIZONTAL_BOTH");
            this.zoomOutHorizontalMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutHorizontalMenuItem);
            this.zoomOutVerticalMenuItem = new JMenuItem(localizationResources.getString("Vertical_Axis"));
            this.zoomOutVerticalMenuItem.setActionCommand("ZOOM_VERTICAL_BOTH");
            this.zoomOutVerticalMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutVerticalMenuItem);
            jPopupMenu.add(jMenu);
            JMenu jMenu2 = new JMenu(localizationResources.getString("Auto_Range"));
            this.autoRangeBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.autoRangeBothMenuItem.setActionCommand("AUTO_RANGE_BOTH");
            this.autoRangeBothMenuItem.addActionListener(this);
            jMenu2.add(this.autoRangeBothMenuItem);
            jMenu2.addSeparator();
            this.autoRangeHorizontalMenuItem = new JMenuItem(localizationResources.getString("Horizontal_Axis"));
            this.autoRangeHorizontalMenuItem.setActionCommand("AUTO_RANGE_HORIZONTAL");
            this.autoRangeHorizontalMenuItem.addActionListener(this);
            jMenu2.add(this.autoRangeHorizontalMenuItem);
            this.autoRangeVerticalMenuItem = new JMenuItem(localizationResources.getString("Vertical_Axis"));
            this.autoRangeVerticalMenuItem.setActionCommand("AUTO_RANGE_VERTICAL");
            this.autoRangeVerticalMenuItem.addActionListener(this);
            jMenu2.add(this.autoRangeVerticalMenuItem);
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenu2);
        }
        return jPopupMenu;
    }

    protected void displayPopupMenu(int n, int n2) {
        if (this.popup != null) {
            boolean bl;
            Plot plot = this.chart.getPlot();
            ValueAxis valueAxis = this.getHorizontalValueAxis(plot);
            boolean bl2 = valueAxis != null;
            ValueAxis valueAxis2 = this.getVerticalValueAxis(plot);
            boolean bl3 = bl = valueAxis2 != null;
            if (this.zoomInHorizontalMenuItem != null) {
                this.zoomInHorizontalMenuItem.setEnabled(bl2);
            }
            if (this.zoomOutHorizontalMenuItem != null) {
                this.zoomOutHorizontalMenuItem.setEnabled(bl2);
            }
            if (this.autoRangeHorizontalMenuItem != null) {
                this.autoRangeHorizontalMenuItem.setEnabled(bl2);
            }
            if (this.zoomInVerticalMenuItem != null) {
                this.zoomInVerticalMenuItem.setEnabled(bl);
            }
            if (this.zoomOutVerticalMenuItem != null) {
                this.zoomOutVerticalMenuItem.setEnabled(bl);
            }
            if (this.autoRangeVerticalMenuItem != null) {
                this.autoRangeVerticalMenuItem.setEnabled(bl);
            }
            if (this.zoomInBothMenuItem != null) {
                this.zoomInBothMenuItem.setEnabled(bl2 & bl);
            }
            if (this.zoomOutBothMenuItem != null) {
                this.zoomOutBothMenuItem.setEnabled(bl2 & bl);
            }
            if (this.autoRangeBothMenuItem != null) {
                this.autoRangeBothMenuItem.setEnabled(bl2 & bl);
            }
            this.popup.show(this, n, n2);
        }
    }
}

