/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.py;

import csplugins.isb.pshannon.py.CommandLineOptions;
import csplugins.isb.pshannon.py.ConsoleMenubar;
import csplugins.isb.pshannon.py.OutputBuffer;
import csplugins.isb.pshannon.py.PasteAction;
import csplugins.isb.pshannon.py.Styles;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyledEditorKit;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.util.InteractiveConsole;

public class SPyConsole
extends InteractiveConsole {
    JFrame appFrame = null;
    Styles _styles = new Styles();
    StyledEditorKit.ForegroundAction _inputAction;
    DefaultStyledDocument _document;
    CommandLineOptions _opts = new CommandLineOptions();
    JTextPane _textpane;
    Vector _history = new Vector();
    Vector _initCommands = new Vector();
    Vector _killRing = new Vector();
    int _oldHistoryLength = 0;
    int _historyPosition = 0;
    int _completionIndex = 0;
    int _killRingPosition = 0;
    int _localNameSpaceCompletionIndex = -1;
    int _completionOffset = -1;
    int _completionCursorOffset;
    String _completionBuffer;
    StringBuffer _buff = new StringBuffer();
    boolean _waitingForInput = false;
    boolean _debug = true;
    Position _startInput;
    Keymap _keymap;
    Hashtable _actionTable = new Hashtable();
    private static String _usage = "usage: jython [options] [-jar jar | -c cmd | file | -] [args]\nOptions and arguments:\n-i       : inspect interactively after running script, and force\n           prompts, even if stdin does not appear to be a terminal\n-S       : don't imply `import site' on initialization\n-X       : disable class based standard exceptions\n-Dprop=v : Set the property `prop' to value `v'\n-c cmd   : program passed in as string (terminates option list)\nfile     : program read from script file\n-        : program read from stdin (default; interactive mode if a tty)\n--help   : print this usage message and exit\n--version: print Jython version number and exit\nargs     : arguments passed to program in sys.argv[1:]";

    public SPyConsole() {
        this.addStyles();
        this._inputAction = new StyledEditorKit.ForegroundAction("start input", Color.black);
        this._document = new DefaultStyledDocument(this._styles);
        this._document.setLogicalStyle(0, this._styles.getStyle("normal"));
        this._textpane = new JTextPane(this._document);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
            }
        };
        this._textpane.addMouseListener(mouseAdapter);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                SPyConsole.this.processKeyPress(keyEvent);
            }
        };
        this._textpane.addKeyListener(keyAdapter);
        this.defineKeymap();
    }

    void addStyles() {
        Style style = this._styles.addBase("normal", 3, 12, "Courier");
        this._styles.addDerived("error", style, Color.red);
        this._styles.addDerived("output", style, Color.blue);
        this._styles.addDerived("input", style, Color.black);
        this._styles.addDerived("prompt", style, Color.magenta);
    }

    public void processKeyPress(KeyEvent keyEvent) {
        int n = this._startInput.getOffset() + 1;
        int n2 = this._textpane.getCaretPosition();
        if (n2 < n) {
            System.out.println("caret smaller than start, setting position:");
            System.out.println("line start: " + n + "  caret_pos: " + n2);
            int n3 = this._textpane.getText().length();
            System.out.println("document length: " + n3);
            if (n <= n3) {
                this._textpane.setCaretPosition(n);
            }
        }
    }

    KeyStroke setActionForKeyStroke(int n, int n2, Action action) {
        KeyStroke[] keyStrokeArray;
        if (this._keymap == null) {
            this._keymap = JTextComponent.getKeymap("default");
            if (this._debug) {
                System.out.println("DEFAULT_KEYMAP:");
                keyStrokeArray = this._keymap.getBoundKeyStrokes();
                for (int i = 0; i < keyStrokeArray.length; ++i) {
                    KeyStroke keyStroke = keyStrokeArray[i];
                    Action action2 = this._keymap.getAction(keyStroke);
                    System.out.println(keyStroke.toString() + " : " + action2.getValue("Name"));
                }
            }
        }
        keyStrokeArray = KeyStroke.getKeyStroke(n, n2);
        this._keymap.removeKeyStrokeBinding((KeyStroke)keyStrokeArray);
        this._keymap.addActionForKeyStroke((KeyStroke)keyStrokeArray, action);
        return keyStrokeArray;
    }

    KeyStroke setActionForKeyStroke(int n, Action action) {
        return this.setActionForKeyStroke(n, 0, action);
    }

    KeyStroke setActionForKeyStroke(int n, int n2, String string) {
        if (this._keymap == null) {
            this._keymap = JTextComponent.getKeymap("default");
        }
        Action action = this.getAction(string);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        this._keymap.removeKeyStrokeBinding(keyStroke);
        this._keymap.addActionForKeyStroke(keyStroke, action);
        return keyStroke;
    }

    KeyStroke setActionForKeyStroke(int n, String string) {
        return this.setActionForKeyStroke(n, 0, string);
    }

    void defineKeymap() {
        this.loadActionTable();
        this.setActionForKeyStroke(9, new TabAction());
        this.setActionForKeyStroke(225, new DownHistoryAction());
        this.setActionForKeyStroke(224, new UpHistoryAction());
        this.setActionForKeyStroke(226, new CaretMoveAction(-1));
        this.setActionForKeyStroke(227, new CaretMoveAction(1));
        this.setActionForKeyStroke(37, new CaretMoveAction(-1));
        this.setActionForKeyStroke(39, new CaretMoveAction(1));
        this.setActionForKeyStroke(40, new DownHistoryAction());
        this.setActionForKeyStroke(38, new UpHistoryAction());
        this.setActionForKeyStroke(10, new EnterAction());
        this.setActionForKeyStroke(27, new EscapeAction());
        this.setActionForKeyStroke(127, new DeleteCharAction(-1));
        this.setActionForKeyStroke(78, 2, new DownHistoryAction());
        this.setActionForKeyStroke(80, 2, new UpHistoryAction());
        this.setActionForKeyStroke(70, 2, new CaretMoveAction(1));
        this.setActionForKeyStroke(66, 2, new CaretMoveAction(-1));
        this.setActionForKeyStroke(65, 2, new CaretMoveAction(-2));
        this.setActionForKeyStroke(69, 2, new CaretMoveAction(2));
        this.setActionForKeyStroke(68, 2, new DeleteCharAction(1));
        this.setActionForKeyStroke(89, 2, new YankLineAction());
        this.setActionForKeyStroke(75, 2, new KillLineAction(true, true));
        this.setActionForKeyStroke(88, 2, "cut-to-clipboard");
        this.setActionForKeyStroke(67, 2, "copy-to-clipboard");
        this.setActionForKeyStroke(86, 2, new PasteAction(this));
        this.setActionForKeyStroke(87, 2, new KillLineAction(false, true));
        this._textpane.setKeymap(this._keymap);
    }

    void loadActionTable() {
        Action[] actionArray = this._textpane.getActions();
        if (this._debug) {
            System.out.println("Action table:");
        }
        for (int i = 0; i < actionArray.length; ++i) {
            String string = (String)actionArray[i].getValue("Name");
            this._actionTable.put(string, actionArray[i]);
        }
    }

    public Action getAction(String string) {
        return (Action)this._actionTable.get(string);
    }

    public String raw_input(PyObject pyObject) {
        String string = ((PyString)pyObject).toString();
        this.startUserInput(string);
        this.waitForInput();
        return this.getInput();
    }

    public JTextPane getTextPane() {
        return this._textpane;
    }

    public void write(String string, String string2) {
        Style style = this._styles.getStyle(string2);
        try {
            this._document.insertString(this._document.getLength(), string, style);
        }
        catch (BadLocationException badLocationException) {
            if (string2.equals("error")) {
                System.out.println("\n" + badLocationException.getMessage());
            }
            this.error("Text write error", badLocationException);
        }
    }

    public void error(String string, Exception exception) {
        if (this._debug) {
            exception.printStackTrace();
        }
        String string2 = string + ": " + exception.getMessage();
        try {
            this.write(string2, "error");
        }
        catch (Exception exception2) {
            System.out.println("\n" + string2);
        }
    }

    public void error(String string) {
        this.write(string, "error");
    }

    public void output(String string) {
        this.write(string, "output");
    }

    void waitForInput() {
        this._waitingForInput = true;
        while (this._waitingForInput) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public void beep() {
        this._textpane.getToolkit().beep();
    }

    public String getLocalNameSpace() {
        PyStringMap pyStringMap = (PyStringMap)this.getLocals();
        PyList pyList = pyStringMap.keys();
        PyString pyString = pyList.__str__();
        return pyString.toString();
    }

    public String completeNameFromLocalNameSpace(String string) {
        PyStringMap pyStringMap = (PyStringMap)this.getLocals();
        PyList pyList = pyStringMap.keys();
        int n = string.lastIndexOf(32);
        if (n > 0) {
            string = string.substring(n + 1);
            if (this._completionOffset == -1) {
                this._completionOffset = this._completionCursorOffset - string.length();
            }
        }
        while (++this._localNameSpaceCompletionIndex < pyList.__len__()) {
            PyString pyString = (PyString)pyList.__getitem__(this._localNameSpaceCompletionIndex);
            String string2 = pyString.toString();
            if (!string2.startsWith(string)) continue;
            PyObject pyObject = pyStringMap.get(pyString);
            if (pyObject.isCallable()) {
                string2 = string2 + "()";
            }
            return string2;
        }
        return null;
    }

    public void deleteChar(int n) {
        int n2 = this._document.getLength();
        int n3 = this._startInput.getOffset() + 1;
        int n4 = this._textpane.getCaretPosition();
        try {
            switch (n) {
                case 1: {
                    if (n4 < n2) {
                        this._document.remove(n4, 1);
                        break;
                    }
                    this.beep();
                    break;
                }
                case -1: {
                    if (n4 > n3) {
                        this._document.remove(n4 - 1, 1);
                        break;
                    }
                    this.beep();
                }
            }
        }
        catch (BadLocationException badLocationException) {
            this.error("Text write error", badLocationException);
        }
    }

    public void moveCaret(int n) {
        int n2 = this._document.getLength();
        int n3 = this._startInput.getOffset() + 1;
        int n4 = this._textpane.getCaretPosition();
        switch (n) {
            case 1: {
                if (n4 >= n2) break;
                this._textpane.setCaretPosition(n4 + 1);
                break;
            }
            case 2: {
                this._textpane.setCaretPosition(n2);
                break;
            }
            case -1: {
                if (n4 <= n3) break;
                this._textpane.setCaretPosition(n4 - 1);
                break;
            }
            case -2: {
                this._textpane.setCaretPosition(n3);
            }
        }
    }

    String trimEnd(String string) {
        int n;
        boolean bl = false;
        for (n = string.length() - 1; n >= 0 && Character.isWhitespace(string.charAt(n)); --n) {
            bl = true;
        }
        return bl ? (n < 0 ? "" : string.substring(0, n + 1)) : string;
    }

    public void completeInput() {
        int n = this._startInput.getOffset();
        try {
            if (this._completionBuffer == null) {
                this._completionCursorOffset = this._document.getLength();
                this._completionBuffer = this._document.getText(n + 1, this._completionCursorOffset - n);
                this._completionBuffer = this._completionBuffer.trim();
            }
            int n2 = this._history.size();
            while (this._completionIndex++ < n2) {
                int n3 = n2 - this._completionIndex;
                String string = (String)this._history.get(n3);
                System.out.println(" complete Input test(" + n3 + "): " + string);
                if (!string.startsWith(this._completionBuffer)) continue;
                this.replaceInput(string);
                return;
            }
            String string = this.completeNameFromLocalNameSpace(this._completionBuffer);
            if (string != null) {
                this.replaceInput(string);
                return;
            }
            this.beep();
        }
        catch (BadLocationException badLocationException) {
            this.error("Text completion error", badLocationException);
        }
    }

    public void killLine(boolean bl, boolean bl2) {
        Object object;
        ActionEvent actionEvent = new ActionEvent(this._textpane, 1001, "select line");
        Action action = this.getAction("selection-end-line");
        action.actionPerformed(actionEvent);
        if (bl) {
            object = this._textpane.getSelectedText();
            this._killRing.add(object);
            this._killRingPosition = this._killRing.size();
        }
        if (bl2) {
            object = new ActionEvent(this._textpane, 1001, "cut");
            Action action2 = this.getAction("cut-to-clipboard");
            action2.actionPerformed((ActionEvent)object);
        }
    }

    public void yankLine() {
        if (this._killRing.size() == 0) {
            this.beep();
            return;
        }
        if (this._killRingPosition == 0) {
            this._killRingPosition = this._killRing.size();
        }
        this.replaceInput((String)this._killRing.get(--this._killRingPosition));
    }

    public void replaceInput(String string) {
        int n = this._completionOffset < 0 ? this._startInput.getOffset() + 1 : this._completionOffset;
        int n2 = this._document.getLength() - n;
        try {
            this._document.remove(n, n2);
        }
        catch (BadLocationException badLocationException) {
            this.error("Text write error", badLocationException);
        }
        this.write(string, "input");
    }

    public boolean executeCommand(String string) {
        return this.executeCommand(string, true);
    }

    public boolean executeCommand(String string, boolean bl) {
        if (bl) {
            while (!this._waitingForInput) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }
        if (this._waitingForInput) {
            this.replaceInput(string);
            this.write("\n", "input");
            this._waitingForInput = false;
            return true;
        }
        this.beep();
        return false;
    }

    public boolean executeCommandSet(String string) {
        boolean bl = true;
        try {
            String string2;
            StringReader stringReader = new StringReader(string);
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (this.executeCommand(string2)) continue;
                bl = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    public PyObject compile(InputStream inputStream, String string) {
        return Py.compile(inputStream, string, "exec");
    }

    public void addInitCommand(String string) {
        this._initCommands.add(string);
    }

    public void getHistory(int n) {
        int n2 = this._history.size();
        int n3 = this._historyPosition + n;
        if (0 <= n3 && n3 < n2) {
            this._historyPosition = n3;
            this.replaceInput((String)this._history.get(n3));
        } else {
            this.beep();
        }
    }

    public void capturePythonOutput() {
        this.setOut(new OutputBuffer(this, "output"));
        this.setErr(new OutputBuffer(this, "error"));
    }

    public JScrollPane getConsolePanel() {
        return new JScrollPane(this.getTextPane());
    }

    public void runShell() {
        String string;
        String string2;
        block14: {
            string2 = "SME Python Shell (SPyConsole)\nJython " + PySystemState.version + " on platform " + PySystemState.platform;
            this.capturePythonOutput();
            this.getTextPane().requestFocus();
            PyModule pyModule = imp.addModule("__main__");
            this.setLocals(pyModule.__dict__);
            if (Options.importSite) {
                try {
                    imp.load("site");
                }
                catch (PyException pyException) {
                    if (Py.matchException(pyException, Py.ImportError)) break block14;
                    System.err.println("error importing site");
                    Py.printException(pyException);
                }
            }
        }
        if (this._opts.command != null) {
            try {
                this.exec(this._opts.command);
            }
            catch (Throwable throwable) {
                Py.printException(throwable);
            }
        }
        Iterator iterator = this._initCommands.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (this._debug) {
                System.out.println("Processing init cmd: " + string);
            }
            try {
                this.exec(string);
            }
            catch (Throwable throwable) {
                Py.printException(throwable);
            }
        }
        if (this._opts.filename != null) {
            string = new File(this._opts.filename).getParent();
            if (string == null) {
                string = "";
            }
            Py.getSystemState().path.insert(0, new PyString(string));
            try {
                this.execfile(this._opts.filename);
            }
            catch (Throwable throwable) {
                Py.printException(throwable);
            }
        }
        this.interact(string2);
    }

    public void processArgs(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{new String("-i")};
        }
        if (!this._opts.parse(stringArray)) {
            if (this._opts.version) {
                System.err.println(InteractiveConsole.getDefaultBanner());
                System.exit(0);
            }
            System.err.println(_usage);
            int n = this._opts.help ? 0 : -1;
            System.exit(n);
        }
        PySystemState.initialize(System.getProperties(), this._opts.properties, this._opts.argv);
    }

    public JFrame getAppFrame() {
        return this.appFrame;
    }

    public void setAppFrame(JFrame jFrame) {
        this.appFrame = jFrame;
    }

    public static void main(String[] stringArray) {
        SPyConsole sPyConsole = new SPyConsole();
        sPyConsole.processArgs(stringArray);
        sPyConsole.appFrame = new JFrame("Jython Console");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        sPyConsole.appFrame.addWindowListener(windowAdapter);
        sPyConsole.appFrame.getContentPane().add((Component)sPyConsole.getConsolePanel(), "Center");
        sPyConsole.appFrame.setJMenuBar(new ConsoleMenubar(sPyConsole));
        sPyConsole.appFrame.setSize(900, 600);
        sPyConsole.appFrame.setVisible(true);
        sPyConsole.runShell();
    }

    public String getText() {
        this._buff.setLength(0);
        String string = System.getProperty("line.separator");
        Iterator iterator = this._history.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.length() <= 0) continue;
            this._buff.append(string2);
            this._buff.append(string);
        }
        return this._buff.toString();
    }

    public String getInput() {
        int n = this._startInput.getOffset();
        try {
            String string = this.trimEnd(this._document.getText(n + 1, this._document.getLength() - n));
            this.registerNewInput(string);
            return string;
        }
        catch (BadLocationException badLocationException) {
            this.error("Text write error", badLocationException);
            return null;
        }
    }

    void registerNewInput(String string) {
        this._history.add(string);
        this._historyPosition = this._history.size();
        this._completionIndex = 0;
        this._localNameSpaceCompletionIndex = -1;
        this._completionOffset = -1;
        this._completionBuffer = null;
    }

    public void startUserInput(String string) {
        this.write(string, "prompt");
        try {
            this._startInput = this._document.createPosition(this._document.getLength() - 1);
        }
        catch (BadLocationException badLocationException) {
            this.error("Text write error", badLocationException);
        }
        this._textpane.setCaretPosition(this._document.getLength());
        ActionEvent actionEvent = new ActionEvent(this._textpane, 1001, "start input");
        this._inputAction.actionPerformed(actionEvent);
    }

    class YankLineAction
    extends AbstractAction {
        YankLineAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SPyConsole.this.yankLine();
        }
    }

    class KillLineAction
    extends AbstractAction {
        boolean _addToKillRing;
        boolean _removeText;

        public KillLineAction(boolean bl, boolean bl2) {
            this._addToKillRing = bl;
            this._removeText = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SPyConsole.this.killLine(this._addToKillRing, this._removeText);
        }
    }

    class DeleteCharAction
    extends AbstractAction {
        int _dir;

        public DeleteCharAction(int n) {
            this._dir = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SPyConsole.this.deleteChar(this._dir);
        }
    }

    class CaretMoveAction
    extends AbstractAction {
        int _dir;

        public CaretMoveAction(int n) {
            this._dir = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SPyConsole.this.moveCaret(this._dir);
        }
    }

    class DownHistoryAction
    extends AbstractAction {
        DownHistoryAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SPyConsole.this.getHistory(1);
        }
    }

    class UpHistoryAction
    extends AbstractAction {
        UpHistoryAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SPyConsole.this.getHistory(-1);
        }
    }

    class EscapeAction
    extends AbstractAction {
        EscapeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SPyConsole.this._waitingForInput = false;
        }
    }

    class TabAction
    extends AbstractAction {
        TabAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SPyConsole.this.write("   ", "input");
        }
    }

    class EnterAction
    extends AbstractAction {
        EnterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SPyConsole.this._waitingForInput = false;
            SPyConsole.this.write("\n", "input");
        }
    }
}

