/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.dataMatrix.unitTests;

import csplugins.isb.pshannon.dataMatrix.DataMatrix;
import csplugins.isb.pshannon.dataMatrix.DataMatrixFileReader;
import csplugins.isb.pshannon.dataMatrix.DataMatrixLens;
import csplugins.isb.pshannon.dataMatrix.DataMatrixReader;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DataMatrixLensTest
extends TestCase {
    static /* synthetic */ Class class$csplugins$isb$pshannon$dataMatrix$unitTests$DataMatrixLensTest;

    public DataMatrixLensTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testColumnEnabling() throws Exception {
        System.out.println("testColumnEnabling");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", "simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        DataMatrixLensTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        DataMatrixLensTest.assertTrue((dataMatrix.getColumnCount() == 3 ? 1 : 0) != 0);
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        boolean[] blArray = dataMatrixLens.getColumnState();
        DataMatrixLensTest.assertTrue((blArray.length == 3 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((blArray[0] ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((blArray[1] ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((blArray[2] ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnState(0) ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnState(1) ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnState(2) ? 1 : 0) != 0);
        dataMatrixLens.setColumnState(1, false);
        DataMatrixLensTest.assertTrue((!dataMatrixLens.getColumnState(1) ? 1 : 0) != 0);
        blArray = dataMatrixLens.getColumnState();
        DataMatrixLensTest.assertTrue((blArray[0] ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((!blArray[1] ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((blArray[2] ? 1 : 0) != 0);
        dataMatrixLens.setColumnState(0, false);
        dataMatrixLens.setColumnState(2, false);
        DataMatrixLensTest.assertTrue((blArray.length == 3 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((!dataMatrixLens.getColumnState(0) ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((!dataMatrixLens.getColumnState(1) ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((!dataMatrixLens.getColumnState(2) ? 1 : 0) != 0);
        dataMatrixLens.clear();
        DataMatrixLensTest.assertTrue((blArray.length == 3 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnState(0) ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnState(1) ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnState(2) ? 1 : 0) != 0);
    }

    public void testColumnOrdering() throws Exception {
        System.out.println("testColumnOrdering");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", "simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        DataMatrixLensTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getEnabledColumnCount() == 3 ? 1 : 0) != 0);
        for (int i = 0; i < dataMatrixLens.getEnabledColumnCount(); ++i) {
            DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(i) == i ? 1 : 0) != 0);
        }
        dataMatrixLens.swapColumnOrder(0, 2);
        dataMatrixLens.swapColumnOrder(2, 1);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(0) == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(1) == 0 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(2) == 1 ? 1 : 0) != 0);
    }

    public void testGetDataWithOrderingAndEnabling_1() throws Exception {
        System.out.println("testGetDataWithOrderingAndEnabling_1");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", "simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        DataMatrixLensTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        String string = dataMatrix.toString();
        String string2 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        DataMatrixLensTest.assertTrue((boolean)string2.equals(string));
        dataMatrixLens.swapColumnOrder(0, 2);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(0) == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(1) == 1 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(2) == 0 ? 1 : 0) != 0);
        double[] dArray = dataMatrixLens.getFromAll(0);
        DataMatrixLensTest.assertTrue((dArray.length == 3 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[0] == 4.0 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[1] == 13.8 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[2] == 12.2 ? 1 : 0) != 0);
        dataMatrixLens.setColumnState(0, false);
        dArray = dataMatrixLens.getFromAll(0);
        DataMatrixLensTest.assertTrue((dArray.length == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[0] == 13.8 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[1] == 12.2 ? 1 : 0) != 0);
        dataMatrixLens.setColumnState(0, true);
        dataMatrixLens.setColumnState(1, true);
        dataMatrixLens.setColumnState(2, true);
    }

    public void testGetDataWithOrderingAndEnabling_2() throws Exception {
        System.out.println("testGetDataWithOrderingAndEnabling_2");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", "simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        DataMatrixLensTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        String string = dataMatrix.toString();
        String string2 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        dataMatrixLens.swapColumnOrder(0, 2);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(0) == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(1) == 1 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(2) == 0 ? 1 : 0) != 0);
        double[] dArray = dataMatrixLens.getFromAll(0);
        DataMatrixLensTest.assertTrue((dArray[0] == 4.0 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[1] == 13.8 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[2] == 12.2 ? 1 : 0) != 0);
        dataMatrixLens.setColumnState(0, true);
        dataMatrixLens.setColumnState(1, false);
        dArray = dataMatrixLens.getFromAll(0);
        DataMatrixLensTest.assertTrue((dArray[0] == 4.0 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[1] == 12.2 ? 1 : 0) != 0);
    }

    public void testGetDataWithOrderingAndEnabling_3() throws Exception {
        System.out.println("testGetDataWithOrderingAndEnabling_3");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", "simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        DataMatrixLensTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        String string = dataMatrix.toString();
        String string2 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        double[] dArray = dataMatrixLens.getFromAll(0);
        DataMatrixLensTest.assertTrue((dArray[0] == 12.2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[1] == 13.8 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[2] == 4.0 ? 1 : 0) != 0);
        dataMatrixLens.swapColumnOrder(1, 2);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(0) == 0 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(1) == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(2) == 1 ? 1 : 0) != 0);
        dArray = dataMatrixLens.getFromAll(0);
        DataMatrixLensTest.assertTrue((dArray[0] == 12.2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[1] == 4.0 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[2] == 13.8 ? 1 : 0) != 0);
        dataMatrixLens.swapColumnOrder(0, 1);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(0) == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(1) == 0 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getColumnOrder(2) == 1 ? 1 : 0) != 0);
        dArray = dataMatrixLens.getFromAll(0);
        DataMatrixLensTest.assertTrue((dArray[0] == 4.0 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[1] == 12.2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dArray[2] == 13.8 ? 1 : 0) != 0);
    }

    public void testColumnTitleLensing() throws Exception {
        System.out.println("testColumnTitleLensing");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", "simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        DataMatrixLensTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        String string = dataMatrix.toString();
        String string2 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        String[] stringArray = dataMatrixLens.getAllColumnTitles();
        String[] stringArray2 = dataMatrixLens.getFilteredColumnTitles();
        DataMatrixLensTest.assertTrue((stringArray2.length == 3 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((boolean)stringArray2[0].equals("cond0"));
        DataMatrixLensTest.assertTrue((boolean)stringArray2[1].equals("cond1"));
        DataMatrixLensTest.assertTrue((boolean)stringArray2[2].equals("cond2"));
        dataMatrixLens.setColumnState(1, false);
        String[] stringArray3 = dataMatrixLens.getFilteredColumnTitles();
        DataMatrixLensTest.assertTrue((stringArray3.length == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((boolean)stringArray3[0].equals("cond0"));
        DataMatrixLensTest.assertTrue((boolean)stringArray3[1].equals("cond2"));
        dataMatrixLens.setColumnState(1, true);
        dataMatrixLens.swapColumnOrder(0, 1);
        String[] stringArray4 = dataMatrixLens.getFilteredColumnTitles();
        DataMatrixLensTest.assertTrue((stringArray4.length == 3 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((boolean)stringArray4[0].equals("cond1"));
        DataMatrixLensTest.assertTrue((boolean)stringArray4[1].equals("cond0"));
        DataMatrixLensTest.assertTrue((boolean)stringArray4[2].equals("cond2"));
        dataMatrixLens.swapColumnOrder(1, 2);
        String[] stringArray5 = dataMatrixLens.getFilteredColumnTitles();
        DataMatrixLensTest.assertTrue((stringArray5.length == 3 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((boolean)stringArray5[0].equals("cond1"));
        DataMatrixLensTest.assertTrue((boolean)stringArray5[1].equals("cond2"));
        DataMatrixLensTest.assertTrue((boolean)stringArray5[2].equals("cond0"));
        dataMatrixLens.setColumnState(1, false);
        String[] stringArray6 = dataMatrixLens.getFilteredColumnTitles();
        DataMatrixLensTest.assertTrue((stringArray6.length == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((boolean)stringArray6[0].equals("cond1"));
        DataMatrixLensTest.assertTrue((boolean)stringArray6[1].equals("cond0"));
        String string3 = dataMatrixLens.toString();
        String string4 = "gene\tcond1\tcond0\na\t13.8\t12.2\nb\t-8.0\t-1.2\nc\t0.0\t0.0\nd\t99.0\t999.0\n";
        DataMatrixLensTest.assertTrue((boolean)string4.equals(string3));
    }

    public void testRowSelection_1() throws Exception {
        System.out.println("testRowSelection_1");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", "simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        DataMatrixLensTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        dataMatrixLens.setSelectedRows(new int[0]);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getSelectedRowCount() == 0 ? 1 : 0) != 0);
        dataMatrixLens.setSelectedRows(new int[]{3, 1});
        DataMatrixLensTest.assertTrue((dataMatrixLens.getSelectedRowCount() == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertFalse((dataMatrixLens.getSelectedRowCount() == dataMatrixLens.getRawRowCount() ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getFromSelected(0, 2) == 9.0 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getEnabledColumnCount() == 3 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getEnabledColumnCount() == dataMatrixLens.getFilteredColumnTitles().length ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getFilteredColumnTitles().length == 3 ? 1 : 0) != 0);
        dataMatrixLens.setColumnState(1, false);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getEnabledColumnCount() == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getFilteredColumnTitles().length == 2 ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((dataMatrixLens.getFromSelected(0, 1) == 9.0 ? 1 : 0) != 0);
        String[] stringArray = dataMatrixLens.getSelectedRowTitles();
        DataMatrixLensTest.assertTrue((stringArray.length == dataMatrixLens.getSelectedRowCount() ? 1 : 0) != 0);
        DataMatrixLensTest.assertTrue((boolean)stringArray[1].equals("b"));
        DataMatrixLensTest.assertTrue((boolean)stringArray[0].equals("d"));
        String string = "gene\tcond0\tcond2\nd\t999.0\t9.0\nb\t-1.2\t-32.3333\n";
        DataMatrixLensTest.assertTrue((boolean)dataMatrixLens.toString(false).equals(string));
    }

    public void testGetSelectedSubMatrix() throws Exception {
        System.out.println("testGetSelectedSubMatrix");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", "simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        DataMatrixLensTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        String string = dataMatrix.toString();
        String string2 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        dataMatrixLens.selectAllRows();
        DataMatrix dataMatrix2 = dataMatrixLens.getSelectedSubMatrix();
        DataMatrixLensTest.assertTrue((boolean)dataMatrix.equals(dataMatrix2));
        dataMatrixLens.setSelectedRows(new int[]{1, 2});
        DataMatrix dataMatrix3 = dataMatrixLens.getSelectedSubMatrix();
        DataMatrixLensTest.assertTrue((boolean)Arrays.equals(dataMatrix3.getRowTitles(), new String[]{"b", "c"}));
        DataMatrixLensTest.assertTrue((boolean)Arrays.equals(dataMatrix3.getColumnTitles(), new String[]{"cond0", "cond1", "cond2"}));
        DataMatrixLensTest.assertTrue((boolean)Arrays.equals(dataMatrix3.get(0), new double[]{-1.2, -8.0, -32.3333}));
        DataMatrixLensTest.assertTrue((boolean)Arrays.equals(dataMatrix3.get(1), new double[]{0.0, 0.0, 0.0}));
        dataMatrixLens.setColumnState(0, false);
        DataMatrix dataMatrix4 = dataMatrixLens.getSelectedSubMatrix();
        DataMatrixLensTest.assertTrue((boolean)Arrays.equals(dataMatrix4.getColumnTitles(), new String[]{"cond1", "cond2"}));
        DataMatrixLensTest.assertTrue((boolean)Arrays.equals(dataMatrix4.get(0), new double[]{-8.0, -32.3333}));
        DataMatrixLensTest.assertTrue((boolean)Arrays.equals(dataMatrix4.get(1), new double[]{0.0, 0.0}));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(class$csplugins$isb$pshannon$dataMatrix$unitTests$DataMatrixLensTest == null ? (class$csplugins$isb$pshannon$dataMatrix$unitTests$DataMatrixLensTest = DataMatrixLensTest.class$("csplugins.isb.pshannon.dataMatrix.unitTests.DataMatrixLensTest")) : class$csplugins$isb$pshannon$dataMatrix$unitTests$DataMatrixLensTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

