/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.dataMatrix.gui.actions.unitTests;

import csplugins.isb.pshannon.dataMatrix.DataMatrix;
import csplugins.isb.pshannon.dataMatrix.DataMatrixFileReader;
import csplugins.isb.pshannon.dataMatrix.DataMatrixLens;
import csplugins.isb.pshannon.dataMatrix.DataMatrixReader;
import csplugins.isb.pshannon.dataMatrix.gui.actions.CorrelationFinder;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CorrelationFinderTest
extends TestCase {
    static /* synthetic */ Class class$csplugins$isb$pshannon$dataMatrix$gui$actions$unitTests$CorrelationFinderTest;

    public CorrelationFinderTest(String string) {
        super(string);
    }

    public void testSingleGene() throws Exception {
        System.out.println("testSingleGene");
        String string = "sampleMatrix.txt";
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", string);
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        CorrelationFinderTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        CorrelationFinderTest.assertTrue((dataMatrix.getColumnCount() == 3 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue((dataMatrix.getRowCount() == 5 ? 1 : 0) != 0);
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        CorrelationFinder correlationFinder = new CorrelationFinder(dataMatrixLens);
        correlationFinder.buildCorrelationTable("a");
        Map map = correlationFinder.getCorrelationTable();
        String[] stringArray = map.keySet().toArray(new String[0]);
        CorrelationFinderTest.assertTrue((stringArray.length == 5 ? 1 : 0) != 0);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            double d = (Double)map.get(string2);
        }
        CorrelationFinderTest.assertTrue(((Double)map.get("a") == 0.9999999999999999 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("b") == -0.40490389262229654 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("c") == 0.0 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("d") == 0.7181729057836225 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("e") == -0.9999999999999999 ? 1 : 0) != 0);
    }

    public void testSingleGeneWithDisabledColumn() throws Exception {
        System.out.println("testSingleGeneWithDisabledColumn");
        String string = "sampleMatrix.txt";
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", string);
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        CorrelationFinderTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        CorrelationFinderTest.assertTrue((dataMatrix.getColumnCount() == 3 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue((dataMatrix.getRowCount() == 5 ? 1 : 0) != 0);
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        dataMatrixLens.setColumnState(1, false);
        CorrelationFinder correlationFinder = new CorrelationFinder(dataMatrixLens);
        correlationFinder.buildCorrelationTable("a");
        Map map = correlationFinder.getCorrelationTable();
        String[] stringArray = map.keySet().toArray(new String[0]);
        CorrelationFinderTest.assertTrue((stringArray.length == 5 ? 1 : 0) != 0);
        System.out.println("---------- just back from getting correlation table");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            double d = (Double)map.get(string2);
        }
        double[] dArray = new double[]{1.0000000000000002, -0.3465783488702321, 0.0, 0.9529976308307069, -1.0};
        CorrelationFinderTest.assertTrue(((Double)map.get("a") == dArray[0] ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("b") == dArray[1] ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("c") == dArray[2] ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("d") == dArray[3] ? 1 : 0) != 0);
    }

    public void testSeveralGenes() throws Exception {
        System.out.println("testSeveralGenes");
        String string = "sampleMatrix.txt";
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", string);
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        CorrelationFinderTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        CorrelationFinderTest.assertTrue((dataMatrix.getColumnCount() == 3 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue((dataMatrix.getRowCount() == 5 ? 1 : 0) != 0);
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        CorrelationFinder correlationFinder = new CorrelationFinder(dataMatrixLens);
        String[] stringArray = new String[]{"a", "b", "d"};
        correlationFinder.buildCorrelationTable(stringArray);
        Map map = correlationFinder.getCorrelationTable();
        String[] stringArray2 = map.keySet().toArray(new String[0]);
        CorrelationFinderTest.assertTrue((stringArray2.length == 5 ? 1 : 0) != 0);
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            double d = (Double)map.get(string2);
        }
        CorrelationFinderTest.assertTrue(((Double)map.get("a") == 0.7029614322271802 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("b") == 0.28203872119163176 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("c") == 0.0 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("d") == 0.8831948185308136 ? 1 : 0) != 0);
    }

    public void testSingleGeneNegativeCorrelation() throws Exception {
        System.out.println("testSingleGeneNegativeCorrelation");
        String string = "sampleMatrix.txt";
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://", string);
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix[] dataMatrixArray = ((DataMatrixReader)dataMatrixFileReader).get();
        CorrelationFinderTest.assertTrue((dataMatrixArray.length == 1 ? 1 : 0) != 0);
        DataMatrix dataMatrix = dataMatrixArray[0];
        CorrelationFinderTest.assertTrue((dataMatrix.getColumnCount() == 3 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue((dataMatrix.getRowCount() == 5 ? 1 : 0) != 0);
        DataMatrixLens dataMatrixLens = new DataMatrixLens(dataMatrix);
        CorrelationFinder correlationFinder = new CorrelationFinder(dataMatrixLens);
        correlationFinder.buildCorrelationTable("a");
        Map map = correlationFinder.getCorrelationTable();
        String[] stringArray = map.keySet().toArray(new String[0]);
        CorrelationFinderTest.assertTrue((stringArray.length == 5 ? 1 : 0) != 0);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            double d = (Double)map.get(string2);
        }
        CorrelationFinderTest.assertTrue(((Double)map.get("a") == 0.9999999999999999 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("b") == -0.40490389262229654 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("c") == 0.0 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("d") == 0.7181729057836225 ? 1 : 0) != 0);
        CorrelationFinderTest.assertTrue(((Double)map.get("e") == -0.9999999999999999 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(class$csplugins$isb$pshannon$dataMatrix$gui$actions$unitTests$CorrelationFinderTest == null ? (class$csplugins$isb$pshannon$dataMatrix$gui$actions$unitTests$CorrelationFinderTest = CorrelationFinderTest.class$("csplugins.isb.pshannon.dataMatrix.gui.actions.unitTests.CorrelationFinderTest")) : class$csplugins$isb$pshannon$dataMatrix$gui$actions$unitTests$CorrelationFinderTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

