/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.dataMatrix.gui.actions;

import csplugins.common.vectormath.MathVector;
import csplugins.common.vectormath.MathVectorFactory;
import csplugins.common.vectormath.ReadOnlyMathVector;
import csplugins.isb.pshannon.dataMatrix.DataMatrixLens;
import java.util.HashMap;
import java.util.Map;

public class CorrelationFinder {
    private DataMatrixLens lens;
    private Map myTable = new HashMap();

    public CorrelationFinder() {
    }

    public CorrelationFinder(DataMatrixLens dataMatrixLens) {
        this.setDataMatrixLens(dataMatrixLens);
    }

    public void setDataMatrixLens(DataMatrixLens dataMatrixLens) {
        this.lens = dataMatrixLens;
    }

    public Map buildCorrelationTable(String string) {
        this.myTable.clear();
        if (this.lens == null) {
            return this.myTable;
        }
        double[] dArray = this.lens.getFromAll(string);
        if (dArray.length == 0) {
            return this.myTable;
        }
        ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(dArray);
        return this.buildCorrelationTable(readOnlyMathVector);
    }

    public Map buildCorrelationTable(String[] stringArray) {
        this.myTable.clear();
        if (this.lens == null || stringArray == null || stringArray.length == 0) {
            return this.myTable;
        }
        int n = this.lens.getEnabledColumnCount();
        double[] dArray = new double[n];
        MathVector mathVector = MathVectorFactory.makeVector(dArray);
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray2 = this.lens.getFromAll(stringArray[i]);
            ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(dArray2);
            mathVector.add(readOnlyMathVector.copy().normalize());
            ++n2;
        }
        if (n2 == 0) {
            return this.myTable;
        }
        mathVector.times(1.0 / (double)n2);
        return this.buildCorrelationTable(mathVector);
    }

    public Map buildCorrelationTable(ReadOnlyMathVector readOnlyMathVector) {
        this.myTable.clear();
        int n = this.lens.getEnabledColumnCount();
        if (readOnlyMathVector.size() != n) {
            return this.myTable;
        }
        String[] stringArray = this.lens.getAllRowTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray = this.lens.getFromAll(stringArray[i]);
            ReadOnlyMathVector readOnlyMathVector2 = MathVectorFactory.makeReadOnlyVector(dArray);
            Double d = new Double(readOnlyMathVector.dotNorm(readOnlyMathVector2));
            this.myTable.put(stringArray[i], d);
        }
        return this.myTable;
    }

    public Map oldBuildCorrelationTable(ReadOnlyMathVector readOnlyMathVector) {
        this.myTable.clear();
        int n = this.lens.getEnabledColumnCount();
        if (readOnlyMathVector.size() != n) {
            return this.myTable;
        }
        String[] stringArray = this.lens.getAllRowTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray = this.lens.getFromAll(stringArray[i]);
            ReadOnlyMathVector readOnlyMathVector2 = MathVectorFactory.makeReadOnlyVector(dArray);
            Double d = new Double(readOnlyMathVector.dotNorm(readOnlyMathVector2));
            this.myTable.put(stringArray[i], d);
        }
        return this.myTable;
    }

    public Map getCorrelationTable() {
        return this.myTable;
    }
}

