/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.dataMatrix.gui;

import csplugins.isb.pshannon.dataMatrix.DataMatrix;
import csplugins.isb.pshannon.dataMatrix.DataMatrixLens;
import csplugins.isb.pshannon.dataMatrix.gui.CheckBoxHeader;
import csplugins.isb.pshannon.dataMatrix.gui.DataMatrixTableModel;
import csplugins.isb.pshannon.dataMatrix.gui.actions.CreateNewMatrixFromSelection;
import csplugins.isb.pshannon.dataMatrix.gui.actions.ExportMatrix;
import csplugins.isb.pshannon.dataMatrix.gui.actions.FindCorrelations;
import csplugins.isb.pshannon.dataMatrix.gui.actions.GetSelectionsFromNetwork;
import csplugins.isb.pshannon.dataMatrix.gui.actions.PyConsoleLauncher;
import csplugins.isb.pshannon.dataMatrix.gui.actions.RunMovie;
import csplugins.isb.pshannon.dataMatrix.gui.actions.SelectionPlotter;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import giny.model.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DataMatrixBrowser
extends JPanel
implements ClipboardOwner {
    protected int preferredTableWidth = 600;
    protected int preferredTableHeight = 100;
    protected JTabbedPane tabbedPane;
    protected File currentDirectory;
    ArrayList matrixList;
    ArrayList lensList;
    ArrayList nodeAttributeNameTextFieldList;
    ArrayList selectionCountTextFieldList;
    int matrixCount = 0;
    protected ArrayList tableList = new ArrayList();
    protected boolean[][] columnState;
    protected int[][] columnOrder;
    protected ArrayList columnCheckBoxHeaderMaps = new ArrayList();
    protected JPanel buttonPanel;
    private Vector selectedRows = new Vector();
    private Vector colOrder = new Vector();
    private Vector enabled = new Vector();
    private Vector colMap = new Vector();
    protected boolean updateSelectionsToCytoscapeWindow = true;
    protected JToolBar toolbar;
    protected SelectionPlotter plotter = null;

    public DataMatrixBrowser(DataMatrix[] dataMatrixArray) throws Exception {
        this.currentDirectory = new File(System.getProperty("user.dir"));
        this.matrixList = new ArrayList();
        this.lensList = new ArrayList();
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.createGui(dataMatrixArray), "Center");
        this.addActions();
        this.setVisible(true);
    }

    protected void addActions() {
        this.plotter = new SelectionPlotter(this);
        CreateNewMatrixFromSelection createNewMatrixFromSelection = new CreateNewMatrixFromSelection(this);
        RunMovie runMovie = new RunMovie(this);
        ExportMatrix exportMatrix = new ExportMatrix(this);
        FindCorrelations findCorrelations = new FindCorrelations(this);
        GetSelectionsFromNetwork getSelectionsFromNetwork = new GetSelectionsFromNetwork(this);
        PyConsoleLauncher pyConsoleLauncher = new PyConsoleLauncher(this);
    }

    public void addActionToToolbar(AbstractAction abstractAction) {
        this.toolbar.add(abstractAction);
    }

    public boolean hasSelectedRows() {
        ListSelectionModel listSelectionModel = this.getCurrentTable().getSelectionModel();
        return !listSelectionModel.isSelectionEmpty();
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public DataMatrixLens[] getAllLenses() {
        return this.lensList.toArray(new DataMatrixLens[0]);
    }

    public DataMatrixLens getCurrentLens() {
        return this.getLens(this.getCurrentTabAndTableIndex());
    }

    public JTable getCurrentTable() {
        return this.getTable(this.getCurrentTabAndTableIndex());
    }

    public DataMatrixLens getLens(int n) {
        return (DataMatrixLens)this.lensList.get(n);
    }

    public JTable getTable(int n) {
        return (JTable)this.tableList.get(n);
    }

    public JTable[] getAllTables() {
        return this.tableList.toArray(new JTable[0]);
    }

    public String[] getMatrixAliases() {
        int n = this.matrixList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((JTextField)this.nodeAttributeNameTextFieldList.get(i)).getText();
        }
        return stringArray;
    }

    private int[] calculateColumnWidths(JTable jTable, DataMatrix dataMatrix) {
        String[] stringArray = dataMatrix.getColumnTitles();
        int n = stringArray.length;
        int n2 = 100;
        int[] nArray = new int[n];
        FontMetrics fontMetrics = jTable.getFontMetrics(jTable.getFont());
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            int n3 = fontMetrics.stringWidth(string);
            int n4 = (int)((double)n3 * 1.4);
            nArray[i] = n4 > n2 ? n4 : n2;
        }
        return nArray;
    }

    JTabbedPane createGui(DataMatrix[] dataMatrixArray) {
        this.tabbedPane = new JTabbedPane();
        class PaneListener
        implements ChangeListener {
            PaneListener() {
            }

            public void stateChanged(ChangeEvent changeEvent) {
                if (DataMatrixBrowser.this.tableList == null) {
                    return;
                }
                int n = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
                if (n < 0) {
                    return;
                }
                JTable jTable = (JTable)DataMatrixBrowser.this.tableList.get(n);
            }
        }
        this.tabbedPane.addChangeListener(new PaneListener());
        this.nodeAttributeNameTextFieldList = new ArrayList();
        this.selectionCountTextFieldList = new ArrayList();
        for (int i = 0; i < dataMatrixArray.length; ++i) {
            this.addMatrixToGui(dataMatrixArray[i]);
        }
        return this.tabbedPane;
    }

    public void addMatrixToGui(DataMatrix dataMatrix) {
        Object object;
        JComponent jComponent;
        Object object2;
        this.matrixList.add(dataMatrix);
        try {
            this.lensList.add(new DataMatrixLens(dataMatrix));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DataMatrixTableModel dataMatrixTableModel = new DataMatrixTableModel(dataMatrix);
        HashMap<String, CheckBoxHeader> hashMap = new HashMap<String, CheckBoxHeader>();
        this.columnCheckBoxHeaderMaps.add(hashMap);
        JTable jTable = new JTable(dataMatrixTableModel);
        jTable.setShowGrid(true);
        int[] nArray = this.calculateColumnWidths(jTable, dataMatrix);
        JList<String> jList = new JList<String>(dataMatrix.getRowTitles());
        jList.setFixedCellWidth(100);
        jList.setFixedCellHeight(jTable.getRowHeight());
        jList.setCellRenderer(new RowHeaderRenderer(jTable));
        this.tableList.add(jTable);
        jTable.getColumnModel().addColumnModelListener(new TableColumnMovedListener());
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            ((TableColumn)object2).setPreferredWidth(nArray[n]);
            jComponent = new CheckBoxHeader(new TableHeaderCheckboxListener());
            object = dataMatrix.getColumnTitles()[n];
            hashMap.put((String)object, (CheckBoxHeader)jComponent);
            ((TableColumn)object2).setHeaderRenderer((TableCellRenderer)((Object)jComponent));
            ++n;
        }
        object2 = jTable.getSelectionModel();
        object2.addListSelectionListener(new TableSelectionListener(jTable, dataMatrix));
        jTable.setSelectionModel((ListSelectionModel)object2);
        jTable.setPreferredScrollableViewportSize(new Dimension(this.preferredTableWidth, this.preferredTableHeight));
        jComponent = new JScrollPane(jTable);
        ((JScrollPane)jComponent).setRowHeaderView(jList);
        ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(32);
        jTable.setAutoResizeMode(0);
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        String string = dataMatrix.getShortName();
        String string2 = "";
        int n2 = string.lastIndexOf(".");
        string2 = n2 > 0 && n2 < string.length() - 1 ? string.substring(n2 + 1) : string;
        if (string.length() == 0) {
            string = new Integer(this.matrixList.size()).toString();
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Node attribute name: "));
        JTextField jTextField = new JTextField(string2, 10);
        this.nodeAttributeNameTextFieldList.add(jTextField);
        jPanel2.add(jTextField);
        JTextField jTextField2 = new JTextField("0", 5);
        this.selectionCountTextFieldList.add(jTextField2);
        jPanel2.add(new JLabel("Selected Rows: "));
        jPanel2.add(jTextField2);
        String string3 = new String("<html><font=+2><b>X</b></font></html>");
        JButton jButton = new JButton(string3);
        jButton.addActionListener(new CloseTabAction((JPanel)object));
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        ((Container)object).add((Component)jPanel, "North");
        ((Container)object).add((Component)jComponent, "Center");
        this.tabbedPane.add(string, (Component)object);
    }

    public boolean hasCytoscapeParent() {
        return Cytoscape.getNetworkSet().size() > 0;
    }

    private String extendMatrixWithNodeAttributes(String string) {
        if (this.hasCytoscapeParent()) {
            return string;
        }
        String[] stringArray = string.split("\n");
        String[] stringArray2 = Cytoscape.getCurrentNetwork().getNodeAttributesList();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append("\t");
            stringBuffer.append(stringArray2[i]);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer2.append("\n");
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split("\t");
            String string2 = stringArray3[0];
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(stringArray[i]);
            stringBuffer3.append("\t");
            for (int j = 0; j < stringArray2.length; ++j) {
                String string3 = stringArray2[j];
                CyNode cyNode = Cytoscape.getCyNode((String)string2, (boolean)false);
                if (cyNode == null) continue;
                Object object = Cytoscape.getCurrentNetwork().getNodeAttributeValue((Node)cyNode, stringArray2[j]);
                if (object != null) {
                    String string4 = object.toString();
                    stringBuffer3.append(string4);
                }
                if (j >= stringArray2.length - 1) continue;
                stringBuffer3.append("\t");
            }
            stringBuffer3.append("\n");
            stringBuffer2.append(stringBuffer3.toString());
        }
        return stringBuffer2.toString();
    }

    private void setPreferredColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = jTable.getModel().getColumnCount();
        tableColumnModel.getColumn(0).setPreferredWidth(80);
    }

    private void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    private void resetPlotter() {
        if (null != this.plotter) {
            JTable jTable = (JTable)this.tableList.get(this.getCurrentTabAndTableIndex());
            DataMatrixLens dataMatrixLens = (DataMatrixLens)this.lensList.get(this.getCurrentTabAndTableIndex());
            dataMatrixLens.setSelectedRows(jTable.getSelectedRows());
        }
    }

    protected void syncDataMatrixLensToBrowser() {
        JTable jTable = (JTable)this.tableList.get(this.getCurrentTabAndTableIndex());
        DataMatrixLens dataMatrixLens = (DataMatrixLens)this.lensList.get(this.getCurrentTabAndTableIndex());
        dataMatrixLens.setSelectedRows(jTable.getSelectedRows());
    }

    public void setUpdateSelectionsToCytoscape(boolean bl) {
        this.updateSelectionsToCytoscapeWindow = bl;
    }

    public void selectNodesByName(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        this.selectNodesByName(arrayList);
    }

    public void selectNodesByName(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CyNode cyNode = Cytoscape.getCyNode((String)string, (boolean)false);
            if (cyNode == null) continue;
            Cytoscape.getCurrentNetwork().getFlagger().setFlagged((Node)cyNode, true);
        }
    }

    public void enableColumnsByName(String[] stringArray) {
        JTable[] jTableArray = this.tableList.toArray(new JTable[0]);
        for (int i = 0; i < jTableArray.length; ++i) {
            this.enableColumnsByName(i, stringArray);
        }
    }

    protected void enableColumnsByName(int n, String[] stringArray) {
        Object object;
        int n2;
        HashMap hashMap = (HashMap)this.columnCheckBoxHeaderMaps.get(n);
        JTable jTable = (JTable)this.tableList.get(n);
        String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            object = (CheckBoxHeader)hashMap.get(stringArray2[n2]);
            ((AbstractButton)object).setSelected(false);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            object = stringArray[n2];
            boolean bl = hashMap.containsKey(object);
            if (!bl) continue;
            CheckBoxHeader checkBoxHeader = (CheckBoxHeader)hashMap.get(object);
            checkBoxHeader.setSelected(true);
        }
        jTable.getTableHeader().resizeAndRepaint();
    }

    public void disableAllColumnsInCurrentlyVisibleTable() {
        int n = this.getCurrentTabAndTableIndex();
        HashMap hashMap = (HashMap)this.columnCheckBoxHeaderMaps.get(n);
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            CheckBoxHeader checkBoxHeader = (CheckBoxHeader)hashMap.get(stringArray[i]);
            checkBoxHeader.setSelected(false);
        }
        JTable jTable = (JTable)this.tableList.get(n);
        jTable.getTableHeader().resizeAndRepaint();
    }

    protected void enableColumnsByNameInCurrentlyVisibleTable(String[] stringArray) {
        HashMap hashMap = (HashMap)this.columnCheckBoxHeaderMaps.get(this.getCurrentTabAndTableIndex());
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            boolean bl = hashMap.containsKey(string);
            if (!bl) continue;
            CheckBoxHeader checkBoxHeader = (CheckBoxHeader)hashMap.get(string);
            checkBoxHeader.setSelected(true);
        }
        JTable jTable = (JTable)this.tableList.get(this.getCurrentTabAndTableIndex());
        jTable.getTableHeader().resizeAndRepaint();
    }

    public void clearAllSelections() {
        JTable[] jTableArray = this.tableList.toArray(new JTable[0]);
        for (int i = 0; i < jTableArray.length; ++i) {
            jTableArray[i].clearSelection();
        }
        this.syncDataMatrixLensToBrowser();
    }

    public void selectRowsByName(String[] stringArray) {
        JTable[] jTableArray = this.tableList.toArray(new JTable[0]);
        for (int i = 0; i < jTableArray.length; ++i) {
            this.selectRowsByName(i, stringArray);
        }
    }

    public void selectRowsByName(int n, String[] stringArray) {
        JTable jTable = (JTable)this.tableList.get(n);
        List<String> list = Arrays.asList(stringArray);
        String[] stringArray2 = ((DataMatrix)this.matrixList.get(n)).getRowTitles();
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            boolean bl = list.contains(string);
            if (!bl) continue;
            jTable.getSelectionModel().addSelectionInterval(i, i);
            ++n2;
        }
        String string = new Integer(n2).toString();
        ((JTextField)this.selectionCountTextFieldList.get(n)).setText(string);
    }

    protected boolean columnNamesIntersect(String[] stringArray) {
        HashMap hashMap = (HashMap)this.columnCheckBoxHeaderMaps.get(this.getCurrentTabAndTableIndex());
        String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!hashMap.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean rowNamesIntersect(String[] stringArray) {
        int n = this.getCurrentTabAndTableIndex();
        List<String> list = Arrays.asList(stringArray);
        String[] stringArray2 = ((DataMatrix)this.matrixList.get(n)).getRowTitles();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!list.contains(stringArray2[i])) continue;
            return true;
        }
        return false;
    }

    public void selectSubTableInCurrentlyVisibleTable(String[] stringArray, String[] stringArray2) {
        this.clearAllSelections();
        this.disableAllColumnsInCurrentlyVisibleTable();
        if (!this.columnNamesIntersect(stringArray2)) {
            return;
        }
        if (!this.rowNamesIntersect(stringArray)) {
            return;
        }
        this.selectRowsByNameInCurrentlyVisibleTable(stringArray);
        this.disableAllColumnsInCurrentlyVisibleTable();
        this.enableColumnsByNameInCurrentlyVisibleTable(stringArray2);
    }

    public void selectRowsByNameInCurrentlyVisibleTable(String[] stringArray) {
        int n = this.getCurrentTabAndTableIndex();
        JTable jTable = (JTable)this.tableList.get(n);
        List<String> list = Arrays.asList(stringArray);
        String[] stringArray2 = ((DataMatrix)this.matrixList.get(n)).getRowTitles();
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            boolean bl = list.contains(string);
            if (!bl) continue;
            jTable.getSelectionModel().addSelectionInterval(i, i);
            ++n2;
        }
        String string = new Integer(n2).toString();
        ((JTextField)this.selectionCountTextFieldList.get(n)).setText(string);
    }

    public JTable getTable() {
        JTable jTable = (JTable)this.tableList.get(this.getCurrentTabAndTableIndex());
        return jTable;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public int getCurrentTabAndTableIndex() {
        if (this.tabbedPane == null) {
            return -1;
        }
        return this.tabbedPane.getSelectedIndex();
    }

    public DataMatrix[] getMatrices() {
        return this.matrixList.toArray(new DataMatrix[0]);
    }

    public ArrayList getSelectedNodeNames() {
        Set set = Cytoscape.getCurrentNetwork().getFlagger().getFlaggedNodes();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CyNode cyNode = (CyNode)iterator.next();
            String string = (String)Cytoscape.getCurrentNetwork().getNodeAttributeValue((Node)cyNode, "canonicalName");
            arrayList.add(string);
        }
        return arrayList;
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable jTable) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        JTable table;
        DataMatrix matrix;

        TableSelectionListener(JTable jTable, DataMatrix dataMatrix) {
            this.table = jTable;
            this.matrix = dataMatrix;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            if (!listSelectionModel.isSelectionEmpty()) {
                int n3 = listSelectionModel.getMinSelectionIndex();
                int n4 = listSelectionModel.getMaxSelectionIndex();
                for (int i = n3; i <= n4; ++i) {
                    if (!listSelectionModel.isSelectedIndex(i)) continue;
                    String string = this.matrix.getRowTitles()[i];
                    arrayList.add(string);
                    ++n2;
                }
            }
            if (DataMatrixBrowser.this.hasCytoscapeParent()) {
                DataMatrixBrowser.this.selectNodesByName(arrayList.toArray(new String[0]));
            }
            String string = new Integer(n2).toString();
            ((JTextField)DataMatrixBrowser.this.selectionCountTextFieldList.get(n)).setText(string);
            DataMatrixBrowser.this.syncDataMatrixLensToBrowser();
        }
    }

    public class DismissAction
    extends AbstractAction {
        private JDialog dialog;

        DismissAction(JDialog jDialog) {
            super("");
            this.dialog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.dispose();
        }
    }

    public class SaveTableAction
    extends AbstractAction {
        private JFrame frame;

        SaveTableAction(JFrame jFrame) {
            super("");
            this.frame = jFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
            if (n == 0) {
                return;
            }
            JScrollPane jScrollPane = (JScrollPane)DataMatrixBrowser.this.tabbedPane.getSelectedComponent();
            JTable jTable = (JTable)jScrollPane.getViewport().getView();
            int n2 = jTable.getRowCount();
            int n3 = jTable.getColumnCount();
            JFileChooser jFileChooser = new JFileChooser(DataMatrixBrowser.this.currentDirectory);
            if (jFileChooser.showSaveDialog(DataMatrixBrowser.this) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                DataMatrixBrowser.this.currentDirectory = jFileChooser.getCurrentDirectory();
                File file = new File(string);
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            Class<?> clazz = jTable.getColumnClass(j);
                            Object object = jTable.getValueAt(i, j);
                            fileWriter.write(object + "\t");
                        }
                        fileWriter.write("\n");
                    }
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, iOException.toString(), "Error Writing to \"" + file.getName() + "\"", 0);
                }
            }
        }
    }

    class TableColumnMovedListener
    implements TableColumnModelListener {
        TableColumnMovedListener() {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            int n;
            int n2 = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
            int n3 = tableColumnModelEvent.getFromIndex();
            if (n3 == (n = tableColumnModelEvent.getToIndex())) {
                return;
            }
            ((DataMatrixLens)DataMatrixBrowser.this.lensList.get(n2)).swapColumnOrder(n3, n);
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    class TableHeaderCheckboxListener
    implements ItemListener {
        TableHeaderCheckboxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
            if (n < 0) {
                return;
            }
            Object object = itemEvent.getSource();
            if (!(object instanceof AbstractButton)) {
                return;
            }
            String string = ((AbstractButton)object).getText();
            boolean bl = itemEvent.getStateChange() == 1;
            int n2 = ((CheckBoxHeader)itemEvent.getItem()).getColumn();
            ((DataMatrixLens)DataMatrixBrowser.this.lensList.get(n)).setColumnState(n2, bl);
        }
    }

    public class CloseTabAction
    extends AbstractAction {
        JPanel tab;

        CloseTabAction(JPanel jPanel) {
            super("");
            this.tab = jPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
            DataMatrixBrowser.this.matrixList.remove(n);
            DataMatrixBrowser.this.lensList.remove(n);
            DataMatrixBrowser.this.nodeAttributeNameTextFieldList.remove(n);
            DataMatrixBrowser.this.selectionCountTextFieldList.remove(n);
            DataMatrixBrowser.this.tableList.remove(n);
            DataMatrixBrowser.this.tabbedPane.remove(this.tab);
        }
    }
}

