/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.dataMatrix;

import csplugins.isb.pshannon.dataMatrix.DataMatrix;
import csplugins.isb.pshannon.dataMatrix.DataMatrixReader;
import csplugins.isb.pshannon.dataMatrix.DataMatrixReaderFactory;
import csplugins.isb.pshannon.dataMatrix.gui.DataMatrixBrowser;
import cytoscape.Cytoscape;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.util.CytoscapeAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DataMatrixPlugin
extends CytoscapePlugin {
    protected String[] matrixURIs;
    protected ArrayList matrices = new ArrayList();
    protected DataMatrixBrowser browser;
    protected File currentDirectory;
    protected JFrame browserFrame;

    public DataMatrixPlugin() throws Exception {
        LoadDataMatrixAction loadDataMatrixAction = new LoadDataMatrixAction();
        loadDataMatrixAction.setPreferredMenu("Plugins");
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)loadDataMatrixAction);
        BrowseDataMatrices browseDataMatrices = new BrowseDataMatrices();
        browseDataMatrices.setPreferredMenu("Plugins");
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)browseDataMatrices);
        this.init(new String[0]);
    }

    public DataMatrixPlugin(String[] stringArray) throws Exception {
        this.init(stringArray);
    }

    public void init(String[] stringArray) throws Exception {
        String[] stringArray2 = Cytoscape.getCytoscapeObj() != null ? Cytoscape.getCytoscapeObj().getConfiguration().getArgs() : stringArray;
        this.matrixURIs = this.extractMatrixFilenamesFromCommandLineArgs(stringArray2);
        System.out.println("number of matrixURIs: " + this.matrixURIs.length);
        for (int i = 0; i < this.matrixURIs.length; ++i) {
            DataMatrixReader dataMatrixReader = DataMatrixReaderFactory.createReader(this.matrixURIs[i]);
            dataMatrixReader.read();
            DataMatrix[] dataMatrixArray = dataMatrixReader.get();
            System.out.println("number of matrices read: " + dataMatrixArray.length);
            this.matrices.add(dataMatrixReader.get()[0]);
            File file = new File(".");
            String string = file.getAbsolutePath();
            string = string.replaceFirst("\\.$", "");
        }
    }

    public String describe() {
        return "A plugin for handling Data Matrices and performing various operations on them.";
    }

    private String[] extractMatrixFilenamesFromCommandLineArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("--matrix")) continue;
            if (i + 1 > stringArray.length) {
                throw new IllegalArgumentException("error!  no --matrix value");
            }
            arrayList.add(stringArray[i + 1]);
        }
        System.out.println("matrix uri's: " + arrayList.size());
        return arrayList.toArray(new String[0]);
    }

    public DataMatrixBrowser runBrowser() throws Exception {
        DataMatrix[] dataMatrixArray = this.matrices.toArray(new DataMatrix[0]);
        DataMatrixBrowser dataMatrixBrowser = new DataMatrixBrowser(dataMatrixArray);
        this.browserFrame = new JFrame();
        this.browserFrame.getContentPane().add(dataMatrixBrowser);
        this.browserFrame.pack();
        if (Cytoscape.getCytoscapeObj() != null) {
            this.browserFrame.setLocationRelativeTo((Component)Cytoscape.getDesktop());
        }
        this.browserFrame.setVisible(true);
        return dataMatrixBrowser;
    }

    protected class BrowseDataMatrices
    extends CytoscapeAction {
        BrowseDataMatrices() {
            super("Browse Data Matrices...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DataMatrixPlugin.this.browser = DataMatrixPlugin.this.runBrowser();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = "Failed to open DataMatrixBrowser: " + exception.getMessage();
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), string, "DataMatrixBrowser errror", 0);
            }
        }
    }

    protected class LoadDataMatrixAction
    extends CytoscapeAction {
        LoadDataMatrixAction() {
            super("Load Tab-Delimited Data Matrix...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(DataMatrixPlugin.this.currentDirectory);
            try {
                if (jFileChooser.showOpenDialog((Component)Cytoscape.getDesktop()) == 0) {
                    DataMatrixPlugin.this.currentDirectory = jFileChooser.getCurrentDirectory();
                    String string = jFileChooser.getSelectedFile().toString();
                    DataMatrixReader dataMatrixReader = DataMatrixReaderFactory.createReader(string);
                    dataMatrixReader.read();
                    DataMatrixPlugin.this.matrices.add(dataMatrixReader.get()[0]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

