/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.dataMatrix;

import csplugins.isb.pshannon.dataMatrix.DataMatrix;
import java.util.ArrayList;

public class DataMatrixLens {
    DataMatrix matrix;
    int[] columnOrder;
    boolean[] columnState;
    private int[] selectedRows;
    private boolean DEBUG = false;

    public DataMatrixLens(DataMatrix dataMatrix) throws Exception {
        this.matrix = dataMatrix;
        this.clear();
        this.setSelectedRows(new int[0]);
    }

    public void clear() {
        int n = this.matrix.getColumnCount();
        this.columnState = new boolean[n];
        this.columnOrder = new int[n];
        for (int i = 0; i < n; ++i) {
            this.columnState[i] = true;
            this.columnOrder[i] = i;
        }
    }

    public String getMatrixName() {
        return this.matrix.getName();
    }

    public void setColumnState(int n, boolean bl) {
        this.columnState[n] = bl;
    }

    public boolean[] getColumnState() {
        return this.columnState;
    }

    public boolean getColumnState(int n) {
        return this.columnState[n];
    }

    public void swapColumnOrder(int n, int n2) {
        boolean bl;
        int n3;
        int n4 = this.columnOrder[n];
        this.columnOrder[n] = n3 = this.columnOrder[n2];
        this.columnOrder[n2] = n4;
        boolean bl2 = this.columnState[n];
        this.columnState[n] = bl = this.columnState[n2];
        this.columnState[n2] = bl2;
        this.printTransformation();
    }

    public int getColumnOrder(int n) {
        return this.columnOrder[n];
    }

    public int getRawColumnCount() {
        return this.columnState.length;
    }

    public int getEnabledColumnCount() {
        int n = 0;
        for (int i = 0; i < this.columnState.length; ++i) {
            if (!this.columnState[i]) continue;
            ++n;
        }
        return n;
    }

    public DataMatrix getSelectedSubMatrix() throws Exception {
        DataMatrix dataMatrix = new DataMatrix();
        int n = this.getSelectedRowCount();
        int n2 = this.getEnabledColumnCount();
        dataMatrix.setSize(n, n2);
        dataMatrix.setColumnTitles(this.getFilteredColumnTitles());
        dataMatrix.setRowTitles(this.getSelectedRowTitles());
        dataMatrix.setRowTitlesTitle(this.getRowTitlesTitle());
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.getFromSelected(i);
            for (int j = 0; j < dArray.length; ++j) {
                dataMatrix.set(i, j, dArray[j]);
            }
        }
        return dataMatrix;
    }

    public int getSelectedRowCount() {
        return this.selectedRows.length;
    }

    public int[] getSelectedRowIndexes() {
        return this.selectedRows;
    }

    public int getRawRowCount() {
        return this.matrix.getRowCount();
    }

    public void setSelectedRows(int[] nArray) {
        this.selectedRows = nArray;
    }

    public void selectAllRows() {
        int n = this.getRawRowCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        this.selectedRows = nArray;
    }

    public double[] getUntransformed(int n) {
        return this.getRaw(n);
    }

    public void printTransformation() {
        int n;
        if (!this.DEBUG) {
            return;
        }
        for (n = 0; n < this.getRawColumnCount(); ++n) {
            System.out.print(n + " ");
        }
        System.out.println();
        for (n = 0; n < this.getRawColumnCount(); ++n) {
            System.out.print(this.columnOrder[n] + " ");
        }
        System.out.println();
        for (n = 0; n < this.getRawColumnCount(); ++n) {
            String string = "F";
            if (this.columnState[n]) {
                string = "T";
            }
            System.out.print(string + " ");
        }
        System.out.println();
        System.out.println();
    }

    public double[] getRaw(int n) {
        return this.matrix.get(n);
    }

    public double[] getRaw(String string) {
        return this.matrix.get(string);
    }

    public double getRaw(int n, int n2) {
        return this.matrix.get(n, n2);
    }

    public double[] getFromAll(int n) {
        double[] dArray = this.matrix.get(n);
        return this.adjustForColumnOrderAndState(dArray);
    }

    public double[] getFromAll(String string) {
        double[] dArray = this.matrix.get(string);
        return this.adjustForColumnOrderAndState(dArray);
    }

    public double getFromAll(int n, int n2) {
        double[] dArray = this.matrix.get(n);
        double[] dArray2 = this.adjustForColumnOrderAndState(dArray);
        return dArray2[n2];
    }

    public double[] getFromSelected(int n) {
        int n2 = this.getRowIndexFromSelection(n);
        return this.getFromAll(n2);
    }

    public double[] getFromSelected(String string) {
        return this.getFromAll(string);
    }

    public double getFromSelected(int n, int n2) {
        int n3 = this.getRowIndexFromSelection(n);
        return this.getFromAll(n3, n2);
    }

    private int getRowIndexFromSelection(int n) {
        return this.selectedRows[n];
    }

    public double[] adjustForColumnOrderAndState(double[] dArray) {
        int n = this.getRawColumnCount();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.columnOrder.length; ++i) {
            if (!this.columnState[i]) continue;
            double d = dArray[this.columnOrder[i]];
            arrayList.add(new Double(d));
        }
        double[] dArray2 = new double[arrayList.size()];
        Double[] doubleArray = arrayList.toArray(new Double[0]);
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray2[i] = doubleArray[i];
        }
        return dArray2;
    }

    public String[] adjustForColumnOrderAndState(String[] stringArray) {
        int n;
        if (this.DEBUG) {
            System.out.println("---- incoming Lens.adjust column titles");
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println(stringArray[n]);
            }
        }
        n = this.getRawColumnCount();
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        this.printTransformation();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.columnOrder.length; ++i) {
            if (this.DEBUG) {
                System.out.println("   column " + i + ": " + this.columnState[i]);
            }
            if (!this.columnState[i]) continue;
            String string = stringArray2[this.columnOrder[i]];
            if (this.DEBUG) {
                System.out.println("  got " + string + " from " + this.columnOrder[i]);
            }
            arrayList.add(string);
        }
        String[] stringArray3 = arrayList.toArray(new String[0]);
        if (this.DEBUG) {
            System.out.println("---- outgoing Lens.adjust column titles");
            for (int i = 0; i < stringArray3.length; ++i) {
                System.out.println(stringArray3[i]);
            }
        }
        this.DEBUG = false;
        return stringArray3;
    }

    public String[] getAllRowTitles() {
        return this.matrix.getRowTitles();
    }

    public String getRowTitlesTitle() {
        return this.matrix.getRowTitlesTitle();
    }

    public String[] getSelectedRowTitles() {
        String[] stringArray = new String[this.selectedRows.length];
        String[] stringArray2 = this.matrix.getRowTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray2[this.selectedRows[i]];
        }
        return stringArray;
    }

    public String[] getUnmaskedColumnTitles() {
        return this.getAllColumnTitles();
    }

    public String[] getAllColumnTitles() {
        return this.matrix.getColumnTitles();
    }

    public String[] getFilteredColumnTitles() {
        String[] stringArray = this.matrix.getColumnTitles();
        return this.adjustForColumnOrderAndState(this.matrix.getColumnTitles());
    }

    public String toString(boolean bl) {
        int[] nArray;
        if (bl) {
            nArray = new int[this.matrix.getRowCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = this.selectedRows;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getFilteredColumnTitles();
        int n = stringArray.length;
        if (this.DEBUG) {
            System.out.println("adjustedColumnTitles.length: " + stringArray.length);
        }
        stringBuffer.append(this.getRowTitlesTitle());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("\n");
        String[] stringArray2 = bl ? this.getAllRowTitles() : this.getSelectedRowTitles();
        int n2 = stringArray2.length;
        for (int i = 0; i < nArray.length; ++i) {
            double[] dArray = bl ? this.getFromAll(i) : this.getFromAll(this.getRowIndexFromSelection(i));
            stringBuffer.append(stringArray2[i]);
            for (int j = 0; j < n; ++j) {
                stringBuffer.append("\t");
                stringBuffer.append(dArray[j]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

