/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.dataMatrix;

import csplugins.isb.pshannon.dataMatrix.DataMatrix;
import csplugins.isb.pshannon.dataMatrix.DataMatrixReader;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import java.io.File;
import java.util.ArrayList;

public class DataMatrixFileReader
extends DataMatrixReader {
    ArrayList matrices = new ArrayList();

    public DataMatrixFileReader(String string, String string2) {
        super(string, string2);
    }

    public DataMatrix[] get() throws Exception {
        return this.matrices.toArray(new DataMatrix[0]);
    }

    public void read() throws Exception {
        String string = null;
        if (this.protocol.equals("file://")) {
            File file = new File(this.path);
            if (!file.exists()) {
                throw new IllegalArgumentException("cannot find file named '" + this.path + "'");
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("cannot read file named '" + this.path + "'");
            }
            TextFileReader textFileReader = new TextFileReader(this.path);
            textFileReader.read();
            string = textFileReader.getText();
        } else if (this.protocol.equals("jar://")) {
            TextJarReader textJarReader = new TextJarReader(this.protocol + this.path);
            textJarReader.read();
            string = textJarReader.getText();
        } else if (this.protocol.equals("http://")) {
            TextHttpReader textHttpReader = new TextHttpReader(this.protocol + this.path);
            textHttpReader.read();
            string = textHttpReader.getText();
        }
        this.parseText(string);
    }

    protected void parseText(String string) throws Exception {
        String[] stringArray = string.split("\n");
        String[] stringArray2 = stringArray[0].split("\t");
        DataMatrix dataMatrix = new DataMatrix(this.protocol + this.path);
        int n = stringArray.length - 1;
        int n2 = stringArray2.length - 1;
        dataMatrix.setSize(n, n2);
        String string2 = stringArray2[0];
        String[] stringArray3 = new String[stringArray2.length - 1];
        for (int i = 1; i < stringArray2.length; ++i) {
            stringArray3[i - 1] = stringArray2[i];
        }
        dataMatrix.setRowTitlesTitle(string2);
        dataMatrix.setColumnTitles(stringArray3);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            String[] stringArray4 = string3.split("\t");
            String string4 = stringArray4[0];
            arrayList.add(string4);
            for (int j = 1; j < stringArray4.length; ++j) {
                String string5 = stringArray4[j];
                try {
                    double d = new Double(string5);
                    dataMatrix.set(i - 1, j - 1, d);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string6 = "cannot convert '" + string5 + "' to double, at row " + (i - 1) + " column " + (j - 1) + " while reading file " + this.path;
                    throw new IllegalArgumentException(string6);
                }
            }
        }
        dataMatrix.setRowTitles(arrayList.toArray(new String[0]));
        this.matrices.add(dataMatrix);
    }
}

