/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.dataMatrix;

public class DataMatrix {
    String rowTitlesTitle;
    String[] columnTitles = new String[0];
    String[] rowTitles = new String[0];
    double[][] data = null;
    String uri = "";
    String name = "";

    public DataMatrix() throws Exception {
        this.name = this.uri = "";
    }

    public DataMatrix(String string) throws Exception {
        this.uri = string.trim();
        this.name = string;
    }

    public String getShortName() {
        String[] stringArray = this.name.split("/");
        int n = stringArray.length - 1;
        if (n < 0) {
            return this.name;
        }
        return stringArray[n];
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(int n, int n2) {
        this.data = new double[n][n2];
    }

    public void assign(double d) {
        if (this.data == null) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                this.data[i][j] = d;
            }
        }
    }

    public void assign(int n, int n2, double d) {
        this.data[n][n2] = d;
    }

    public void set(int n, int n2, double d) {
        this.assign(n, n2, d);
    }

    public void setColumnTitles(String[] stringArray) {
        this.columnTitles = stringArray;
    }

    public void setRowTitles(String[] stringArray) {
        this.rowTitles = stringArray;
    }

    public void setRowTitlesTitle(String string) {
        this.rowTitlesTitle = string;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColumnCount() {
        return this.columnTitles.length;
    }

    public double get(int n, int n2) {
        return this.data[n][n2];
    }

    public double[] getUntransformed(int n) {
        return this.data[n];
    }

    public double[] get(int n) {
        return this.data[n];
    }

    public double[] get(String string) {
        for (int i = 0; i < this.rowTitles.length; ++i) {
            if (!this.rowTitles[i].equals(string)) continue;
            return this.data[i];
        }
        throw new IllegalArgumentException("no data for '" + string + "'");
    }

    public String[] getRowTitles() {
        return this.rowTitles;
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
    }

    public double[][] getData() {
        return this.data;
    }

    public int getColumnNumber(String string) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.columnTitles[i].equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("no column named " + string);
    }

    public double[] getColumn(String string) {
        int n = this.getColumnNumber(string);
        double[] dArray = new double[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            dArray[i] = this.get(i, n);
        }
        return dArray;
    }

    public String[] getUnmaskedColumnTitles() {
        return this.columnTitles;
    }

    public String getRowTitlesTitle() {
        return this.rowTitlesTitle;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public void add(DataMatrix dataMatrix) {
        System.out.println("DataMatrix.add (DataMatrix)");
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.columnTitles.length;
        String[] stringArray = this.getColumnTitles();
        stringBuffer.append(this.rowTitlesTitle);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("\t");
            stringBuffer.append(stringArray[n]);
        }
        stringBuffer.append("\n");
        n = this.rowTitles.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.get(i);
            stringBuffer.append(this.rowTitles[i]);
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append("\t");
                stringBuffer.append(dArray[j]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(DataMatrix dataMatrix) {
        return this.toString().equals(dataMatrix.toString());
    }
}

