/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dante.plot2d;

import csplugins.isb.dante.plot2d.LegendTableCellRenderer;
import csplugins.isb.dante.plot2d.UnsortedXYSeries;
import csplugins.isb.dante.plot2d.XYMetaData;
import csplugins.isb.pshannon.dataMatrix.DataMatrixLens;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.CyclicXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeriesCollection;

public class Plot2D
extends JFrame {
    private String[] xLabels;
    private JComboBox cb;
    private String title;
    private String xAxisLabel;
    private String yAxisLabel;
    private ChartPanel chartPanel;
    private XYPlot plot;
    private int maxCols = 0;
    private XYSeriesCollection dataset;
    private JPanel legPanel;
    private JPanel statusPanel;
    private boolean showStatus = true;
    private JLabel lblX = new JLabel("   X:");
    private JLabel lblY = new JLabel("   Y:");
    private JLabel lblRow = new JLabel("   Row:");
    private JLabel lblXAxis = new JLabel();
    private Vector savedPaints;
    private ItemListSelectionListener ilsl;
    private JScrollPane scrollPane;
    private JScrollPane statusScroll;
    private JSplitPane sPane;
    private JFreeChart chart;
    private JButton dismissButton;
    private static final int UNIT = 20;
    private static final int MIN_WIDTH = 333;
    private int width;
    private int cbWidth;
    private JList itemList;
    private boolean allowLiveUpdate = false;
    private int populateCount = 0;
    private DataMatrixLens dm = null;
    static /* synthetic */ Class class$java$util$Vector;

    public Plot2D(String string, String string2, String string3, boolean bl, boolean bl2, DataMatrixLens dataMatrixLens) {
        super(string);
        this.title = string;
        this.xAxisLabel = string2;
        this.yAxisLabel = string3;
        this.showStatus = bl;
        this.allowLiveUpdate = bl2;
        this.dm = dataMatrixLens;
        this.initUI();
    }

    public Plot2D(String string, String string2, String string3, boolean bl, DataMatrixLens dataMatrixLens) {
        this(string, string2, string3, bl, false, dataMatrixLens);
    }

    public Plot2D(String string, String string2, String string3, DataMatrixLens dataMatrixLens) {
        this(string, string2, string3, true, dataMatrixLens);
    }

    public Plot2D(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, bl, null);
    }

    public Plot2D(String string, String string2, String string3) {
        this(string, string2, string3, true);
    }

    private void initUI() {
        JComponent jComponent;
        JComponent jComponent2;
        Serializable serializable;
        Serializable serializable2;
        this.setSize(300, 400);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.itemList = new JList();
        this.ilsl = new ItemListSelectionListener();
        this.itemList.addListSelectionListener(this.ilsl);
        JScrollPane jScrollPane = new JScrollPane(this.itemList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        JButton jButton = new JButton("Clear");
        class ClearAction
        extends AbstractAction {
            public ClearAction() {
                super("Clear");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Plot2D.this.itemList.clearSelection();
                Plot2D.this.resetColors();
            }
        }
        jButton.setAction(new ClearAction());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.getContentPane().add((Component)jButton, gridBagConstraints);
        this.dataset = new XYSeriesCollection();
        this.legPanel = new JPanel();
        this.chart = this.createChart(this.dataset);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setHorizontalZoom(true);
        this.chartPanel.setVerticalZoom(true);
        LineBorder lineBorder = new LineBorder(Color.BLACK, 5);
        this.chartPanel.setBorder(lineBorder);
        this.chartPanel.addChartMouseListener(new ML());
        this.chartPanel.setHorizontalZoom(false);
        this.chartPanel.setVerticalZoom(false);
        this.chartPanel.setSize(200, 200);
        this.chartPanel.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.chartPanel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.statusPanel = new JPanel();
        LineBorder lineBorder2 = new LineBorder(Color.BLACK, 2);
        jPanel.setBorder(lineBorder2);
        this.scrollPane = new JScrollPane(this.legPanel);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        if (this.showStatus) {
            jPanel.setLayout(new GridLayout(1, 1));
            this.statusPanel.setLayout(new GridLayout(6, 1));
            serializable2 = this.lblX.getFont();
            serializable = new Font(((Font)serializable2).getFontName(), ((Font)serializable2).getStyle(), 9);
            this.lblX.setFont((Font)serializable);
            this.lblY.setFont((Font)serializable);
            this.lblRow.setFont((Font)serializable);
            this.lblXAxis.setFont((Font)serializable);
            this.statusPanel.add(this.lblX);
            this.statusPanel.add(this.lblY);
            this.statusPanel.add(this.lblRow);
            this.lblXAxis.setText("   " + this.xAxisLabel + ": ");
            this.statusPanel.add(this.lblXAxis);
            jComponent2 = new JLabel("");
            this.statusPanel.add(jComponent2);
            jComponent = new JLabel("");
            this.statusPanel.add(jComponent);
            this.statusScroll = new JScrollPane(this.statusPanel);
            this.statusScroll.setVerticalScrollBarPolicy(21);
            this.sPane = new JSplitPane(1, this.statusScroll, this.scrollPane);
            this.sPane.setOneTouchExpandable(true);
            this.sPane.setContinuousLayout(false);
            jPanel.add(this.sPane);
            this.scrollPane.setPreferredSize(new Dimension(1, 30));
        } else {
            jPanel.add(this.scrollPane);
            jPanel.setLayout(new GridLayout(1, 2));
            this.scrollPane.setPreferredSize(new Dimension(this.getWidth() + 10, 30));
        }
        jPanel2.add((Component)jPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.statusScroll, gridBagConstraints);
        serializable2 = new JPanel();
        this.dismissButton = new JButton("OK");
        this.dismissButton.setActionCommand("dismiss");
        this.dismissButton.addActionListener(new DismissAction(this));
        ((Container)serializable2).add(this.dismissButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.dismissButton, gridBagConstraints);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BorderLayout());
        jComponent2 = new JPanel();
        this.cb = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.getContentPane().add((Component)this.cb, gridBagConstraints);
        if (null != this.dm) {
            jComponent = new JCheckBox();
            ((AbstractButton)jComponent).setSelected(this.allowLiveUpdate);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    Plot2D.this.allowLiveUpdate = jCheckBox.isSelected();
                }
            });
            JLabel jLabel = new JLabel("Enable Live Update");
            Font font = jLabel.getFont();
            Font font2 = new Font(font.getFontName(), font.getStyle(), 9);
            jLabel.setFont(font2);
            String string = "Checking this box means that the plot will change in real time if the underlying data changes.";
            jComponent.setToolTipText(string);
            jLabel.setToolTipText(string);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jComponent, "West");
            jPanel3.add((Component)jLabel, "Center");
            jPanel3.setBorder(new EtchedBorder());
            ((Container)serializable).add(jPanel3, "Center");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 7;
            this.getContentPane().add((Component)jPanel3, gridBagConstraints);
        }
        ((Container)serializable).add(jComponent2, "West");
        ((Container)serializable).add((Component)serializable2, "East");
        jPanel2.add((Component)serializable, "South");
        jPanel2.setMaximumSize(jPanel2.getSize());
        jPanel2.setMinimumSize(jPanel2.getSize());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (Plot2D.this.width == 0) {
                    return;
                }
                JFrame jFrame = (JFrame)componentEvent.getSource();
                if (jFrame.getWidth() == Plot2D.this.width) {
                    return;
                }
                if (Plot2D.this.width / 20 == jFrame.getWidth() / 20) {
                    jFrame.setSize(Plot2D.this.getSize());
                    return;
                }
                if (jFrame.getWidth() < 333) {
                    jFrame.setSize(333, jFrame.getHeight());
                }
                Plot2D.this.width = jFrame.getWidth();
                Plot2D.this.setupLegendPanel(Plot2D.this.legPanel.getWidth());
                Plot2D.this.repaint();
            }
        });
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (!Plot2D.this.showStatus) {
                    return;
                }
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getSource();
                Plot2D.this.setupLegendPanel(jScrollPane.getWidth());
                Plot2D.this.repaint();
            }
        });
    }

    public void addDismissListener(ActionListener actionListener) {
        this.dismissButton.addActionListener(actionListener);
    }

    private void setupLegendPanel(int n) {
        LegendItemCollection legendItemCollection = this.chart.getPlot().getLegendItems();
        if (legendItemCollection.getItemCount() == 0) {
            return;
        }
        this.legPanel.removeAll();
        JTable jTable = new JTable(new MyTableModel(n, legendItemCollection));
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                listSelectionModel.clearSelection();
            }
        });
        jTable.setDefaultRenderer(class$java$util$Vector == null ? (class$java$util$Vector = Plot2D.class$("java.util.Vector")) : class$java$util$Vector, new LegendTableCellRenderer(true));
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(20);
        }
        jTable.setBackground(Color.WHITE);
        jTable.setShowGrid(false);
        if (this.legPanel.getComponentCount() > 0) {
            this.legPanel.removeAll();
        }
        this.legPanel.add(jTable);
        this.legPanel.revalidate();
        this.repaint();
    }

    public void addChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartPanel.addChartMouseListener(chartMouseListener);
    }

    private UnsortedXYSeries getSeries(String string) {
        if (this.dataset.getSeriesCount() == 0) {
            UnsortedXYSeries unsortedXYSeries = new UnsortedXYSeries(string);
            this.dataset.addSeries(unsortedXYSeries);
            return unsortedXYSeries;
        }
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            if (!this.dataset.getSeries(i).getName().equals(string)) continue;
            return (UnsortedXYSeries)this.dataset.getSeries(i);
        }
        UnsortedXYSeries unsortedXYSeries = new UnsortedXYSeries(string);
        this.dataset.addSeries(unsortedXYSeries);
        return unsortedXYSeries;
    }

    private void addPoints(UnsortedXYSeries unsortedXYSeries, double[] dArray, double[] dArray2) {
        boolean bl = false;
        if (null == dArray) {
            bl = true;
            dArray = new double[dArray2.length];
        }
        for (int i = 0; i < dArray2.length; ++i) {
            if (bl) {
                dArray[i] = i;
            }
            unsortedXYSeries.add(dArray[i], dArray2[i]);
        }
    }

    public void addData(String string, double[] dArray) {
        UnsortedXYSeries unsortedXYSeries = this.getSeries(string);
        this.addPoints(unsortedXYSeries, null, dArray);
        this.setupXLabels();
    }

    public void setXLabels(String[] stringArray) {
        this.xLabels = stringArray;
        this.setupXLabels();
    }

    public void addData(String string, double[] dArray, boolean bl) {
        this.addData(string, dArray);
    }

    public void addData(String string, double[] dArray, double[] dArray2) throws IndexOutOfBoundsException {
        if (dArray.length != dArray2.length) {
            String string2 = "Exception: x.length = " + dArray.length + ", y.length = " + dArray2.length;
            throw new IndexOutOfBoundsException(string2);
        }
        UnsortedXYSeries unsortedXYSeries = this.getSeries(string);
        this.addPoints(unsortedXYSeries, dArray, dArray2);
        this.setupXLabels();
    }

    private void setupXLabels() {
        this.cb.removeAllItems();
        this.cb.addItem("X axis legend:");
        this.cbWidth = this.cb.getWidth();
        long l = (long)this.plot.getDomainAxis().getUpperBound();
        if ((double)l > this.plot.getDomainAxis().getUpperBound()) {
            --l;
        }
        for (long i = 0L; i <= l; ++i) {
            String string = "" + i;
            try {
                string = string + " - " + this.xLabels[(int)i];
            }
            catch (Exception exception) {
                string = string + " - Unknown";
            }
            this.cb.addItem(string);
        }
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(null, this.xAxisLabel, this.yAxisLabel, xYDataset, PlotOrientation.VERTICAL, false, true, false);
        this.plot = jFreeChart.getXYPlot();
        this.plot.getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.plot.setRenderer(new CyclicXYItemRenderer(3));
        AbstractRenderer abstractRenderer = (AbstractRenderer)((Object)this.plot.getRenderer());
        Rectangle2D.Double double_ = new Rectangle2D.Double(-4.0, -4.0, 10.0, 10.0);
        abstractRenderer.setShape(double_);
        this.plot.getRenderer().setToolTipGenerator(new XYToolTipGenerator(){

            public String generateToolTip(XYDataset xYDataset, int n, int n2) {
                double d = (Double)xYDataset.getXValue(n, n2);
                double d2 = (Double)xYDataset.getYValue(n, n2);
                String string = xYDataset.getSeriesName(n);
                String string2 = "";
                if (d % 1.0 == 0.0) {
                    try {
                        string2 = ", " + Plot2D.this.xAxisLabel + "=" + Plot2D.this.xLabels[(int)d];
                    }
                    catch (Exception exception) {
                        string2 = ", " + Plot2D.this.xAxisLabel + "=Unknown";
                    }
                }
                return "x=" + d + ", y=" + d2 + ", row=" + string + string2;
            }
        });
        return jFreeChart;
    }

    private void resetStatusPanel() {
        this.lblX.setText("   X:");
        this.lblY.setText("   Y:");
        this.lblRow.setText("   Row:");
        this.lblXAxis.setText("   " + this.xAxisLabel + ":");
    }

    public void setSize(Dimension dimension) {
        int n = dimension.getWidth() < 333.0 ? 333 : (int)dimension.getWidth();
        super.setSize(n, (int)dimension.getHeight());
    }

    public void setSize(int n, int n2) {
        this.setSize(new Dimension(n, n2));
    }

    private void resetColors() {
        XYItemRenderer xYItemRenderer = this.plot.getRenderer();
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            xYItemRenderer.setSeriesPaint(i, (Paint)this.savedPaints.get(i));
        }
    }

    private void setupItemList() {
        this.itemList.setCellRenderer(new SelectorListRenderer());
        LegendItemCollection legendItemCollection = this.plot.getLegendItems();
        Vector<LegendItem> vector = new Vector<LegendItem>();
        this.savedPaints = new Vector();
        for (int i = 0; i < legendItemCollection.getItemCount(); ++i) {
            LegendItem legendItem = legendItemCollection.get(i);
            vector.add(legendItem);
            this.savedPaints.add(legendItem.getPaint());
        }
        this.itemList.setListData(vector);
    }

    public void show() {
        if (null != this.dm) {
            this.populateFromLens(this.dm);
        }
        this.setupItemList();
        this.width = this.getWidth();
        this.setupLegendPanel(this.width);
        if (this.showStatus) {
            this.sPane.setDividerLocation(0.68);
        }
        super.show();
        if (this.showStatus) {
            this.setupLegendPanel(this.scrollPane.getWidth());
        }
        this.setSize(this.getSize());
    }

    public void populateFromLens(DataMatrixLens dataMatrixLens) {
        if (!this.allowLiveUpdate) {
            if (this.populateCount == 0) {
                ++this.populateCount;
            } else {
                return;
            }
        }
        this.setTitle(dataMatrixLens.getMatrixName());
        this.resetStatusPanel();
        this.dataset.removeAllSeries();
        this.yAxisLabel = dataMatrixLens.getMatrixName();
        if (dataMatrixLens.getSelectedRowCount() == 0) {
            return;
        }
        String[] stringArray = dataMatrixLens.getFilteredColumnTitles();
        if (stringArray.length > dataMatrixLens.getEnabledColumnCount()) {
            String[] stringArray2 = new String[dataMatrixLens.getEnabledColumnCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0) continue;
                stringArray2[i - 1] = stringArray[i];
            }
            this.setXLabels(stringArray2);
        } else {
            this.setXLabels(stringArray);
        }
        for (int i = 0; i < dataMatrixLens.getSelectedRowCount(); ++i) {
            double[] dArray = dataMatrixLens.getFromSelected(i);
            this.addData(dataMatrixLens.getSelectedRowTitles()[i], dArray);
        }
        this.chart = this.createChart(this.dataset);
        if (this.chartPanel != null) {
            this.chartPanel.setChart(this.chart);
        }
        this.setupLegendPanel(this.legPanel.getWidth());
        this.setupItemList();
        this.resetColors();
        this.repaint();
    }

    public void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ItemListSelectionListener
    implements ListSelectionListener {
        ItemListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            int[] nArray = Plot2D.this.itemList.getSelectedIndices();
            Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
            for (int i = 0; i < nArray.length; ++i) {
                hashtable.put(new Integer(nArray[i]), "~");
            }
            LegendItemCollection legendItemCollection = Plot2D.this.plot.getLegendItems();
            XYItemRenderer xYItemRenderer = Plot2D.this.plot.getRenderer();
            Color color = new Color(230, 230, 230);
            for (int i = 0; i < Plot2D.this.dataset.getSeriesCount(); ++i) {
                try {
                    String string = (String)hashtable.get(new Integer(i));
                    if ("~".equals(string)) {
                        xYItemRenderer.setSeriesPaint(i, (Paint)Plot2D.this.savedPaints.get(i));
                        continue;
                    }
                    xYItemRenderer.setSeriesPaint(i, color);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("caught ex");
                }
            }
            Plot2D.this.chartPanel.repaint();
        }
    }

    class SelectorListRenderer
    implements ListCellRenderer {
        SelectorListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            LegendItem legendItem = null;
            if (object instanceof LegendItem) {
                legendItem = (LegendItem)object;
            }
            JLabel jLabel = new JLabel();
            Font font = new Font(jList.getFont().getName(), 0, jList.getFont().getSize() - 2);
            jLabel.setFont(font);
            jLabel.setOpaque(true);
            jLabel.setText(legendItem.getLabel());
            jLabel.setToolTipText(legendItem.getLabel());
            int[] nArray = Plot2D.this.itemList.getSelectedIndices();
            if (bl) {
                jLabel.setBackground(Color.WHITE);
                jLabel.setForeground((Color)legendItem.getPaint());
            } else {
                jLabel.setBackground((Color)legendItem.getPaint());
            }
            return jLabel;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        boolean DEBUG = false;
        private String[] columnNames;
        private Object[][] data;

        public MyTableModel(int n, LegendItemCollection legendItemCollection) {
            int n2;
            int n3;
            if (n == 0) {
                return;
            }
            int n4 = n / 20;
            if (n % 20 != 0 && n4 > 1) {
                --n4;
            }
            if (n4 > legendItemCollection.getItemCount()) {
                n4 = legendItemCollection.getItemCount();
            }
            int n5 = legendItemCollection.getItemCount() / n4;
            if (legendItemCollection.getItemCount() % n4 != 0) {
                ++n5;
            }
            if (legendItemCollection.getItemCount() > n5 * n4) {
                ++n5;
            }
            this.columnNames = new String[n4];
            this.data = new Object[n5][n4];
            for (n3 = 0; n3 < n5; ++n3) {
                for (n2 = 0; n2 < n4; ++n2) {
                    Vector<Object> vector = new Vector<Object>();
                    vector.add(Color.WHITE);
                    vector.add("");
                    this.data[n3][n2] = vector;
                }
            }
            n3 = 0;
            n2 = 0;
            for (int i = 0; i < legendItemCollection.getItemCount(); ++i) {
                LegendItem legendItem = legendItemCollection.get(i);
                Vector<Object> vector = new Vector<Object>();
                vector.add((Color)legendItem.getPaint());
                vector.add(legendItem.getLabel());
                if (legendItemCollection.getItemCount() == n4) {
                    this.data[0][i] = vector;
                    continue;
                }
                this.data[n3][n2++] = vector;
                if (n2 % n4 != 0) continue;
                n2 = 0;
                ++n3;
            }
        }

        public int getColumnCount() {
            if (null == this.columnNames) {
                return 0;
            }
            return this.columnNames.length;
        }

        public int getRowCount() {
            if (null == this.data) {
                return 0;
            }
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (this.DEBUG) {
                System.out.println("Setting value at " + n + "," + n2 + " to " + object + " (an instance of " + object.getClass() + ")");
            }
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
            if (this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < n2; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }

    class ML
    implements ChartMouseListener {
        ML() {
        }

        public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
            ChartEntity chartEntity = chartMouseEvent.getEntity();
            String string = null;
            try {
                string = chartEntity.getShapeType();
            }
            catch (NullPointerException nullPointerException) {
                Plot2D.this.resetStatusPanel();
                return;
            }
            XYMetaData xYMetaData = XYMetaData.parseToolTip(chartEntity.getToolTipText());
            Plot2D.this.lblX.setText("   X: " + xYMetaData.getX());
            Plot2D.this.lblY.setText("   Y: " + xYMetaData.getY());
            Plot2D.this.lblRow.setText("   Row: " + xYMetaData.getRow());
            try {
                Plot2D.this.lblXAxis.setText("   " + Plot2D.this.xAxisLabel + ": " + xYMetaData.getXTickName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
        }
    }

    public class DismissAction
    extends AbstractAction {
        private JFrame frame;

        DismissAction(JFrame jFrame) {
            this.frame = jFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.frame.dispose();
        }
    }
}

