/*
 * Decompiled with CFR 0.152.
 */
package csplugins.common.vectormath;

import csplugins.common.vectormath.MathVector;
import csplugins.common.vectormath.MathVectorFactory;
import csplugins.common.vectormath.ReadOnlyVectorDataProvider;

public class ReadOnlyMathVector
implements ReadOnlyVectorDataProvider {
    ReadOnlyVectorDataProvider p;

    ReadOnlyMathVector(ReadOnlyVectorDataProvider readOnlyVectorDataProvider) {
        this.p = readOnlyVectorDataProvider;
    }

    public MathVector copy() {
        return MathVectorFactory.makeVector(this.getNewDataArray());
    }

    public ReadOnlyMathVector readOnlyCopy() {
        return MathVectorFactory.makeReadOnlyVector(this.getNewDataArray());
    }

    public double[] getNewDataArray() {
        int n = this.p.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.p.getQuick(i);
        }
        return dArray;
    }

    public int size() {
        return this.p.size();
    }

    public static int verifySizeMatch(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        int n = readOnlyMathVector.p.size();
        if (n == readOnlyMathVector2.p.size()) {
            return n;
        }
        String string = "vector size mismatch: first = " + n + ", second = " + readOnlyMathVector2.p.size();
        throw new IndexOutOfBoundsException(string);
    }

    public double get(int n) throws IndexOutOfBoundsException {
        if (n > -1 && n < this.p.size()) {
            return this.p.getQuick(n);
        }
        String string = "Element requested: " + n + ",  vector size: " + this.p.size();
        throw new IndexOutOfBoundsException(string);
    }

    public double getQuick(int n) {
        return this.p.getQuick(n);
    }

    public boolean equals(ReadOnlyMathVector readOnlyMathVector, double d) throws IndexOutOfBoundsException {
        if (this.p == readOnlyMathVector.p) {
            return true;
        }
        int n = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(this.p.getQuick(i) - readOnlyMathVector.p.getQuick(i)) > d)) continue;
            return false;
        }
        return true;
    }

    public double mag() {
        return Math.sqrt(this.magSquared());
    }

    public double magSquared() {
        double d = 0.0;
        for (int i = 0; i < this.p.size(); ++i) {
            double d2 = this.p.getQuick(i);
            d += d2 * d2;
        }
        return d;
    }

    public double mean() {
        double d = 0.0;
        int n = this.p.size();
        if (n == 0) {
            return d;
        }
        for (int i = 0; i < n; ++i) {
            d += this.p.getQuick(i);
        }
        return d / (double)n;
    }

    public double dot(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        int n = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.p.getQuick(i) * readOnlyMathVector.p.getQuick(i);
        }
        return d;
    }

    public double dotNorm(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        double d = this.mag() * readOnlyMathVector.mag();
        return d == 0.0 ? 0.0 : this.dot(readOnlyMathVector) / d;
    }

    public double correlation(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        int n = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        MathVector mathVector = this.copy().subtract(this.mean());
        MathVector mathVector2 = readOnlyMathVector.copy().subtract(readOnlyMathVector.mean());
        return mathVector.dot(mathVector2) / (mathVector.mag() * mathVector2.mag());
    }

    public String toString() {
        int n = this.p.size();
        if (n < 1) {
            return new String("()");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( " + this.p.getQuick(0));
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(", " + this.p.getQuick(i));
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

