/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.util.CommandLineOptions;
import org.python.util.InteractiveConsole;

public class jython {
    private static String usage = "usage: jython [options] [-jar jar | -c cmd | file | -] [args]\nOptions and arguments:\n-i       : inspect interactively after running script, and force\n           prompts, even if stdin does not appear to be a terminal\n-S       : don't imply `import site' on initialization\n-v       : verbose (trace import statements)\n-Dprop=v : Set the property `prop' to value `v'\n-jar jar : program read from __run__.py in jar file\n-c cmd   : program passed in as string (terminates option list)\n-W arg   : warning control (arg is action:message:category:module:lineno)\n-E codec : Use a different codec the reading from the console.\nfile     : program read from script file\n-        : program read from stdin (default; interactive mode if a tty)\n--help   : print this usage message and exit\n--version: print Jython version number and exit\nargs     : arguments passed to program in sys.argv[1:]";

    /*
     * WARNING - void declaration
     */
    public static void runJar(String filename) {
        try {
            void code;
            ZipFile zip = new ZipFile(filename);
            ZipEntry runit = zip.getEntry("__run__.py");
            if (runit == null) {
                throw Py.ValueError("jar file missing '__run__.py'");
            }
            PyStringMap locals = new PyStringMap();
            locals.__setitem__("__name__", (PyObject)new PyString(filename));
            locals.__setitem__("zipfile", Py.java2py(zip));
            InputStream file = zip.getInputStream(runit);
            try {
                PyCode pyCode = Py.compile(file, "__run__", "exec");
            }
            finally {
                Object var7_7 = null;
                file.close();
            }
            Py.runCode((PyCode)code, locals, locals);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        InteractiveConsole interp;
        CommandLineOptions opts;
        block34: {
            block35: {
                block36: {
                    block33: {
                        opts = new CommandLineOptions();
                        if (!opts.parse(args)) {
                            if (opts.version) {
                                System.err.println(InteractiveConsole.getDefaultBanner());
                                System.exit(0);
                            }
                            System.err.println(usage);
                            int exitcode = opts.help ? 0 : -1;
                            System.exit(exitcode);
                        }
                        PySystemState.initialize(System.getProperties(), opts.properties, opts.argv);
                        if (opts.notice) {
                            System.err.println(InteractiveConsole.getDefaultBanner());
                        }
                        interp = null;
                        try {
                            String interpClass = PySystemState.registry.getProperty("python.console", "org.python.util.InteractiveConsole");
                            interp = (InteractiveConsole)Class.forName(interpClass).newInstance();
                        }
                        catch (Exception e) {
                            interp = new InteractiveConsole();
                        }
                        PyModule mod = imp.addModule("__main__");
                        interp.setLocals(mod.__dict__);
                        int i = 0;
                        while (i < opts.warnoptions.size()) {
                            String wopt = (String)opts.warnoptions.elementAt(i);
                            PySystemState.warnoptions.append(new PyString(wopt));
                            ++i;
                        }
                        String msg = "";
                        if (Options.importSite) {
                            try {
                                boolean license;
                                imp.load("site");
                                if (!opts.notice) break block33;
                                PyObject builtins = Py.getSystemState().builtins;
                                boolean copyright = builtins.__finditem__("copyright") != null;
                                boolean credits = builtins.__finditem__("credits") != null;
                                boolean bl = license = builtins.__finditem__("license") != null;
                                if (copyright) {
                                    msg = msg + "\"copyright\"";
                                    if (credits && license) {
                                        msg = msg + ", ";
                                    } else if (credits || license) {
                                        msg = msg + " or ";
                                    }
                                }
                                if (credits) {
                                    msg = msg + "\"credits\"";
                                    if (license) {
                                        msg = msg + " or ";
                                    }
                                }
                                if (license) {
                                    msg = msg + "\"license\"";
                                }
                                if (msg.length() > 0) {
                                    System.err.println("Type " + msg + " for more information.");
                                }
                            }
                            catch (PyException pye) {
                                if (Py.matchException(pye, Py.ImportError)) break block33;
                                System.err.println("error importing site");
                                Py.printException(pye);
                                System.exit(-1);
                            }
                        }
                    }
                    if (opts.command != null) {
                        try {
                            interp.exec(opts.command);
                        }
                        catch (Throwable t) {
                            Py.printException(t);
                        }
                    }
                    if (opts.filename == null) break block35;
                    String path = new File(opts.filename).getParent();
                    if (path == null) {
                        path = "";
                    }
                    Py.getSystemState().path.insert(0, new PyString(path));
                    if (!opts.jar) break block36;
                    jython.runJar(opts.filename);
                    break block34;
                }
                if (opts.filename.equals("-")) {
                    try {
                        interp.execfile(System.in, "<stdin>");
                    }
                    catch (Throwable t) {
                        Py.printException(t);
                    }
                    break block34;
                } else {
                    try {
                        interp.execfile(opts.filename);
                    }
                    catch (Throwable t) {
                        Py.printException(t);
                        if (!opts.interactive) {
                            interp.cleanup();
                            System.exit(-1);
                        }
                        break block34;
                    }
                }
            }
            Py.getSystemState().path.insert(0, new PyString(""));
        }
        if (opts.interactive) {
            if (opts.encoding == null) {
                opts.encoding = PySystemState.registry.getProperty("python.console.encoding", null);
            }
            if (opts.encoding != null) {
                interp.cflags.encoding = opts.encoding;
            }
            try {
                interp.interact(null);
            }
            catch (Throwable t) {
                Py.printException(t);
            }
        }
        interp.cleanup();
    }
}

