/*
 * Decompiled with CFR 0.152.
 */
package csplugins.trial.pshannon.dataCube;

import csplugins.trial.pshannon.dataCube.DataMatrix;
import csplugins.trial.pshannon.dataCube.DataMatrixReader;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import java.io.File;
import java.util.ArrayList;

public class DataMatrixFileReader
extends DataMatrixReader {
    ArrayList matrices = new ArrayList();

    public DataMatrixFileReader(String protocol, String path) {
        super(protocol, path);
    }

    public DataMatrix[] get() throws Exception {
        return this.matrices.toArray(new DataMatrix[0]);
    }

    public void read() throws Exception {
        String rawText = null;
        if (this.protocol.equals("file://")) {
            File file = new File(this.path);
            if (!file.exists()) {
                throw new IllegalArgumentException("cannot find file named '" + this.path + "'");
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("cannot read file named '" + this.path + "'");
            }
            TextFileReader reader = new TextFileReader(this.path);
            reader.read();
            rawText = reader.getText();
        } else if (this.protocol.equals("jar://")) {
            TextJarReader reader = new TextJarReader(this.protocol + this.path);
            reader.read();
            rawText = reader.getText();
        }
        this.parseText(rawText);
    }

    protected void parseText(String rawText) throws Exception {
        String[] lines = rawText.split("\n");
        String[] titles = lines[0].split("\t");
        DataMatrix matrix = new DataMatrix(this.protocol + this.path);
        int dataRows = lines.length - 1;
        int dataColumns = titles.length - 1;
        matrix.setSize(dataRows, dataColumns);
        matrix.setColumnTitles(titles);
        ArrayList<String> rowTitleList = new ArrayList<String>();
        for (int row = 1; row < lines.length; ++row) {
            String rowString = lines[row];
            String[] tokens = rowString.split("\t");
            String rowTitle = tokens[0];
            rowTitleList.add(rowTitle);
            for (int col = 1; col < tokens.length; ++col) {
                String tmp = tokens[col];
                try {
                    double value = new Double(tmp);
                    matrix.set(row - 1, col - 1, value);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String msg = "cannot convert '" + tmp + "' to double, at row " + (row - 1) + " column " + (col - 1) + " while reading file " + this.path;
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        matrix.setRowTitles(rowTitleList.toArray(new String[0]));
        this.matrices.add(matrix);
    }
}

