/*
 * Decompiled with CFR 0.152.
 */
package csplugins.trial.pshannon.dataCube;

public class DataMatrix {
    String[] columnTitles;
    String[] rowTitles;
    double[][] data;
    String uri;
    String name;

    public DataMatrix(String uri) throws Exception {
        this.uri = uri.trim();
        this.name = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(int rows, int columns) {
        this.data = new double[rows][columns];
    }

    public void set(int row, int column, double value) {
        this.data[row][column] = value;
    }

    public void setColumnTitles(String[] newValues) {
        this.columnTitles = newValues;
    }

    public void setRowTitles(String[] newValues) {
        this.rowTitles = newValues;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColumnCount() {
        return this.data[0].length;
    }

    public double get(int row, int column) {
        return this.data[row][column];
    }

    public double[] getUntransformed(int row) {
        return this.data[row];
    }

    public double[] get(int row) {
        return this.data[row];
    }

    public double[] get(String rowName) {
        for (int i = 0; i < this.rowTitles.length; ++i) {
            if (!this.rowTitles[i].equals(rowName)) continue;
            return this.data[i];
        }
        throw new IllegalArgumentException("no data for '" + rowName + "'");
    }

    public String[] getRowTitles() {
        return this.rowTitles;
    }

    public String[] getUnmaskedColumnTitles() {
        return this.columnTitles;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int colMax = this.columnTitles.length;
        String[] columnTitles = this.getColumnTitles();
        for (int c = 0; c < colMax; ++c) {
            if (c != 0) {
                sb.append("\t");
            }
            sb.append(columnTitles[c]);
        }
        sb.append("\n");
        int rowMax = this.rowTitles.length;
        for (int r = 0; r < rowMax; ++r) {
            double[] adjustedRow = this.get(r);
            sb.append(this.rowTitles[r]);
            for (int c = 0; c < colMax - 1; ++c) {
                sb.append("\t");
                sb.append(adjustedRow[c]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

