/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.util;

import csplugins.isb.dreiss.util.StreamGobbler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.StringTokenizer;

public class ExecRunner {
    private static final String WINDOWS_NT_2000_COMMAND_1 = "cmd.exe";
    private static final String WINDOWS_NT_2000_COMMAND_2 = "/C";
    private static final String WINDOWS_9X_ME_COMMAND_1 = "command.exe";
    private static final String WINDOWS_9X_ME_COMMAND_2 = "/C";
    private static final String MAX_RUN_TIME_EXCEEDED_STRING = "MAX_RUN_TIME_EXCEEDED";
    private String out = new String();
    private String err = new String();
    protected String[] myEnv = null;
    private int maxRunTimeSecs = 0;
    private boolean maxRunTimeExceeded = false;
    private static final String CLASS_NAME = "ExecRunner";
    private static final String VERSION = "CVS $Revision: 1.1 $";

    public ExecRunner() {
    }

    public ExecRunner(String command) throws ExceptionInInitializerError {
        this();
        try {
            this.exec(command);
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe.getMessage());
        }
        catch (InterruptedException inte) {
            throw new ExceptionInInitializerError(inte.getMessage());
        }
    }

    public void setEnvironment(String[] env) {
        this.myEnv = env;
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int exec(String command) throws IOException, InterruptedException {
        StringWriter swOut = new StringWriter();
        PrintWriter pwOut = new PrintWriter((Writer)swOut, true);
        StringWriter swErr = new StringWriter();
        PrintWriter pwErr = new PrintWriter((Writer)swErr, true);
        int rc = this.exec(command, pwOut, pwErr);
        this.out = swOut.toString();
        this.err = swErr.toString();
        return rc;
    }

    public int exec(String command, OutputStream stdoutStream, OutputStream stderrStream) throws IOException, InterruptedException {
        return this.exec(command, null, stdoutStream, stderrStream);
    }

    public int exec(String command, String stdin, OutputStream stdoutStream, OutputStream stderrStream) throws IOException, InterruptedException {
        PrintWriter pwOut = new PrintWriter(stdoutStream, true);
        PrintWriter pwErr = new PrintWriter(stderrStream, true);
        return this.exec(command, stdin, pwOut, pwErr);
    }

    public int exec(String command, PrintWriter stdoutWriter, PrintWriter stderrWriter) throws IOException, InterruptedException {
        return this.exec(command, stdoutWriter, stderrWriter);
    }

    /*
     * WARNING - void declaration
     */
    public int exec(String command, String stdin, PrintWriter stdoutWriter, PrintWriter stderrWriter) throws IOException, InterruptedException {
        void var7_18;
        int exitVal = 1;
        Runtime rt = Runtime.getRuntime();
        String[] cmd = null;
        Date startTime = new Date();
        long startTimeMs = startTime.getTime();
        long maxTimeMs = startTimeMs + (long)(this.maxRunTimeSecs * 1000);
        boolean isWindows = false;
        String osName = System.getProperty("os.name");
        if (osName.equals("Windows NT") || osName.equals("Windows 2000")) {
            cmd = new String[]{WINDOWS_NT_2000_COMMAND_1, "/C", command};
            isWindows = true;
        } else if (osName.equals("Windows 95") || osName.equals("Windows 98") || osName.equals("Windows ME")) {
            cmd = new String[]{WINDOWS_9X_ME_COMMAND_1, "/C", command};
            isWindows = true;
        } else {
            StringTokenizer st = new StringTokenizer(command, " ");
            cmd = new String[st.countTokens()];
            int token = 0;
            while (st.hasMoreTokens()) {
                String tokenString = st.nextToken();
                cmd[token++] = tokenString;
            }
        }
        if (cmd != null && cmd.length > 0) {
            Process proc = rt.exec(cmd, this.myEnv);
            if (stdin != null && stdin.length() > 0) {
                PrintWriter stdinStr = new PrintWriter(new BufferedOutputStream(proc.getOutputStream()), true);
                stdinStr.println(stdin);
                if (isWindows) {
                    stdinStr.write(26);
                }
                stdinStr.flush();
                stdinStr.close();
            }
        } else {
            throw new IOException("Insufficient commands!");
        }
        StreamGobbler outputGobbler = new StreamGobbler(var7_18.getInputStream(), stdoutWriter);
        StreamGobbler errorGobbler = new StreamGobbler(var7_18.getErrorStream(), stderrWriter);
        outputGobbler.start();
        errorGobbler.start();
        while (true) {
            try {
                exitVal = var7_18.exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (this.maxRunTimeSecs <= 0) continue;
                Date endTime = new Date();
                long endTimeMs = endTime.getTime();
                if (endTimeMs > maxTimeMs) {
                    var7_18.destroy();
                    this.maxRunTimeExceeded = true;
                    stderrWriter.println(MAX_RUN_TIME_EXCEEDED_STRING);
                    outputGobbler.quit();
                    errorGobbler.quit();
                    return exitVal;
                }
                Thread.sleep(100L);
                continue;
            }
            break;
        }
        while (outputGobbler.isAlive() || errorGobbler.isAlive()) {
        }
        stdoutWriter.flush();
        stderrWriter.flush();
        return exitVal;
    }

    public String getErrString() {
        return this.err;
    }

    public boolean getMaxRunTimeExceeded() {
        return this.maxRunTimeExceeded;
    }

    public int getMaxRunTimeSecs() {
        return this.maxRunTimeSecs;
    }

    public String getOutString() {
        return this.out;
    }

    public static void main(String[] args) throws IOException {
        try {
            ExecRunner er = new ExecRunner();
            System.out.println("Testing ExecRunner with StringWriter...");
            er = new ExecRunner();
            er.setMaxRunTimeSecs(1);
            er.exec("dir /s c:\\");
            System.out.println("<STDOUT>\n" + er.getOutString() + "</STDOUT>");
            System.out.println("<STDERR>\n" + er.getErrString() + "</STDERR>");
            System.out.println("Testing Done");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Object cannot be deserialized");
    }

    public void setMaxRunTimeSecs(int max) {
        this.maxRunTimeSecs = max;
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("Object cannot be serialized");
    }
}

