/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.xmlrpc;

import csplugins.isb.dreiss.httpdata.xmlrpc.AuthenticatedInvoker;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.xmlrpc.SystemHandler;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;

public class MyXmlRpcServer {
    WebServer webserver;
    Hashtable services;
    Hashtable users;
    Hashtable levels;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: java MyXmlRpcServer <port>");
            System.exit(-1);
        }
        try {
            new MyXmlRpcServer(args);
        }
        catch (IOException e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }

    public MyXmlRpcServer(int port) throws IOException {
        System.out.print("Attempting to start XML-RPC server on port " + port + "...");
        this.webserver = new WebServer(port);
        System.out.println("...success!");
        System.out.print("Registering the server as a handler (service \"server\")...");
        this.webserver.addHandler("server", this);
        System.out.println("...success!");
        this.services = new Hashtable();
        this.services.put("server", this);
        this.webserver.start();
    }

    public MyXmlRpcServer(String[] args) throws IOException {
        this(Integer.parseInt(args[0]));
    }

    public WebServer getServer() {
        return this.webserver;
    }

    public boolean addAllowedClientIP(String ip) {
        this.getServer().setParanoid(true);
        this.getServer().acceptClient(ip);
        return true;
    }

    public boolean addDeniededClientIP(String ip) {
        this.getServer().setParanoid(true);
        this.getServer().denyClient(ip);
        return true;
    }

    public Vector listServiceCommands(String service) {
        Vector<String> out = new Vector<String>();
        if (this.services.get(service) == null) {
            return out;
        }
        Object obj = this.services.get(service);
        if (obj instanceof AuthenticatedInvoker) {
            obj = ((AuthenticatedInvoker)obj).getTarget();
        }
        Method[] methods = obj.getClass().getMethods();
        String cname = obj.getClass().getName();
        String sname = obj.getClass().getSuperclass().getName();
        for (int i = 0; i < methods.length; ++i) {
            String mname = methods[i].toString();
            if (mname.indexOf("java.lang.Object.") > 0) continue;
            mname = mname.replaceAll("public ", "");
            mname = mname.replaceAll("static ", "");
            mname = mname.replaceAll("native ", "");
            mname = mname.replaceAll("final ", "");
            mname = mname.replaceAll("java.lang.", "");
            mname = mname.replaceAll("java.util.", "");
            mname = mname.replaceAll(cname + ".", "");
            if ((mname = mname.replaceAll(sname + ".", "")).indexOf("throws ") > 0) {
                mname = mname.substring(0, mname.indexOf("throws ") - 1);
            }
            if (mname.startsWith("void ")) continue;
            out.add(mname);
        }
        return out;
    }

    public Vector listServices() {
        Vector out = new Vector();
        if (this.services != null) {
            out.addAll(this.services.keySet());
        }
        return out;
    }

    public Hashtable getServices() {
        Hashtable<String, String> out = new Hashtable<String, String>();
        Enumeration e = this.services.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object obj = this.services.get(key);
            if (obj instanceof AuthenticatedInvoker) {
                obj = ((AuthenticatedInvoker)obj).getTarget();
            }
            out.put(key, obj.getClass().getName());
        }
        return out;
    }

    public boolean hasService(String service) {
        return this.services.get(service) != null;
    }

    public boolean addUserNamePassword(String user, String pass, int level) {
        System.err.println("USERNAME = " + user + "; PASSWORD = " + pass + "; LEVEL = " + level);
        if (this.users == null) {
            this.users = new Hashtable();
        }
        this.users.put(user, pass);
        if (level > 0) {
            if (this.levels == null) {
                this.levels = new Hashtable();
            }
            this.levels.put(user, new Integer(level));
        }
        return true;
    }

    public void addUserNamePassword(String uname, String passwd) {
        this.addUserNamePassword(uname, passwd, -1);
    }

    public int getUserLevel(String uname) {
        return this.levels.containsKey(uname) ? (Integer)this.levels.get(uname) : -1;
    }

    public boolean addService(String service, String className) throws Exception {
        Object obj = this.services.get(service);
        if (obj == null) {
            return this.addService(service, Class.forName(className).newInstance());
        }
        return false;
    }

    public boolean addService(String service, String className, String handlerArg1) throws Exception {
        return this.addService(service, className, new String[]{handlerArg1});
    }

    public boolean addService(String service, String className, String handlerArg1, String handlerArg2) throws Exception {
        return this.addService(service, className, new String[]{handlerArg1, handlerArg2});
    }

    public boolean addService(String service, String className, String handlerArg1, String handlerArg2, String handlerArg3) throws Exception {
        return this.addService(service, className, new String[]{handlerArg1, handlerArg2, handlerArg3});
    }

    public boolean addService(String service, String className, Object[] handlerArgs) throws Exception {
        Object obj = this.services.get(service);
        if (obj == null) {
            try {
                Class<?> c = Class.forName(className);
                Class[] types = new Class[handlerArgs.length];
                for (int i = 0; i < types.length; ++i) {
                    types[i] = handlerArgs[i].getClass();
                }
                Constructor<?> constr = c.getDeclaredConstructor(types);
                if (constr != null) {
                    Object handler = constr.newInstance(handlerArgs);
                    return this.addService(service, handler);
                }
                System.err.println("ERROR: REQUESTED CONSTRUCTOR NOT FOUND IN CLASS " + className);
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean addMultiCallService() throws Exception {
        boolean out = false;
        Object obj = this.services.get("system");
        if (obj == null) {
            SystemHandler system = new SystemHandler();
            system.addDefaultSystemHandlers();
            this.addService("system", system);
            return true;
        }
        return false;
    }

    public boolean addService(String service, String className, Vector handlerArgs) throws Exception {
        return this.addService(service, className, handlerArgs.toArray(new String[0]));
    }

    public boolean addService(String service, Object handler) throws Exception {
        Object obj = this.services.get(service);
        if (obj == null) {
            String className = handler.getClass().getName();
            System.out.print("Registering a " + className + " as a handler (service \"" + service + "\")...");
            if (this.users == null) {
                this.webserver.addHandler(service, handler);
                this.services.put(service, handler);
            } else {
                AuthenticatedInvoker ai = new AuthenticatedInvoker(handler);
                Iterator it = this.users.keySet().iterator();
                while (it.hasNext()) {
                    String user = (String)it.next();
                    int level = this.levels.containsKey(user) ? (Integer)this.levels.get(user) : -1;
                    ai.addUserNamePassword(user, (String)this.users.get(user), level);
                }
                this.webserver.addHandler(service, ai);
                this.services.put(service, ai);
            }
            System.out.println("...success!");
            return true;
        }
        return false;
    }

    public boolean removeService(String service) {
        Object obj = this.services.get(service);
        if (obj != null) {
            System.out.println("Removing service \"" + service + "\".");
            this.services.remove(service);
            this.webserver.removeHandler(service);
            return true;
        }
        return false;
    }

    public boolean shutdown() {
        System.out.println("Shutting down XML-RPC server.");
        this.webserver.shutdown();
        return true;
    }

    public boolean setDebug(String deb) {
        return this.debug(Boolean.valueOf(deb));
    }

    public boolean setDebug(boolean deb) {
        return this.debug(deb);
    }

    public boolean debug(boolean deb) {
        XmlRpc.setDebug(deb);
        return deb;
    }

    public boolean status() {
        return true;
    }

    public boolean exit() {
        this.webserver.shutdown();
        return true;
    }
}

