/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.xmlrpc;

import csplugins.isb.dreiss.httpdata.xmlrpc.XmlRpcUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public abstract class DataClient {
    public String SERVICE_NAME = "unknown";
    Vector args = new Vector();
    XmlRpcClient client;
    int nCallsPerBatch = 0;
    Vector batchVector = null;
    boolean startedSystemHandler = false;

    public DataClient(String url) throws XmlRpcException, MalformedURLException {
        this.client = new XmlRpcClient(url);
    }

    public synchronized Object execute(String method, Vector params) throws XmlRpcException, IOException {
        Object out = null;
        out = this.nCallsPerBatch > 0 ? this.doMultiCall(method, params) : this.client.execute(method, params);
        return out;
    }

    public synchronized void setMultiCall(int ncalls) throws XmlRpcException, IOException {
        this.nCallsPerBatch = ncalls;
        if (this.batchVector == null) {
            this.batchVector = new Vector();
        } else {
            this.batchVector.clear();
        }
        if (!this.startedSystemHandler) {
            this.startedSystemHandler = true;
            this.client.execute("server.addMultiCallService", this.batchVector);
        }
    }

    public synchronized Vector endMultiCall() throws XmlRpcException, IOException {
        Vector out = null;
        out = this.batchVector.size() > 0 ? (Vector)this.client.execute("system.multicall", this.batchVector) : this.batchVector;
        this.batchVector.clear();
        this.nCallsPerBatch = 0;
        return out;
    }

    public synchronized Vector doMultiCall(String method, Vector params) throws XmlRpcException, IOException {
        Hashtable<String, Object> tab = new Hashtable<String, Object>();
        tab.put("methodName", method);
        tab.put("params", params.clone());
        this.batchVector.add(tab);
        if (this.nCallsPerBatch > 0 && this.batchVector.size() > 0 && this.batchVector.size() % this.nCallsPerBatch == 0) {
            Vector out = (Vector)this.client.execute("system.multicall", this.batchVector);
            this.batchVector.clear();
            return out;
        }
        return null;
    }

    public synchronized Object call(String method) throws XmlRpcException, IOException {
        this.args.clear();
        return this.execute(method, this.args);
    }

    public synchronized Object call(String method, Object arg0) throws XmlRpcException, IOException {
        this.args.clear();
        this.args.add(arg0);
        return this.execute(method, this.args);
    }

    public synchronized Object call(String method, Object arg0, Object arg1) throws XmlRpcException, IOException {
        this.args.clear();
        this.args.add(arg0);
        this.args.add(arg1);
        return this.execute(method, this.args);
    }

    public synchronized Object call(String method, Object arg0, Object arg1, Object arg2) throws XmlRpcException, IOException {
        this.args.clear();
        this.args.add(arg0);
        this.args.add(arg1);
        this.args.add(arg2);
        return this.execute(method, this.args);
    }

    public synchronized Object call(String method, Object arg0, Object arg1, Object arg2, Object arg3) throws XmlRpcException, IOException {
        this.args.clear();
        this.args.add(arg0);
        this.args.add(arg1);
        this.args.add(arg2);
        this.args.add(arg3);
        return this.execute(method, this.args);
    }

    public synchronized Object call(String method, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) throws XmlRpcException, IOException {
        this.args.clear();
        this.args.add(arg0);
        this.args.add(arg1);
        this.args.add(arg2);
        this.args.add(arg3);
        this.args.add(arg4);
        return this.execute(method, this.args);
    }

    public synchronized Object call(String method, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws XmlRpcException, IOException {
        this.args.clear();
        this.args.add(arg0);
        this.args.add(arg1);
        this.args.add(arg2);
        this.args.add(arg3);
        this.args.add(arg4);
        this.args.add(arg5);
        return this.execute(method, this.args);
    }

    public synchronized Object call(String method, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws XmlRpcException, IOException {
        this.args.clear();
        this.args.add(arg0);
        this.args.add(arg1);
        this.args.add(arg2);
        this.args.add(arg3);
        this.args.add(arg4);
        this.args.add(arg5);
        this.args.add(arg6);
        return this.execute(method, this.args);
    }

    public Object query(String arg0) throws XmlRpcException, IOException {
        Object out = this.call(this.SERVICE_NAME + ".query", arg0);
        return XmlRpcUtils.GetObjectFromStruct((Hashtable)out);
    }

    public boolean setDebug(String arg0) throws XmlRpcException, IOException {
        Object out = this.call(this.SERVICE_NAME + ".setDebug");
        return (Boolean)out;
    }

    public XmlRpcClient getClient() {
        return this.client;
    }

    public abstract void test() throws Exception;
}

