/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.client;

import csplugins.isb.dreiss.httpdata.client.SetUsernamePassword;
import csplugins.isb.dreiss.httpdata.xmlrpc.AuthenticatedDataClient;
import csplugins.isb.dreiss.httpdata.xmlrpc.DataClient;
import csplugins.isb.dreiss.httpdata.xmlrpc.XmlRpcUtils;
import csplugins.isb.dreiss.util.MyUtils;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Vector;

public class DataClientFactory {
    public static String DEFAULT_HOST;
    public static String STATIC_HOST;
    public static String USERNAME;
    public static String PASSWORD;
    public static Vector dataClients;

    public static DataClient getClient(String service) throws Exception {
        Properties props = MyUtils.readProperties("csplugins/isb/dreiss/httpdata.properties");
        if (USERNAME == null) {
            String auth = "true";
            try {
                auth = (String)props.get("fetchers.auth");
            }
            catch (Exception ee) {
                auth = "false";
            }
            if ("true".equals(auth)) {
                DataClientFactory.askForUserNamePassword();
            } else {
                PASSWORD = "";
                USERNAME = "";
            }
        }
        return DataClientFactory.getClient(service, props);
    }

    public static void setUserNamePassword(String user, String pass) {
        USERNAME = user;
        PASSWORD = pass;
        for (int i = 0; i < dataClients.size(); ++i) {
            DataClient dc = (DataClient)dataClients.get(i);
            if (!(dc instanceof AuthenticatedDataClient) || "".equals(PASSWORD)) continue;
            ((AuthenticatedDataClient)dc).setUserNamePassword(USERNAME, PASSWORD);
        }
    }

    public static void askForUserNamePassword() {
        SetUsernamePassword sunp = new SetUsernamePassword(null);
        sunp.setUsernameAndPassword(null);
    }

    public static synchronized DataClient getClient(String service, Properties props) throws Exception {
        String host = STATIC_HOST;
        if (host == null || host.length() == 0) {
            host = DEFAULT_HOST;
        }
        System.err.println("HOST = " + host);
        String cName = props.getProperty("fetchers." + service);
        if (cName == null || cName.length() <= 0) {
            throw new IllegalArgumentException("DataClientFactory could not find class for service " + service);
        }
        if (host.toLowerCase().startsWith("http://")) {
            Class<?> cls = Class.forName(cName);
            Constructor<?> constr = cls.getDeclaredConstructor(String.class);
            DataClient dc = (DataClient)constr.newInstance(host);
            if (dc instanceof AuthenticatedDataClient && !"".equals(PASSWORD)) {
                ((AuthenticatedDataClient)dc).setUserNamePassword(USERNAME, PASSWORD);
            }
            dataClients.add(dc);
            return dc;
        }
        if (host.toLowerCase().startsWith("local")) {
            int localPort = 8081;
            XmlRpcUtils.startWebServerIfNeeded(localPort);
            Thread.sleep(1000L);
            String localhost = "http://localhost:" + localPort;
            boolean running = XmlRpcUtils.isServiceRunning(service, localhost);
            boolean okay = false;
            if (!running) {
                if (service.equalsIgnoreCase("blast")) {
                    String blastExe = "/local/dreiss/packages/biostuff/blast-2.2.6/blastall";
                    String sequenceDataDir = "/data/seqdb/blastformat/";
                    String useSGDblast = "false";
                    if (props != null) {
                        blastExe = props.getProperty("fetchers.blast.pathToExe", blastExe);
                        sequenceDataDir = props.getProperty("fetchers.blast.dataDir", sequenceDataDir);
                        useSGDblast = props.getProperty("fetchers.blast.useSGDBlast", useSGDblast);
                    }
                    if ("false".equals(useSGDblast)) {
                        XmlRpcUtils.startService("blast", localhost, cName, new String[]{blastExe, sequenceDataDir});
                    } else {
                        XmlRpcUtils.startService("blast", localhost, cName, null);
                    }
                    okay = true;
                    Thread.sleep(1000L);
                } else {
                    XmlRpcUtils.startService(service, localhost, cName, new String[]{service + "s"});
                    okay = true;
                }
            }
            if (okay) {
                Class<?> cls = Class.forName(cName);
                Constructor<?> constr = cls.getDeclaredConstructor(String.class);
                DataClient dc = (DataClient)constr.newInstance(localhost);
                if (dc instanceof AuthenticatedDataClient && !"".equals(PASSWORD)) {
                    ((AuthenticatedDataClient)dc).setUserNamePassword(USERNAME, PASSWORD);
                }
                dataClients.add(dc);
                return dc;
            }
        } else {
            throw new IllegalArgumentException("DataClientFactory could not parse uri '" + host + "'");
        }
        return null;
    }

    static {
        USERNAME = null;
        PASSWORD = null;
        dataClients = new Vector();
        Properties properties = MyUtils.readProperties("csplugins/isb/dreiss/httpdata.properties");
        try {
            DEFAULT_HOST = (String)properties.get("fetchers.host");
        }
        catch (Exception ee) {
            ee.printStackTrace();
            DEFAULT_HOST = "local";
        }
        STATIC_HOST = DEFAULT_HOST;
    }
}

