/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.getInteractions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;

public class PreBind {
    String np;
    String[] possiblePartners;
    private static final String urlHead = "http://deep.mshri.on.ca/cgi-bin/prebind/prebind_cgi?";
    String rawText;
    String species;
    String url = "http://deep.mshri.on.ca/cgi-bin/prebind/prebind_cgi?";
    HashMap nps = new HashMap();

    public PreBind(String np, String species) throws Exception {
        this.np = np;
        this.species = species;
        this.url = PreBind.constructURL(np, species);
        this.rawText = this.getPartialPage(this.url);
        this.extractNPs();
    }

    public String getNP() {
        return this.np;
    }

    public HashMap getNPs() {
        return this.nps;
    }

    public String getURL() {
        return this.url;
    }

    public String getRawText() {
        return this.rawText;
    }

    private String getPartialPage(String urlString) throws Exception {
        return this.getPartialPage(new URL(urlString));
    }

    public static String constructURL(String name, String species) throws Exception {
        String url = urlHead;
        String taxId = "9606";
        if ("Homo sapiens".equalsIgnoreCase(species) || "Human".equalsIgnoreCase(species)) {
            taxId = "9606";
        } else if ("Saccharomyces cerevisiae".equalsIgnoreCase(species) || "yeast".equalsIgnoreCase(species)) {
            taxId = "4932";
        } else if ("Mus musculus".equalsIgnoreCase(species) || "Mouse".equalsIgnoreCase(species)) {
            taxId = "10090";
        } else {
            throw new Exception("Error: species " + species + " is currently not supported by PreBIND");
        }
        url = !name.startsWith("NP_") && !name.startsWith("XP_") ? url + "name=" + name + "&search_type=nametax&sloi=1&=fnip=1&taxid=" + taxId + "" : url + "accession=" + name + "&search_type=accession&sloi=1&=fnip=1";
        return url;
    }

    public String getPartialPage(URL url) throws Exception {
        boolean characterCount = false;
        StringBuffer result = new StringBuffer();
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        int responseCode = urlConnection.getResponseCode();
        String contentType = urlConnection.getContentType();
        int contentLength = urlConnection.getContentLength();
        String contentEncoding = urlConnection.getContentEncoding();
        if (responseCode != 200) {
            throw new IOException("\nHTTP response code: " + responseCode + "; URL=" + url.toString());
        }
        BufferedReader theHTML = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        boolean done = false;
        while (!done) {
            String thisLine = theHTML.readLine();
            if (thisLine == null) {
                done = true;
                break;
            }
            int location = thisLine.indexOf("Potential interactors and evidence");
            if (location >= 0) {
                done = true;
                break;
            }
            result.append(thisLine);
            result.append(" ");
        }
        return result.toString();
    }

    private void extractNPs() {
        String signature = "prebind/prebind_cgi?accession=NP_";
        boolean done = false;
        int base = 0;
        int tempInd = this.rawText.indexOf("Clicking on this number will take you to a more detailed view of these co-occurences");
        if (tempInd > 0) {
            this.rawText = this.rawText.substring(tempInd);
            tempInd = this.rawText.indexOf("<strong>name</strong>");
            if (tempInd > 0) {
                this.rawText = this.rawText.substring(tempInd + 21);
            }
        }
        int count = 0;
        while (!done) {
            int cnameEnd;
            int start = this.rawText.indexOf(signature, base);
            if (start < 0) {
                done = true;
                continue;
            }
            String endSignature = "&search";
            int end = this.rawText.indexOf(endSignature, start += signature.length() - 3);
            if (end < 0) {
                done = true;
                continue;
            }
            String preamble = this.rawText.substring(base, end);
            int probably = preamble.indexOf("Probably");
            int unknown = preamble.indexOf("Unknown");
            int yes = preamble.indexOf("Yes");
            int no = preamble.indexOf("No");
            String np = this.rawText.substring(start, end);
            String cnamePrefix = "<td width=\"5%\" height=\"20\">\n<strong>";
            int cnameStart = preamble.indexOf(cnamePrefix) + cnamePrefix.length();
            String cname = preamble.substring(cnameStart = preamble.indexOf("<strong>", cnameStart) + "<strong>".length(), cnameEnd = preamble.indexOf("</strong>", cnameStart));
            if (cname.length() > 10) {
                cname = "";
            }
            Vector<Object> neighborMetaData = new Vector<Object>();
            neighborMetaData.add(new Integer(++count));
            String assessmentString = "Unknown";
            if (probably >= 0) {
                assessmentString = "Probably";
            } else if (yes >= 0) {
                assessmentString = "Yes";
            } else if (no >= 0) {
                assessmentString = "No";
            }
            if (assessmentString.equals("Unknown")) {
                assessmentString = "Possibly";
            }
            neighborMetaData.add(assessmentString);
            neighborMetaData.add(cname);
            if (!this.nps.containsValue(np)) {
                this.nps.put(np, neighborMetaData);
            }
            base = end;
        }
    }
}

