/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.getInteractions;

import csplugins.isb.dreiss.getInteractions.GetInteractions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class InteractionsDialog
extends JDialog {
    protected GetInteractions getInteractions;
    protected boolean valid = false;
    protected Map arguments;
    protected Vector sourcecbs = new Vector();
    protected Vector homologcbs = new Vector();

    public InteractionsDialog(GetInteractions gi, Map args, Map sources, Map homologs) {
        this.getInteractions = gi;
        this.arguments = args;
        this.setTitle("Fetch Interactions");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = this.createGui(sources, homologs);
        if (panel == null) {
            this.valid = false;
            return;
        }
        this.valid = true;
        this.getContentPane().add((Component)panel, "Center");
        JPanel buttonPanel = new JPanel();
        JButton dismissButton = new JButton("Dismiss");
        buttonPanel.add(dismissButton);
        dismissButton.addActionListener(new DismissAction());
        JButton goButton = new JButton("GO");
        buttonPanel.add(goButton);
        goButton.addActionListener(new GoAction());
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public boolean isValid() {
        return this.valid;
    }

    JPanel createGui(Map sources, Map homologs) {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        JPanel chooserPanel = new JPanel();
        chooserPanel.setBorder(BorderFactory.createTitledBorder("Choose the interaction data sources to include:"));
        chooserPanel.setLayout(new GridLayout(5, 2));
        if (sources != null && sources.size() > 0) {
            Iterator it = sources.keySet().iterator();
            while (it.hasNext()) {
                String source = (String)it.next();
                JCheckBox cb = new JCheckBox((String)sources.get(source), false);
                cb.addItemListener(new CBAction(source, false));
                chooserPanel.add(cb);
                this.sourcecbs.add(cb);
            }
            JButton jb = new JButton("Select All");
            jb.addActionListener(new SelectAllAction(this.sourcecbs));
            chooserPanel.add(jb);
        } else {
            chooserPanel.add(new JLabel("None available!"));
        }
        contentPanel.add((Component)chooserPanel, "North");
        JPanel configPanel = new JPanel();
        configPanel.setBorder(BorderFactory.createTitledBorder("General Options:"));
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridLayout(3, 1));
        radioPanel.setBorder(BorderFactory.createEtchedBorder());
        ButtonGroup bg = new ButtonGroup();
        JRadioButton rb = new JRadioButton("Add internal edges only", false);
        radioPanel.add(rb);
        rb.addItemListener(new CBAction("internalOnly", false));
        bg.add(rb);
        rb = new JRadioButton("Add edges only between selected nodes", false);
        radioPanel.add(rb);
        rb.addItemListener(new CBAction("onlyBetweenSelected", false));
        bg.add(rb);
        rb = new JRadioButton("Add new connected nodes", true);
        radioPanel.add(rb);
        rb.addItemListener(new CBAction("addNewNodes", true));
        bg.add(rb);
        configPanel.add((Component)radioPanel, "North");
        JPanel cbPanel = new JPanel();
        cbPanel.setLayout(new GridLayout(4, 1));
        JCheckBox cb = new JCheckBox("Add ortholog-inferred interactions", false);
        cbPanel.add(cb);
        cb.addItemListener(new CBAction("useHomologs", false));
        if (!this.getInteractions.getHandler().graphHasNodeAttribute("homolog")) {
            cb.setEnabled(false);
        }
        cb = new JCheckBox("Use the synonyms of each node", true);
        cbPanel.add(cb);
        cb.addItemListener(new CBAction("useSynonyms", true));
        if (!this.getInteractions.getHandler().graphHasNodeAttribute("synonym")) {
            cb.setSelected(false);
            cb.setEnabled(false);
        }
        cb = new JCheckBox("Re-layout the network when done", true);
        cbPanel.add(cb);
        cb.addItemListener(new CBAction("relayout", true));
        cb = new JCheckBox("Hilight newly-added edges/nodes", true);
        cbPanel.add(cb);
        cb.addItemListener(new CBAction("selectNew", true));
        configPanel.add((Component)cbPanel, "Center");
        contentPanel.add((Component)configPanel, "Center");
        if (homologs != null && homologs.size() > 0) {
            boolean hasHomologs = this.getInteractions.getHandler().graphHasNodeAttribute("homolog");
            JPanel homologPanel = new JPanel();
            homologPanel.setBorder(BorderFactory.createTitledBorder("Use orthologs with these species:"));
            homologPanel.setLayout(new GridLayout(5, 2));
            Iterator it = homologs.keySet().iterator();
            while (it.hasNext()) {
                String shortName = (String)it.next();
                String longName = (String)homologs.get(shortName);
                cb = new JCheckBox(shortName, false);
                cb.addItemListener(new CBAction("HOMOLOG " + longName, false));
                cb.setToolTipText(longName);
                cb.setEnabled(hasHomologs);
                homologPanel.add(cb);
                this.homologcbs.add(cb);
            }
            JButton jb = new JButton("Select All");
            jb.addActionListener(new SelectAllAction(this.homologcbs));
            jb.setEnabled(hasHomologs);
            homologPanel.add(jb);
            contentPanel.add((Component)homologPanel, "South");
            if (!hasHomologs) {
                homologPanel.setEnabled(false);
            }
        }
        return contentPanel;
    }

    class SelectAllAction
    extends AbstractAction {
        protected Vector cbs;

        SelectAllAction(Vector cbs) {
            this.cbs = cbs;
        }

        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            boolean doOn = false;
            if (source.getText().equals("Select All")) {
                doOn = true;
                source.setText("Select None");
            } else if (source.getText().equals("Select None")) {
                doOn = false;
                source.setText("Select All");
            }
            for (int i = 0; i < this.cbs.size(); ++i) {
                JCheckBox cb = (JCheckBox)this.cbs.get(i);
                if (cb.isSelected() == doOn) continue;
                cb.doClick();
            }
        }
    }

    class CBAction
    implements ItemListener {
        String param;
        Map args;

        CBAction(String param, boolean val) {
            this.param = param;
            this.args = InteractionsDialog.this.arguments;
            this.args.put(param, new Boolean(val));
        }

        public void itemStateChanged(ItemEvent e) {
            this.args.remove(this.param);
            this.args.put(this.param, new Boolean(e.getStateChange() == 1));
        }
    }

    class GoAction
    extends AbstractAction {
        GoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            InteractionsDialog.this.getInteractions.findBindingPartners();
        }
    }

    class DismissAction
    extends AbstractAction {
        DismissAction() {
        }

        public void actionPerformed(ActionEvent e) {
            InteractionsDialog.this.dispose();
        }
    }
}

