/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.getInteractions;

import csplugins.isb.dreiss.cytoTalk.CytoTalkHandler;
import csplugins.isb.dreiss.getInteractions.InteractionsDialog;
import csplugins.isb.dreiss.getInteractions.PreBind;
import csplugins.isb.dreiss.httpdata.client.DataClientFactory;
import csplugins.isb.dreiss.httpdata.client.HomologClient;
import csplugins.isb.dreiss.httpdata.client.InteractionClient;
import csplugins.isb.dreiss.httpdata.client.SetHttpDataHost;
import csplugins.isb.dreiss.httpdata.client.SetUsernamePassword;
import csplugins.isb.dreiss.sequence.SynonymPlugin;
import csplugins.isb.dreiss.util.MonitoredAction;
import csplugins.isb.dreiss.util.MyUtils;
import cytoscape.CytoscapeWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GetInteractions {
    protected CytoscapeWindow cWindow;
    protected CytoTalkHandler handler;
    protected InteractionClient interactionFetcher;
    protected HomologClient homologFetcher;
    protected int addedEdges;
    protected int addedNodes;
    protected Map arguments = new HashMap();
    protected Map sources;
    protected Map homologSpecies;
    protected Map nodeLookup;
    protected Map hSpeciesLookup;
    protected Vector nodesToBeSelected = new Vector();
    protected Vector edgesToBeSelected = new Vector();
    protected boolean loadingHomologsAlready = false;
    protected boolean inHere = false;

    public GetInteractions(CytoscapeWindow cytoscapeWindow) {
        this.cWindow = cytoscapeWindow;
        this.handler = new CytoTalkHandler(this.cWindow, null);
        JMenu mainMenuEntry = new JMenu("Fetch Interactions...");
        mainMenuEntry.setToolTipText("Get additional interactions from remote databases");
        this.cWindow.getOperationsMenu().add(mainMenuEntry);
        JMenuItem item2 = new JMenuItem(new GetInteractionsAction());
        mainMenuEntry.add(item2);
        mainMenuEntry.add(new JMenuItem(new SetUsernamePassword(this.cWindow.getMainFrame())));
        mainMenuEntry.add(new JMenuItem(new SetHttpDataHost(this.cWindow.getMainFrame())));
        mainMenuEntry.add(new JMenuItem(new AboutGetInteractions()));
    }

    protected InteractionClient getInteractionFetcher() {
        try {
            this.interactionFetcher = (InteractionClient)DataClientFactory.getClient("interaction");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.interactionFetcher = null;
        }
        try {
            int level = this.interactionFetcher.getUserLevel();
            this.sources = this.interactionFetcher.getSources(level);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sources = null;
        }
        System.err.println("INTERACTION SOURCES: " + this.sources);
        return this.interactionFetcher;
    }

    protected HomologClient getHomologFetcher() {
        try {
            this.homologFetcher = (HomologClient)DataClientFactory.getClient("homolog");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.homologFetcher = null;
        }
        try {
            this.homologSpecies = this.homologFetcher.getAvailableSpecies();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.homologSpecies = null;
        }
        System.err.println("HOMOLOG SPECIES: " + this.homologSpecies);
        return this.homologFetcher;
    }

    public CytoTalkHandler getHandler() {
        return this.handler;
    }

    protected String hasAddedEdge(String node1, String node2, String source, String interactionType) {
        String name = this.handler.getConnectedEdge(node1, node2);
        if (name.length() > 0) {
            String attr;
            String string = attr = this.handler.hasEdgeAttribute(name, "getInteractionsPlugin") ? (String)this.handler.getEdgeAttribute(name, "getInteractionsPlugin").get(0) : "";
            if (attr.equals("true")) {
                String string2 = attr = this.handler.hasEdgeAttribute(name, "source") ? (String)this.handler.getEdgeAttribute(name, "source").get(0) : "";
                if (attr.equals(this.sources.get(source))) {
                    String string3 = attr = this.handler.hasEdgeAttribute(name, "interaction") ? (String)this.handler.getEdgeAttribute(name, "interaction").get(0) : "";
                    if (attr.equals(interactionType)) {
                        return name;
                    }
                }
            }
        }
        return null;
    }

    protected String hasEdge(String node1, String node2, String interactionType) {
        String name = this.handler.getConnectedEdge(node1, node2);
        if (name.length() > 0) {
            String attr;
            String string = attr = this.handler.hasEdgeAttribute(name, "interaction") ? (String)this.handler.getEdgeAttribute(name, "interaction").get(0) : "";
            if (attr.equals(interactionType)) {
                return name;
            }
        }
        return null;
    }

    protected void preloadNodeLookup(boolean useHlogs, boolean useSynonyms, boolean onlyBetweenSelected) {
        Vector nodes = this.handler.getAllNodes();
        this.nodeLookup = new HashMap();
        this.hSpeciesLookup = new HashMap();
        MonitoredAction mAction = new MonitoredAction((JPanel)this.cWindow, "", "Gathering all necessary information...", nodes.size() + 1);
        for (int i = 0; i < nodes.size(); ++i) {
            Vector syns;
            String name = (String)nodes.get(i);
            if (onlyBetweenSelected && !this.handler.isNodeSelected(name)) continue;
            if (i % 10 == 0) {
                String cname = this.handler.getNodeName(name);
                String commonName = cname.startsWith("node index:") ? name : cname;
                mAction.setProgress(i, nodes.size() + 1, "Preprocessing node: " + commonName + " (" + name + ")");
                if (mAction.done()) break;
                Thread.yield();
            }
            if (name.startsWith("NP_") || name.startsWith("XP_")) {
                this.nodeLookup.put(name, name);
            }
            if (useSynonyms && this.handler.graphHasNodeAttribute("synonym") && (syns = SynonymPlugin.getRefSeqsFromSynonyms(name, this.handler)) != null) {
                for (int j = 0; j < syns.size(); ++j) {
                    if (syns.get(j) == null) continue;
                    String syn = ((String)syns.get(j)).trim();
                    if (syn.equals("Unknown")) break;
                    if (syn.startsWith("ref=")) {
                        if ((syn = syn.substring(4)).indexOf(59) >= 0) {
                            String[] ss = syn.split("\\;");
                            for (int k = 0; k < ss.length; ++k) {
                                this.nodeLookup.put(ss[k], name);
                            }
                            continue;
                        }
                        this.nodeLookup.put(syn, name);
                        continue;
                    }
                    if (!syn.startsWith("NP_") && !syn.startsWith("XP_")) continue;
                    this.nodeLookup.put(syn, name);
                }
            }
            if (!useHlogs || !this.handler.graphHasNodeAttribute("homolog")) continue;
            String[] hlogs = this.handler.getNodeAttribute(name, "homolog").toArray(new String[0]);
            String[] specs = this.handler.getNodeAttribute(name, "homolog species").toArray(new String[0]);
            if (hlogs == null) continue;
            for (int j = 0; j < hlogs.length; ++j) {
                String hlog = hlogs[j];
                if (!hlog.startsWith("NP_") && !hlog.startsWith("XP_")) continue;
                this.nodeLookup.put(hlog, name);
                this.hSpeciesLookup.put(hlog, specs[j]);
            }
        }
        mAction.setProgress(nodes.size() + 2, nodes.size() + 1, "Done");
    }

    protected void findBindingPartners() {
        if (this.handler.countAllNodes() <= 0) {
            String msg = "The current graph is empty...";
            JOptionPane.showMessageDialog(this.cWindow.getMainFrame(), msg);
            return;
        }
        if (this.handler.countSelectedNodes() == 0) {
            String msg = "Please select one or more nodes and try again.";
            JOptionPane.showMessageDialog(this.cWindow.getMainFrame(), msg);
            return;
        }
        Vector list = this.handler.getSelectedNodes();
        Vector<String> nodeList = new Vector<String>();
        for (int i = 0; i < list.size(); ++i) {
            String canonicalName = (String)list.get(i);
            String name = this.handler.getNodeName(canonicalName);
            name = name.startsWith("node index:") ? canonicalName : name;
            nodeList.add(name);
        }
        final boolean addNewInteractors = this.getBooleanArgValue("addNewNodes");
        final String[] names = list.toArray(new String[0]);
        final String[] nodeNames = nodeList.toArray(new String[0]);
        final Vector<String> homologsToUse = new Vector<String>();
        final boolean useHlogs = this.getBooleanArgValue("useHomologs");
        if (useHlogs) {
            Iterator it = this.arguments.keySet().iterator();
            while (it.hasNext()) {
                String spec;
                boolean useit;
                String key = (String)it.next();
                if (!key.startsWith("HOMOLOG ") || !(useit = this.getBooleanArgValue(key)) || (spec = key.substring("HOMOLOG ".length())).equals("???")) continue;
                homologsToUse.add(spec);
            }
        }
        this.nodesToBeSelected.clear();
        this.edgesToBeSelected.clear();
        new Thread(){

            public void run() {
                boolean useSynonyms = GetInteractions.this.getBooleanArgValue("useSynonyms");
                boolean onlyBetweenSelected = GetInteractions.this.getBooleanArgValue("onlyBetweenSelected");
                GetInteractions.this.preloadNodeLookup(useHlogs, useSynonyms, onlyBetweenSelected);
                MonitoredAction mAction = new MonitoredAction((JPanel)GetInteractions.this.cWindow, "", "Fetching all connected interact" + (addNewInteractors ? "ors" : "ions") + " from remote databases...", names.length + 1);
                GetInteractions.this.addedNodes = 0;
                GetInteractions.this.addedEdges = 0;
                for (int i = 0; i < names.length; ++i) {
                    try {
                        String species = GetInteractions.this.handler.getNodeSpecies(names[i]);
                        if (species == null || "".equals(species)) continue;
                        mAction.setProgress(i + 1, names.length + 1, nodeNames[i] + " (" + names[i] + ") [" + species + "]");
                        if (mAction.done()) break;
                        Thread.yield();
                        GetInteractions.this.createEdgesForOneNode(names[i], addNewInteractors, homologsToUse);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (GetInteractions.this.addedEdges + GetInteractions.this.addedNodes > 0) {
                    boolean doLayout;
                    mAction.setProgress(names.length, names.length + 1, "Added " + GetInteractions.this.addedEdges + " edges and " + GetInteractions.this.addedNodes + " nodes. Laying out the network...");
                    boolean selectNew = GetInteractions.this.getBooleanArgValue("selectNew");
                    if (selectNew) {
                        if (GetInteractions.this.nodesToBeSelected.size() > 0) {
                            GetInteractions.this.handler.clearSelection();
                            GetInteractions.this.handler.selectNodes(GetInteractions.this.nodesToBeSelected);
                        }
                        if (GetInteractions.this.edgesToBeSelected.size() > 0) {
                            GetInteractions.this.handler.selectEdges(GetInteractions.this.edgesToBeSelected);
                        }
                    }
                    if (doLayout = GetInteractions.this.getBooleanArgValue("relayout")) {
                        GetInteractions.this.handler.doLayout();
                    }
                    GetInteractions.this.handler.redrawGraph();
                }
                mAction.setProgress(names.length + 2, names.length + 1, "Done");
                GetInteractions.this.hSpeciesLookup = null;
                GetInteractions.this.nodeLookup = null;
            }
        }.start();
    }

    protected void createEdgesForOneNode(String nodeCanonicalName, boolean addNewInteractors, Vector homologsToUse) throws Exception {
        int i;
        String species = this.handler.getNodeSpecies(nodeCanonicalName);
        if (species == null || "".equals(species)) {
            return;
        }
        HashMap neighborHash = this.getNeighborsFromDB(nodeCanonicalName, species);
        boolean internalOnly = this.getBooleanArgValue("internalOnly");
        boolean onlyBetweenSelected = this.getBooleanArgValue("onlyBetweenSelected");
        if (!this.loadingHomologsAlready && homologsToUse != null && homologsToUse.size() > 0) {
            this.loadingHomologsAlready = true;
            HashMap hlogsHash = this.getNodeHomologsForSpecies(nodeCanonicalName);
            if (hlogsHash.size() > 0) {
                for (i = 0; i < homologsToUse.size(); ++i) {
                    String spec = (String)homologsToUse.get(i);
                    Vector hlogs = (Vector)hlogsHash.get(spec);
                    if (hlogs == null || hlogs.size() <= 0) continue;
                    for (int j = 0; j < hlogs.size(); ++j) {
                        String hlog = (String)hlogs.get(j);
                        HashMap hlogNeighbors = this.getNeighborsFromDB(hlog, spec);
                        if (hlogNeighbors.size() <= 0) continue;
                        MyUtils.JoinMaps(neighborHash, hlogNeighbors);
                        Iterator it = hlogNeighbors.keySet().iterator();
                        while (it.hasNext()) {
                            Map m = (Map)hlogNeighbors.get(it.next());
                            m.put("homologInferred", "true");
                            m.put("homologSpecies", spec);
                        }
                    }
                }
            }
            this.loadingHomologsAlready = false;
        }
        if (neighborHash == null || neighborHash.size() <= 0) {
            return;
        }
        String[] neighborNames = neighborHash.keySet().toArray(new String[0]);
        for (i = 0; i < neighborNames.length; ++i) {
            Map neighborData;
            String source;
            String neighbor = neighborNames[i];
            if (neighbor == null || "None".equalsIgnoreCase(neighbor) || "null".equalsIgnoreCase(neighbor)) continue;
            String partner = neighbor;
            if (!this.handler.doesNodeExist(partner)) {
                partner = null;
            }
            if (partner != null && onlyBetweenSelected && !this.handler.isNodeSelected(partner)) {
                partner = null;
            }
            if (partner == null && (partner = (String)this.nodeLookup.get(neighbor)) != null && onlyBetweenSelected && !this.handler.isNodeSelected(partner)) {
                partner = null;
            }
            if ("hprd".equals(source = (String)(neighborData = (Map)neighborHash.get(neighbor)).get("source")) && neighbor.equals(nodeCanonicalName)) continue;
            String info = (String)neighborData.get("info");
            String interactionType = (String)neighborData.get("type");
            String pvalue = "" + neighborData.get("pval");
            String homologInferred = (String)neighborData.get("homologInferred");
            if (homologInferred == null) {
                homologInferred = "false";
            }
            String spec = species;
            if ("true".equals(homologInferred)) {
                spec = (String)neighborData.get("homologSpecies");
            }
            if (partner == null && (partner = this.findHomologNode(neighbor, spec)) != null && onlyBetweenSelected && !this.handler.isNodeSelected(partner)) {
                partner = null;
            }
            boolean newNode = false;
            if (partner == null && addNewInteractors) {
                this.createNewPartnerNode(spec, neighbor, source);
                ++this.addedNodes;
                partner = neighbor;
                newNode = true;
                if (newNode) {
                    this.nodesToBeSelected.add(neighbor);
                    Map urls = this.getNeighborNodeURLs(source, neighbor, spec, info);
                    Iterator it = urls.keySet().iterator();
                    while (it.hasNext()) {
                        String urlName = (String)it.next();
                        String url = (String)urls.get(urlName);
                        this.handler.addNodeAttribute(neighbor, urlName, url);
                    }
                }
                this.handler.setNodeAttribute(neighbor, "homologInferred", homologInferred);
            }
            if (partner != null) {
                String inferredEdge = this.hasEdge(nodeCanonicalName, partner, interactionType);
                boolean isNewEdge = false;
                if (inferredEdge == null) {
                    inferredEdge = this.handler.createEdge(nodeCanonicalName, interactionType, partner);
                    ++this.addedEdges;
                    isNewEdge = true;
                    this.edgesToBeSelected.add(inferredEdge);
                }
                String edgeName = inferredEdge;
                if (isNewEdge) {
                    this.handler.setEdgeAttribute(edgeName, "getInteractionsPlugin", "true");
                    this.handler.setEdgeAttribute(edgeName, "homologInferred", homologInferred);
                    if ("true".equals(homologInferred)) {
                        this.handler.setEdgeAttribute(edgeName, "homologSpecies", (String)neighborData.get("homologSpecies"));
                    }
                    if (!"".equals(source) && !"None".equals(source)) {
                        this.handler.addEdgeAttribute(edgeName, "source", source);
                    }
                    if (!"".equals(pvalue) && !"None".equals(pvalue)) {
                        this.handler.addEdgeAttribute(edgeName, "pvalue", pvalue);
                    }
                    if (!"".equals(info) && !"None".equals(info)) {
                        this.handler.addEdgeAttribute(edgeName, "info", info);
                    }
                    Map urls = this.getInteractionURLs(source, nodeCanonicalName, species, info);
                    Iterator it = urls.keySet().iterator();
                    while (it.hasNext()) {
                        String urlName = (String)it.next();
                        String url = (String)urls.get(urlName);
                        this.handler.addEdgeAttribute(edgeName, urlName, url);
                    }
                    if (info.indexOf(124) >= 0) {
                        String[] toks = info.split("\\|");
                        for (int j = 0; j < toks.length; ++j) {
                            String ttok;
                            String[] ttoks;
                            if (toks[j].indexOf(61) <= 0 || (ttoks = toks[j].split("\\=")).length <= 1) continue;
                            if (newNode && ttoks[0].endsWith("2")) {
                                ttok = ttoks[0].substring(0, ttoks[0].length() - 1);
                                this.handler.setNodeAttribute(neighbor, ttok, ttoks[1]);
                                continue;
                            }
                            if (newNode && ttoks[0].endsWith("1")) {
                                ttok = ttoks[0].substring(0, ttoks[0].length() - 1);
                                if (this.handler.hasNodeAttribute(nodeCanonicalName, ttok)) continue;
                                this.handler.setNodeAttribute(nodeCanonicalName, ttok, ttoks[1]);
                                continue;
                            }
                            if (ttoks[0].endsWith("1") || ttoks[0].endsWith("2") || this.handler.hasEdgeAttribute(edgeName, ttoks[0])) continue;
                            if (!"canonicalName".equalsIgnoreCase(ttoks[0]) && !"commonName".equalsIgnoreCase(ttoks[0])) {
                                this.handler.setEdgeAttribute(edgeName, ttoks[0], ttoks[1]);
                            }
                            if (!newNode || !"commonName".equalsIgnoreCase(ttoks[0])) continue;
                            this.handler.setNodeAttribute(neighbor, "commonName", ttoks[1]);
                        }
                    }
                }
            }
            if (!newNode || this.handler.hasNodeAttribute(neighbor, "commonName")) continue;
            this.handler.setNodeAttribute(neighbor, "commonName", neighbor);
        }
    }

    protected HashMap getNodeHomologsForSpecies(String nodeCanonicalName) {
        String[] hlogs = this.handler.getNodeAttribute(nodeCanonicalName, "homolog").toArray(new String[0]);
        String[] specs = this.handler.getNodeAttribute(nodeCanonicalName, "homolog species").toArray(new String[0]);
        HashMap<String, Vector<String>> out = new HashMap<String, Vector<String>>();
        for (int i = 0; i < hlogs.length; ++i) {
            String spec = specs[i].trim();
            Vector<String> v = (Vector<String>)out.get(spec);
            if (v == null) {
                v = new Vector<String>();
                out.put(spec, v);
            }
            v.add(hlogs[i].trim());
        }
        return out;
    }

    protected String createNewPartnerNode(String species, String partnerName, String source) {
        this.handler.createNode(partnerName);
        if (partnerName.startsWith("NP_") || partnerName.startsWith("XP_")) {
            this.nodeLookup.put(partnerName, partnerName);
        }
        this.handler.setNodeAttribute(partnerName, "source", source);
        this.handler.setNodeAttribute(partnerName, "species", species);
        this.handler.setNodeAttribute(partnerName, "getInteractionsPlugin", "true");
        return partnerName;
    }

    protected String findHomologNode(String homolog, String hspec) {
        String name = (String)this.nodeLookup.get(homolog);
        if (name == null || "".equals(name)) {
            return null;
        }
        if (!((String)this.hSpeciesLookup.get(homolog)).equals(hspec)) {
            return null;
        }
        return name;
    }

    protected Map getNeighborNodeURLs(String source, String neighborName, String species, String infoString) {
        String omid;
        HashMap<String, String> map = new HashMap<String, String>();
        if (neighborName.startsWith("NP_") || neighborName.startsWith("XP_")) {
            map.put("RefSeq URL", "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Protein&cmd=Search&doptcmdl=GenPept&term=" + neighborName);
        }
        if ("hprd".equals(source) && !"".equals(omid = this.getInfoArg("OMID2", infoString))) {
            map.put("HPRD URL", "http://hprd.org/genes/" + omid);
        }
        return map;
    }

    protected HashMap getNeighborsFromDB(String nodeCanonicalName, String species) {
        int r;
        HashMap<String, Hashtable> out = new HashMap<String, Hashtable>();
        InteractionClient fetcher = this.interactionFetcher;
        if (fetcher == null) {
            return out;
        }
        boolean useSynonyms = this.getBooleanArgValue("useSynonyms");
        String refseq = nodeCanonicalName;
        String[] refs = new String[]{refseq};
        if (refseq.indexOf(59) > 0) {
            refs = refseq.split("\\;");
        }
        if (useSynonyms) {
            Vector v = SynonymPlugin.getRefSeqsFromSynonyms(nodeCanonicalName, this.handler);
            refs = v.toArray(new String[0]);
        }
        int fromPrebind = 0;
        for (r = 0; r < refs.length; ++r) {
            refseq = refs[r];
            Vector response = null;
            Iterator it = this.sources.keySet().iterator();
            while (it.hasNext()) {
                String source = (String)it.next();
                boolean getit = this.getBooleanArgValue(source);
                if (!getit) continue;
                try {
                    response = fetcher.getAllInteractionsAndInfo(refseq, species, source, true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean okay = false;
                Vector intInfo = response;
                if (intInfo == null || intInfo.size() <= 0) continue;
                int sz = intInfo.size();
                for (int i = 0; i < sz; ++i) {
                    Hashtable map = (Hashtable)intInfo.get(i);
                    String partner = (String)map.get("partner");
                    String src = (String)map.get("source");
                    if (src.startsWith("prebind")) {
                        ++fromPrebind;
                    }
                    if (!this.arguments.containsKey(src) || !this.getBooleanArgValue(src)) continue;
                    out.put(partner, map);
                    okay = true;
                }
            }
        }
        if (!this.inHere && fromPrebind == 0 && (this.getBooleanArgValue("prebindProbably") || this.getBooleanArgValue("prebindPossibly") || this.getBooleanArgValue("prebindYes"))) {
            for (r = 0; r < refs.length; ++r) {
                refseq = refs[r];
                this.inHere = true;
                Map pout = this.getPrebindNeighbors(refseq, species);
                this.inHere = false;
                if (pout == null || pout.size() <= 0) continue;
                MyUtils.JoinMaps(out, pout);
                break;
            }
        }
        return out;
    }

    protected boolean getBooleanArgValue(String param) {
        Boolean val = (Boolean)this.arguments.get(param);
        return val != null && val != false;
    }

    public Map getInteractionURLs(String source, String nodeName, String species, String infoString) throws Exception {
        String omid;
        String url;
        HashMap<String, String> out = new HashMap<String, String>();
        if (source.startsWith("prebind")) {
            try {
                String url2 = PreBind.constructURL(nodeName, species);
                String anchor = this.getInfoArg("webAnchor", infoString);
                if (!"".equals(anchor)) {
                    url2 = url2 + "#anchor" + anchor;
                }
                out.put("PreBIND URL", url2);
            }
            catch (Exception e) {}
        } else if ("bind".equals(source)) {
            String bid = this.getInfoArg("BindID", infoString);
            url = "http://bind.ca/cgi-bin/bind/dataget?get=search&rectype=4&type=int&id=";
            if (!"".equals(bid)) {
                out.put("BIND URL", url + bid);
            }
        } else if ("hprd".equals(source) && !"".equals(omid = this.getInfoArg("OMID1", infoString))) {
            out.put("HPRD URL", "http://hprd.org/genes/" + omid + "?selectedtab=INTERACTIONS");
        }
        if (infoString.indexOf("PubMedID=") >= 0) {
            String pmid = this.getInfoArg("PubMedID", infoString);
            url = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&dopt=Abstract&list_uids=";
            if (!"".equals(pmid)) {
                out.put("PubMed URL", url + pmid);
            }
        }
        String[] toks = infoString.split("\\|");
        for (int j = 0; j < toks.length; ++j) {
            if (toks[j].indexOf("URL") < 0) continue;
            out.put(toks[j], toks[j].substring(toks[j].indexOf(61)));
        }
        return out;
    }

    protected String getInfoArg(String param, String infoString) {
        String[] toks = infoString.split("\\|");
        for (int j = 0; j < toks.length; ++j) {
            if (!toks[j].startsWith(param + "=")) continue;
            return toks[j].substring((param + "=").length());
        }
        return "";
    }

    protected Map getPrebindNeighbors(String refseq, String species) {
        String ref = refseq.indexOf(59) >= 0 ? refseq.substring(0, refseq.indexOf(59) - 1) : refseq;
        HashMap pout = new HashMap();
        try {
            PreBind finder = new PreBind(ref, species);
            pout = finder.getNPs();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pout.size() <= 0) {
            Vector<Object> v = new Vector<Object>();
            v.add(new Integer(-1));
            v.add("None");
            v.add("None");
            pout.put("None", v);
        }
        try {
            this.savePrebindNeighborsToDB(refseq, species, pout);
            pout = this.getNeighborsFromDB(refseq, species);
        }
        catch (Exception e) {
            pout = null;
            System.err.println(e.toString());
        }
        return pout;
    }

    protected void savePrebindNeighborsToDB(String nodeCanonicalName, String species, Map neighborHash) {
        InteractionClient fetcher = this.interactionFetcher;
        if (fetcher == null) {
            return;
        }
        String[] neighborNames = neighborHash.keySet().toArray(new String[0]);
        int probable = 0;
        int possible = 0;
        int yes = 0;
        for (int i = 0; i < neighborNames.length; ++i) {
            String neighbor = neighborNames[i];
            Vector neighborMetadata = (Vector)neighborHash.get(neighbor);
            int webPageAnchorNumber = (Integer)neighborMetadata.get(0);
            String likelihoodEstimate = (String)neighborMetadata.get(1);
            String commonName = (String)neighborMetadata.get(2);
            String info = "webAnchor=" + webPageAnchorNumber + "|commonName2=" + commonName;
            if (likelihoodEstimate.equals("Probably")) {
                ++probable;
            } else if (likelihoodEstimate.equals("Possibly")) {
                ++possible;
            } else if (likelihoodEstimate.equals("Yes")) {
                ++yes;
            }
            try {
                fetcher.put(nodeCanonicalName, "pp", neighbor, 0.0, "prebind" + likelihoodEstimate, info, species);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (yes == 0) {
            try {
                fetcher.put(nodeCanonicalName, "pp", "None", 0.0, "prebindYes", "None", species);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (probable == 0) {
            try {
                fetcher.put(nodeCanonicalName, "pp", "None", 0.0, "prebindProbably", "None", species);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (possible == 0) {
            try {
                fetcher.put(nodeCanonicalName, "pp", "None", 0.0, "prebindPossibly", "None", species);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class AboutGetInteractions
    extends AbstractAction {
        AboutGetInteractions() {
            super("About Interactions Plugin...");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog((Component)GetInteractions.this.cWindow, new Object[]{"Interactions plugin, by David Reiss, ISB", "Questions or comments: dreiss@systemsbiology.org.", ""}, "About Interactions plugin", 1);
        }
    }

    protected class GetInteractionsAction
    extends AbstractAction {
        GetInteractionsAction() {
            super("Interactions...");
        }

        public void actionPerformed(ActionEvent e) {
            GetInteractions.this.getInteractionFetcher();
            GetInteractions.this.getHomologFetcher();
            InteractionsDialog dialog = new InteractionsDialog(GetInteractions.this, GetInteractions.this.arguments, GetInteractions.this.sources, GetInteractions.this.homologSpecies);
            if (((Component)dialog).isValid()) {
                dialog.pack();
                dialog.setLocationRelativeTo(GetInteractions.this.cWindow.getMainFrame());
                dialog.setVisible(true);
            } else {
                dialog.dispose();
            }
        }
    }
}

