/*
 * Decompiled with CFR 0.152.
 */
package csplugins.trial.pshannon;

import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import y.module.CircularLayoutModule;
import y.module.HierarchicLayoutModule;
import y.module.OrganicLayoutModule;
import y.module.OrthogonalLayoutModule;
import y.module.RandomLayoutModule;
import y.module.TreeLayoutModule;
import y.module.YModule;
import y.option.OptionHandler;
import y.view.Arrow;
import y.view.Graph2D;

public class Y2Layouters {
    protected CytoscapeWindow cytoscapeWindow;
    protected Graph2D graph;
    protected GraphObjAttributes nodeAttributes;
    protected GraphObjAttributes edgeAttributes;
    protected OrganicLayoutModule organicLayoutModule;
    protected RandomLayoutModule randomLayoutModule;
    protected CircularLayoutModule circularLayoutModule;
    protected HierarchicLayoutModule hierarchicLayoutModule;
    protected OrthogonalLayoutModule orthogonalLayoutModule;
    protected TreeLayoutModule treeLayoutModule;

    public Y2Layouters(CytoscapeWindow cytoscapeWindow) {
        this.cytoscapeWindow = cytoscapeWindow;
        this.graph = cytoscapeWindow.getGraph();
        this.organicLayoutModule = new OrganicLayoutModule();
        this.randomLayoutModule = new RandomLayoutModule();
        this.circularLayoutModule = new CircularLayoutModule();
        this.hierarchicLayoutModule = new HierarchicLayoutModule();
        this.orthogonalLayoutModule = new OrthogonalLayoutModule();
        this.treeLayoutModule = new TreeLayoutModule();
        JMenu jMenu = this.createLayoutersMenu();
        cytoscapeWindow.getOperationsMenu().add(jMenu);
        this.graph.getDefaultEdgeRealizer().setArrow(Arrow.DELTA);
        this.nodeAttributes = cytoscapeWindow.getNodeAttributes();
        this.edgeAttributes = cytoscapeWindow.getEdgeAttributes();
    }

    protected JMenu createLayoutersMenu() {
        JMenu jMenu = new JMenu("Layouts");
        JMenu jMenu2 = new JMenu("Organic");
        JMenu jMenu3 = new JMenu("Circular");
        JMenu jMenu4 = new JMenu("Hierarchical");
        JMenu jMenu5 = new JMenu("Orthogonal");
        JMenu jMenu6 = new JMenu("tree");
        jMenu.add(jMenu2);
        jMenu.add(jMenu3);
        jMenu.add(jMenu4);
        jMenu.add(jMenu5);
        jMenu.add(jMenu6);
        jMenu.add(new LaunchModule((YModule)this.randomLayoutModule));
        OptionHandler optionHandler = this.organicLayoutModule.getOptionHandler();
        jMenu2.add(new LayoutAction((YModule)this.organicLayoutModule, true));
        jMenu2.add(new LayoutAction((YModule)this.organicLayoutModule, false));
        jMenu3.add(new LayoutAction((YModule)this.circularLayoutModule, true));
        jMenu3.add(new LayoutAction((YModule)this.circularLayoutModule, false));
        jMenu4.add(new LayoutAction((YModule)this.hierarchicLayoutModule, true));
        jMenu4.add(new LayoutAction((YModule)this.hierarchicLayoutModule, false));
        jMenu5.add(new LayoutAction((YModule)this.orthogonalLayoutModule, true));
        jMenu5.add(new LayoutAction((YModule)this.orthogonalLayoutModule, false));
        jMenu6.add(new LayoutAction((YModule)this.treeLayoutModule, true));
        jMenu6.add(new LayoutAction((YModule)this.treeLayoutModule, false));
        return jMenu;
    }

    class LaunchModule
    extends AbstractAction {
        YModule module;

        LaunchModule(YModule yModule) {
            super(yModule.getModuleName());
            this.module = yModule;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionHandler optionHandler = this.module.getOptionHandler();
            if (optionHandler != null && !optionHandler.showEditor()) {
                return;
            }
            this.module.start(Y2Layouters.this.graph);
        }
    }

    class LayoutWithCurrentSettings
    extends AbstractAction {
        String layouterName;
        YModule module;

        LayoutWithCurrentSettings(String string, YModule yModule) {
            super("with current settings");
            this.layouterName = string;
            this.module = yModule;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.module.start(Y2Layouters.this.graph);
        }
    }

    class LayoutAction
    extends AbstractAction {
        YModule module;
        boolean displayOptions;

        LayoutAction(YModule yModule, boolean bl) {
            super(bl ? "adjust options..." : "use current options");
            this.module = yModule;
            this.displayOptions = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionHandler optionHandler;
            if (this.displayOptions && (optionHandler = this.module.getOptionHandler()) != null && !optionHandler.showEditor()) {
                return;
            }
            this.module.start(Y2Layouters.this.graph);
        }
    }
}

