/*
 * Decompiled with CFR 0.152.
 */
package csplugins.hierarchicallayout.test;

import csplugins.hierarchicallayout.Edge;
import csplugins.hierarchicallayout.Graph;
import junit.framework.TestCase;

public class TestGraph
extends TestCase {
    private static final Edge edge0_1 = new Edge(0, 1);
    private static final Edge edge1_2 = new Edge(1, 2);
    private static final Edge edge2_0 = new Edge(2, 0);
    private static final Edge edge2_2 = new Edge(2, 2);
    private static final Edge edge0_7 = new Edge(0, 7);
    private static final Edge edge7_13 = new Edge(7, 13);
    private static final Edge edge13_6 = new Edge(13, 6);
    private static final Edge edge13_8 = new Edge(13, 8);
    private static final Edge edge8_1 = new Edge(8, 1);
    private static final Edge edge0_6 = new Edge(0, 6);
    private static final Edge edge1_6 = new Edge(1, 6);
    private static final Edge edge1_12 = new Edge(1, 12);
    private static final Edge edge12_5 = new Edge(12, 5);
    private static final Edge edge6_5 = new Edge(6, 5);
    private static final Edge edge5_15 = new Edge(5, 15);
    private static final Edge edge15_0 = new Edge(15, 0);
    private static final Edge edge9_9 = new Edge(9, 9);
    private static final Edge edge9_3 = new Edge(9, 3);
    private static final Edge edge3_3 = new Edge(3, 3);
    private static final Edge edge11_9 = new Edge(11, 9);
    private static final Edge edge14_11 = new Edge(14, 11);
    private static final Edge edge16_11 = new Edge(16, 11);
    private static final Edge edge3_14 = new Edge(3, 14);
    private static final Edge edge10_2 = new Edge(10, 2);
    private static final Edge edge3_16 = new Edge(3, 16);
    private static final Edge edge1_0 = new Edge(1, 0);
    private static final Edge[] graph0edges = new Edge[0];
    private static final Edge[] graph1edges = new Edge[0];
    private static final Edge[] graph2edges = new Edge[]{edge0_1, edge0_1};
    private static final Edge[] graph3edges = new Edge[]{edge0_1, edge1_2, edge2_0, edge2_2};
    private static final Edge[] graph4edges = new Edge[]{edge0_7, edge7_13, edge13_6, edge13_8, edge8_1, edge0_6, edge1_6, edge1_12, edge12_5, edge6_5, edge5_15, edge15_0, edge9_9, edge9_3, edge3_3, edge11_9, edge14_11, edge16_11, edge3_14, edge3_14, edge10_2, edge2_2, edge3_14, edge3_16};
    private static final Edge[] graph5edges = new Edge[]{edge1_0, edge1_0, edge0_1, edge1_0};
    private static final Graph graph0 = new Graph(0, graph0edges);
    private static final Graph graph1 = new Graph(1, graph1edges);
    private static final Graph graph2 = new Graph(2, graph2edges);
    private static final Graph graph3 = new Graph(3, graph3edges);
    private static final Graph graph4 = new Graph(17, graph4edges);
    private static final Graph graph5 = new Graph(2, graph5edges);

    public void testConstructor() throws Exception {
        if (graph0.getNodecount() != 0 || graph0.getEdgecount() != 0) {
            TestGraph.fail((String)"graph0 construction error");
        }
        if (graph1.getNodecount() != 1 || graph1.getEdgecount() != 0) {
            TestGraph.fail((String)"graph1 construction error");
        }
        if (graph2.getNodecount() != 2 || graph2.getEdgecount() != 2 || !graph2.hasEdge(0, 1)) {
            TestGraph.fail((String)"graph2 construction error");
        }
        if (!(graph3.getNodecount() == 3 && graph3.getEdgecount() == 4 && graph3.hasEdge(0, 1) && graph3.hasEdge(1, 2) && graph3.hasEdge(2, 0) && graph3.hasEdge(2, 2))) {
            TestGraph.fail((String)"graph3 construction error");
        }
        if (!(graph4.getNodecount() == 17 && graph4.getEdgecount() == 24 && graph4.hasEdge(0, 7) && graph4.hasEdge(0, 7) && graph4.hasEdge(7, 13) && graph4.hasEdge(13, 6) && graph4.hasEdge(13, 8) && graph4.hasEdge(8, 1) && graph4.hasEdge(0, 6) && graph4.hasEdge(1, 6) && graph4.hasEdge(1, 12) && graph4.hasEdge(12, 5) && graph4.hasEdge(6, 5) && graph4.hasEdge(5, 15) && graph4.hasEdge(15, 0) && graph4.hasEdge(9, 9) && graph4.hasEdge(9, 3) && graph4.hasEdge(3, 3) && graph4.hasEdge(11, 9) && graph4.hasEdge(14, 11) && graph4.hasEdge(16, 11) && graph4.hasEdge(3, 14) && graph4.hasEdge(10, 2) && graph4.hasEdge(2, 2) && graph4.hasEdge(3, 16))) {
            TestGraph.fail((String)"graph4 construction error");
        }
    }

    public void testComponentIndex() throws Exception {
        int[] nArray = graph0.componentIndex();
        if (nArray.length != 0) {
            TestGraph.fail((String)"graph0 component index error");
        }
        if ((nArray = graph1.componentIndex()).length != 1 || nArray[0] != 0) {
            TestGraph.fail((String)"graph1 component index error");
        }
        if ((nArray = graph2.componentIndex()).length != 2 || nArray[0] != 0 || nArray[1] != 0) {
            TestGraph.fail((String)"graph2 component index error");
        }
        if ((nArray = graph3.componentIndex()).length != 3 || nArray[0] != 0 || nArray[1] != 0 || nArray[2] != 0) {
            TestGraph.fail((String)"graph3 component index error");
        }
        if ((nArray = graph4.componentIndex()).length != 17 || nArray[0] != 0 || nArray[1] != 0 || nArray[2] != 1 || nArray[3] != 2 || nArray[4] != 3 || nArray[5] != 0 || nArray[6] != 0 || nArray[7] != 0 || nArray[8] != 0 || nArray[9] != 2 || nArray[10] != 1 || nArray[11] != 2 || nArray[12] != 0 || nArray[13] != 0 || nArray[14] != 2 || nArray[15] != 0 || nArray[16] != 2) {
            TestGraph.fail((String)"graph4 component index error");
        }
    }

    public void testPartition() throws Exception {
        int[] nArray;
        int[] nArray2 = graph0.componentIndex();
        Graph[] graphArray = graph0.partition(nArray2, nArray = new int[nArray2.length]);
        if (graphArray.length != 0) {
            TestGraph.fail((String)"graph0 partition error");
        }
        if ((graphArray = graph1.partition(nArray2 = graph1.componentIndex(), nArray = new int[nArray2.length])).length != 1 || graphArray[0].getNodecount() != 1 || graphArray[0].getEdgecount() != 0 || nArray[0] != 0) {
            TestGraph.fail((String)"graph1 partition error");
        }
        if ((graphArray = graph2.partition(nArray2 = graph2.componentIndex(), nArray = new int[nArray2.length])).length != 1 || graphArray[0].getNodecount() != 2 || graphArray[0].getEdgecount() != 2 || nArray[0] != 0 || nArray[1] != 1 || !graphArray[0].hasEdge(0, 1)) {
            TestGraph.fail((String)"graph2 partition error");
        }
        if (!((graphArray = graph3.partition(nArray2 = graph3.componentIndex(), nArray = new int[nArray2.length])).length == 1 && graphArray[0].getNodecount() == 3 && graphArray[0].getEdgecount() == 4 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2 && graphArray[0].hasEdge(0, 1) && graphArray[0].hasEdge(1, 2) && graphArray[0].hasEdge(2, 0) && graphArray[0].hasEdge(2, 2))) {
            TestGraph.fail((String)"graph3 partition error");
        }
        if (!((graphArray = graph4.partition(nArray2 = graph4.componentIndex(), nArray = new int[nArray2.length])).length == 4 && graphArray[0].getNodecount() == 9 && graphArray[0].getEdgecount() == 12 && graphArray[1].getNodecount() == 2 && graphArray[1].getEdgecount() == 2 && graphArray[2].getNodecount() == 5 && graphArray[2].getEdgecount() == 10 && graphArray[3].getNodecount() == 1 && graphArray[3].getEdgecount() == 0 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 0 && nArray[3] == 0 && nArray[4] == 0 && nArray[5] == 2 && nArray[6] == 3 && nArray[7] == 4 && nArray[8] == 5 && nArray[9] == 1 && nArray[10] == 1 && nArray[11] == 2 && nArray[12] == 6 && nArray[13] == 7 && nArray[14] == 3 && nArray[15] == 8 && nArray[16] == 4 && graphArray[0].hasEdge(4, 7) && graphArray[0].hasEdge(0, 4) && graphArray[0].hasEdge(0, 3) && graphArray[0].hasEdge(8, 0) && graphArray[0].hasEdge(2, 8) && graphArray[0].hasEdge(7, 3) && graphArray[0].hasEdge(7, 5) && graphArray[0].hasEdge(3, 2) && graphArray[0].hasEdge(1, 3) && graphArray[0].hasEdge(5, 1) && graphArray[0].hasEdge(6, 2) && graphArray[0].hasEdge(1, 6) && graphArray[2].hasEdge(2, 1) && graphArray[2].hasEdge(0, 3) && graphArray[2].hasEdge(1, 1) && graphArray[2].hasEdge(0, 4) && graphArray[2].hasEdge(0, 0) && graphArray[2].hasEdge(4, 2) && graphArray[2].hasEdge(1, 0) && graphArray[2].hasEdge(3, 2) && graphArray[1].hasEdge(1, 0) && graphArray[1].hasEdge(0, 0))) {
            TestGraph.fail((String)"graph4 partition error");
        }
    }

    public void testMultiEdgeElimination() throws Exception {
        Graph graph = graph0.getGraphWithoutMultipleEdges();
        if (graph.getNodecount() != 0 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph0 multiedge elimination error");
        }
        if ((graph = graph1.getGraphWithoutMultipleEdges()).getNodecount() != 1 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph1 multiedge elimination error");
        }
        if ((graph = graph2.getGraphWithoutMultipleEdges()).getNodecount() != 2 || graph.getEdgecount() != 1 || !graph.hasEdge(0, 1)) {
            TestGraph.fail((String)"graph2 multiedge elimination error");
        }
        if (!((graph = graph3.getGraphWithoutMultipleEdges()).getNodecount() == 3 && graph.getEdgecount() == 4 && graph.hasEdge(0, 1) && graph.hasEdge(1, 2) && graph.hasEdge(2, 0) && graph.hasEdge(2, 2))) {
            TestGraph.fail((String)"graph3 multiedge elimination error");
        }
        if (!((graph = graph4.getGraphWithoutMultipleEdges()).getNodecount() == 17 && graph.getEdgecount() == 22 && graph.hasEdge(0, 7) && graph.hasEdge(0, 7) && graph.hasEdge(7, 13) && graph.hasEdge(13, 6) && graph.hasEdge(13, 8) && graph.hasEdge(8, 1) && graph.hasEdge(0, 6) && graph.hasEdge(1, 6) && graph.hasEdge(1, 12) && graph.hasEdge(12, 5) && graph.hasEdge(6, 5) && graph.hasEdge(5, 15) && graph.hasEdge(15, 0) && graph.hasEdge(9, 9) && graph.hasEdge(9, 3) && graph.hasEdge(3, 3) && graph.hasEdge(11, 9) && graph.hasEdge(14, 11) && graph.hasEdge(16, 11) && graph.hasEdge(3, 14) && graph.hasEdge(10, 2) && graph.hasEdge(2, 2) && graph.hasEdge(3, 16))) {
            TestGraph.fail((String)"graph4 multiedge elimination error");
        }
    }

    public void testOneOrTwoCycleElimination() throws Exception {
        Graph graph = graph0.getGraphWithoutOneOrTwoCycles();
        if (graph.getNodecount() != 0 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph0 1/2 cycle elimination error");
        }
        if ((graph = graph1.getGraphWithoutOneOrTwoCycles()).getNodecount() != 1 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph1 1/2 cycle elimination error");
        }
        if ((graph = graph2.getGraphWithoutOneOrTwoCycles()).getNodecount() != 2 || graph.getEdgecount() != 2 || !graph.hasEdge(0, 1)) {
            TestGraph.fail((String)"graph2 1/2 cycle elimination error");
        }
        if ((graph = graph3.getGraphWithoutOneOrTwoCycles()).getNodecount() != 3 || graph.getEdgecount() != 3 || !graph.hasEdge(0, 1) || !graph.hasEdge(1, 2) || !graph.hasEdge(2, 0) || graph.hasEdge(2, 2)) {
            TestGraph.fail((String)"graph3 1/2 cycle elimination error");
        }
        if (!((graph = graph4.getGraphWithoutOneOrTwoCycles()).getNodecount() == 17 && graph.getEdgecount() == 21 && graph.hasEdge(0, 7) && graph.hasEdge(0, 7) && graph.hasEdge(7, 13) && graph.hasEdge(13, 6) && graph.hasEdge(13, 8) && graph.hasEdge(8, 1) && graph.hasEdge(0, 6) && graph.hasEdge(1, 6) && graph.hasEdge(1, 12) && graph.hasEdge(12, 5) && graph.hasEdge(6, 5) && graph.hasEdge(5, 15) && graph.hasEdge(15, 0) && !graph.hasEdge(9, 9) && graph.hasEdge(9, 3) && !graph.hasEdge(3, 3) && graph.hasEdge(11, 9) && graph.hasEdge(14, 11) && graph.hasEdge(16, 11) && graph.hasEdge(3, 14) && graph.hasEdge(10, 2) && !graph.hasEdge(2, 2) && graph.hasEdge(3, 16))) {
            TestGraph.fail((String)"graph4 1/2 cycle elimination error");
        }
        if ((graph = graph5.getGraphWithoutOneOrTwoCycles()).getNodecount() != 2 || graph.getEdgecount() != 0 || graph.hasEdge(0, 1) || graph.hasEdge(1, 0)) {
            TestGraph.fail((String)"graph5 1/2 cycle elimination error");
        }
    }

    public void testCycleElimination() throws Exception {
        Graph graph;
        Graph graph2 = graph0;
        int[] nArray = graph2.getCycleEliminationVertexPriority();
        if (nArray.length != 0) {
            TestGraph.fail((String)"graph0 cycle Elimination priority error");
        }
        if ((graph = graph2.getGraphWithoutCycles(nArray)).getNodecount() != 0 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph0 cycle Elimination error");
        }
        if ((nArray = (graph2 = graph1).getCycleEliminationVertexPriority()).length != 1 || nArray[0] != 0) {
            TestGraph.fail((String)"graph1 cycle Elimination priority error");
        }
        if ((graph = graph2.getGraphWithoutCycles(nArray)).getNodecount() != 1 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph1 cycle Elimination error");
        }
        if ((nArray = (graph2 = TestGraph.graph2).getCycleEliminationVertexPriority()).length != 2 || nArray[0] != 0 || nArray[1] != 1) {
            TestGraph.fail((String)"graph2 cycle Elimination priority error");
        }
        if ((graph = graph2.getGraphWithoutCycles(nArray)).getNodecount() != 2 || graph.getEdgecount() != 2 || !graph.hasEdge(0, 1)) {
            TestGraph.fail((String)"graph2 cycle Elimination error");
        }
        if ((nArray = (graph2 = graph3).getCycleEliminationVertexPriority()).length != 3 || nArray[0] != 0 || nArray[1] != 1 || nArray[2] != 2) {
            TestGraph.fail((String)"graph3 cycle Elimination priority error");
        }
        if ((graph = graph2.getGraphWithoutCycles(nArray)).getNodecount() != 3 || graph.getEdgecount() != 3 || !graph.hasEdge(0, 1) || !graph.hasEdge(1, 2) || !graph.hasEdge(0, 2) || graph.hasEdge(2, 2)) {
            TestGraph.fail((String)"graph3 cycle Elimination error");
        }
        int[] nArray2 = new int[17];
        Graph[] graphArray = graph4.partition(graph4.componentIndex(), nArray2);
        graph2 = graphArray[0];
        nArray = graph2.getCycleEliminationVertexPriority();
        if (nArray.length != 9 || nArray[0] != 0 || nArray[1] != 4 || nArray[2] != 7 || nArray[3] != 5 || nArray[4] != 1 || nArray[5] != 6 || nArray[6] != 3 || nArray[7] != 2 || nArray[8] != 8) {
            TestGraph.fail((String)"graph4_0 cycle Elimination priority error");
        }
        if (!((graph = graph2.getGraphWithoutCycles(nArray)).getNodecount() == 9 && graph.getEdgecount() == 12 && graph.hasEdge(4, 7) && graph.hasEdge(0, 4) && graph.hasEdge(0, 3) && graph.hasEdge(0, 8) && graph.hasEdge(2, 8) && graph.hasEdge(7, 3) && graph.hasEdge(7, 5) && graph.hasEdge(3, 2) && graph.hasEdge(1, 3) && graph.hasEdge(5, 1) && graph.hasEdge(6, 2) && graph.hasEdge(1, 6))) {
            TestGraph.fail((String)"graph4_0 cycle Elimination error");
        }
        if ((nArray = (graph2 = graphArray[1]).getCycleEliminationVertexPriority()).length != 2 || nArray[0] != 1 || nArray[1] != 0) {
            TestGraph.fail((String)"graph4_1 cycle Elimination priority error");
        }
        if ((graph = graph2.getGraphWithoutCycles(nArray)).getNodecount() != 2 || graph.getEdgecount() != 1 || !graph.hasEdge(1, 0) || graph.hasEdge(0, 0)) {
            TestGraph.fail((String)"graph4_1 cycle Elimination error");
        }
        if ((nArray = (graph2 = graphArray[2]).getCycleEliminationVertexPriority()).length != 5 || nArray[0] != 0 || nArray[1] != 4 || nArray[2] != 3 || nArray[3] != 2 || nArray[4] != 1) {
            TestGraph.fail((String)"graph4_2 cycle Elimination priority error");
        }
        if (!((graph = graph2.getGraphWithoutCycles(nArray)).getNodecount() == 5 && graph.getEdgecount() == 8 && graph.hasEdge(2, 1) && graph.hasEdge(0, 3) && !graph.hasEdge(1, 1) && graph.hasEdge(0, 4) && !graph.hasEdge(0, 0) && graph.hasEdge(4, 2) && graph.hasEdge(0, 1) && graph.hasEdge(3, 2))) {
            TestGraph.fail((String)"graph4_2 cycle Elimination error");
        }
        if ((nArray = (graph2 = graphArray[3]).getCycleEliminationVertexPriority()).length != 1 || nArray[0] != 0) {
            TestGraph.fail((String)"graph4_3 cycle Elimination priority error");
        }
        if ((graph = graph2.getGraphWithoutCycles(nArray)).getNodecount() != 1 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph4_3 cycle Elimination error");
        }
    }

    public void testTransitiveReduction() throws Exception {
        Graph graph = graph0.getReducedGraph();
        if (graph.getNodecount() != 0 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph0 transitive reduction error");
        }
        if ((graph = graph1.getReducedGraph()).getNodecount() != 1 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph1 transitive reduction error");
        }
        if ((graph = graph2.getReducedGraph()).getNodecount() != 2 || graph.getEdgecount() != 1 || !graph.hasEdge(0, 1)) {
            TestGraph.fail((String)"graph2 transitive reduction error");
        }
        if ((graph = graph3.getReducedGraph()).getNodecount() != 3 || graph.getEdgecount() != 2 || !graph.hasEdge(0, 1) || !graph.hasEdge(1, 2) || graph.hasEdge(0, 2) || graph.hasEdge(2, 2)) {
            TestGraph.fail((String)"graph3 transitive reduction error");
        }
        int[] nArray = new int[17];
        Graph[] graphArray = graph4.partition(graph4.componentIndex(), nArray);
        graph = graphArray[0].getReducedGraph();
        if (!(graph.getNodecount() == 9 && graph.getEdgecount() == 9 && graph.hasEdge(4, 7) && graph.hasEdge(0, 4) && !graph.hasEdge(0, 3) && !graph.hasEdge(0, 8) && graph.hasEdge(2, 8) && !graph.hasEdge(7, 3) && graph.hasEdge(7, 5) && graph.hasEdge(3, 2) && graph.hasEdge(1, 3) && graph.hasEdge(5, 1) && graph.hasEdge(6, 2) && graph.hasEdge(1, 6))) {
            TestGraph.fail((String)"graph4_0 transitive reduction error");
        }
        if ((graph = graphArray[1].getReducedGraph()).getNodecount() != 2 || graph.getEdgecount() != 1 || !graph.hasEdge(1, 0) || graph.hasEdge(0, 0)) {
            TestGraph.fail((String)"graph4_1 transitive reduction error");
        }
        if ((graph = graphArray[2].getReducedGraph()).getNodecount() != 5 || graph.getEdgecount() != 5 || !graph.hasEdge(2, 1) || !graph.hasEdge(0, 3) || graph.hasEdge(1, 1) || !graph.hasEdge(0, 4) || graph.hasEdge(0, 0) || !graph.hasEdge(4, 2) || graph.hasEdge(0, 1) || !graph.hasEdge(3, 2)) {
            TestGraph.fail((String)"graph4_2 transitive reduction error");
        }
        if ((graph = graphArray[3].getReducedGraph()).getNodecount() != 1 || graph.getEdgecount() != 0) {
            TestGraph.fail((String)"graph4_3 transitive reduction error");
        }
    }

    public void testLayerAssignment() throws Exception {
        int[] nArray = graph0.getReducedGraph().getVertexLayers();
        if (nArray.length != 0) {
            TestGraph.fail((String)"graph0 layer assignment error");
        }
        if ((nArray = graph1.getReducedGraph().getVertexLayers()).length != 1 || nArray[0] != 1) {
            TestGraph.fail((String)"graph1 layer assignment error");
        }
        if ((nArray = graph2.getReducedGraph().getVertexLayers()).length != 2 || nArray[0] != 2 || nArray[1] != 1) {
            TestGraph.fail((String)"graph2 layer assignment error");
        }
        if ((nArray = graph3.getReducedGraph().getVertexLayers()).length != 3 || nArray[0] != 3 || nArray[1] != 2 || nArray[2] != 1) {
            TestGraph.fail((String)"graph3 layer assignment error");
        }
        int[] nArray2 = new int[17];
        Graph[] graphArray = graph4.partition(graph4.componentIndex(), nArray2);
        nArray = graphArray[0].getReducedGraph().getVertexLayers();
        if (nArray.length != 9 || nArray[0] != 8 || nArray[1] != 4 || nArray[2] != 2 || nArray[3] != 3 || nArray[4] != 7 || nArray[5] != 5 || nArray[6] != 3 || nArray[7] != 6 || nArray[8] != 1) {
            TestGraph.fail((String)"graph4_0 layer assignment error");
        }
        if ((nArray = graphArray[1].getReducedGraph().getVertexLayers()).length != 2 || nArray[0] != 1 || nArray[1] != 2) {
            TestGraph.fail((String)"graph4_1 layer assignment error");
        }
        if ((nArray = graphArray[2].getReducedGraph().getVertexLayers()).length != 5 || nArray[0] != 4 || nArray[1] != 1 || nArray[2] != 2 || nArray[3] != 3 || nArray[4] != 3) {
            TestGraph.fail((String)"graph4_2 layer assignment error");
        }
        if ((nArray = graphArray[3].getReducedGraph().getVertexLayers()).length != 1 || nArray[0] != 1) {
            TestGraph.fail((String)"graph4_3 layer assignment error");
        }
    }

    public void testHorizontalPosition() throws Exception {
        Graph graph = graph0.getReducedGraph();
        int[] nArray = graph.getVertexLayers();
        int[] nArray2 = graph.getHorizontalPosition(nArray);
        if (nArray.length != 0) {
            TestGraph.fail((String)"graph0 horizontal position error");
        }
        graph = graph1.getReducedGraph();
        nArray = graph.getVertexLayers();
        nArray2 = graph.getHorizontalPosition(nArray);
        if (nArray.length != 1 || nArray2[0] != 1) {
            TestGraph.fail((String)"graph1 horizontal position error");
        }
        graph = graph2.getReducedGraph();
        nArray = graph.getVertexLayers();
        nArray2 = graph.getHorizontalPosition(nArray);
        if (nArray.length != 2 || nArray2[0] != 1 || nArray2[1] != 1) {
            TestGraph.fail((String)"graph2 horizontal position error");
        }
        graph = graph3.getReducedGraph();
        nArray = graph.getVertexLayers();
        nArray2 = graph.getHorizontalPosition(nArray);
        if (nArray.length != 3 || nArray2[0] != 1 || nArray2[1] != 1 || nArray2[2] != 1) {
            TestGraph.fail((String)"graph3 horizontal position error");
        }
        int[] nArray3 = new int[17];
        Graph[] graphArray = graph4.partition(graph4.componentIndex(), nArray3);
        graph = graphArray[0].getReducedGraph();
        nArray2 = graph.getHorizontalPosition(nArray = graph.getVertexLayers());
        if (nArray2.length != 9 || nArray2[0] != 1 || nArray2[1] != 1 || nArray2[2] != 1 || nArray2[3] != 1 || nArray2[4] != 1 || nArray2[5] != 1 || nArray2[6] != 2 || nArray2[7] != 1 || nArray2[8] != 1) {
            TestGraph.fail((String)"graph4_0 horizontalPosition assignment error");
        }
        if ((nArray2 = (graph = graphArray[1].getReducedGraph()).getHorizontalPosition(nArray = graph.getVertexLayers())).length != 2 || nArray2[0] != 1 || nArray2[1] != 1) {
            TestGraph.fail((String)"graph4_1 horizontalPosition assignment error");
        }
        if ((nArray2 = (graph = graphArray[2].getReducedGraph()).getHorizontalPosition(nArray = graph.getVertexLayers())).length != 5 || nArray2[0] != 1 || nArray2[1] != 1 || nArray2[2] != 1 || nArray2[3] != 1 || nArray2[4] != 2) {
            TestGraph.fail((String)"graph4_2 horizontalPosition assignment error");
        }
        if ((nArray2 = (graph = graphArray[3].getReducedGraph()).getHorizontalPosition(nArray = graph.getVertexLayers())).length != 1 || nArray2[0] != 1) {
            TestGraph.fail((String)"graph4_3 horizontalPosition assignment error");
        }
    }
}

