/*
 * Decompiled with CFR 0.152.
 */
package csplugins.hierarchicallayout;

import csplugins.hierarchicallayout.Edge;
import csplugins.hierarchicallayout.IntSortNode;
import csplugins.hierarchicallayout.TwinDoubleSortNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class Graph {
    private int nodecount;
    private Edge[] edge;
    private LinkedList[] edgesFrom;
    private LinkedList[] edgesTo;
    private boolean acyclic;
    private boolean reduced;
    static int MAX_ADJACENT_EXCHANGE_PASSES = 5;

    public Graph(int n, Edge[] edgeArray) {
        int n2;
        this.nodecount = n;
        this.edge = new Edge[edgeArray.length];
        this.edgesFrom = new LinkedList[this.nodecount];
        this.edgesTo = new LinkedList[this.nodecount];
        for (n2 = 0; n2 < this.nodecount; ++n2) {
            this.edgesFrom[n2] = new LinkedList();
            this.edgesTo[n2] = new LinkedList();
        }
        for (n2 = 0; n2 < edgeArray.length; ++n2) {
            int n3 = edgeArray[n2].getFrom();
            int n4 = edgeArray[n2].getTo();
            if (n3 < 0 || n4 >= this.nodecount || n4 < 0 || n4 >= this.nodecount) {
                throw new IllegalArgumentException("Edge refered to node outside of valid range: From=" + n3 + " To=" + n4 + " with nodecount=" + this.nodecount + "\n");
            }
            this.edge[n2] = new Edge(n3, n4);
            this.edgesFrom[n3].add(new Integer(n4));
            this.edgesTo[n4].add(new Integer(n3));
        }
        this.acyclic = false;
        this.reduced = false;
    }

    public Graph(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        this.nodecount = Integer.parseInt(string);
        LinkedList<Edge> linkedList = new LinkedList<Edge>();
        this.edgesFrom = new LinkedList[this.nodecount];
        this.edgesTo = new LinkedList[this.nodecount];
        for (int i = 0; i < this.nodecount; ++i) {
            this.edgesFrom[i] = new LinkedList();
            this.edgesTo[i] = new LinkedList();
        }
        string = bufferedReader.readLine();
        while (!string.equals(".")) {
            String[] stringArray = string.trim().split("\\s+");
            if (stringArray.length != 2) {
                throw new NumberFormatException("Illegal input to Graph constructor:\nExpected two integers, received: " + string + "\n");
            }
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            linkedList.add(new Edge(n, n2));
            this.edgesFrom[n].add(new Integer(n2));
            this.edgesTo[n2].add(new Integer(n));
            string = bufferedReader.readLine();
        }
        this.edge = new Edge[linkedList.size()];
        linkedList.toArray(this.edge);
        this.acyclic = false;
        this.reduced = false;
    }

    public String toString() {
        String string = "Graph with " + this.nodecount + " nodes.\nEdges:\n";
        for (int i = 0; i < this.edge.length; ++i) {
            string = string + "From " + this.edge[i].getFrom() + " To " + this.edge[i].getTo() + "\n";
        }
        return string;
    }

    public int getNodecount() {
        return this.nodecount;
    }

    public int getEdgecount() {
        return this.edge.length;
    }

    public boolean hasEdge(int n, int n2) {
        return this.edgesFrom[n].contains(new Integer(n2));
    }

    public Graph getGraphWithoutOneOrTwoCycles() {
        LinkedList<Edge> linkedList = new LinkedList<Edge>();
        for (int i = 0; i < this.edge.length; ++i) {
            int n;
            int n2 = this.edge[i].getFrom();
            if (n2 == (n = this.edge[i].getTo()) || this.hasEdge(n, n2)) continue;
            linkedList.add(this.edge[i]);
        }
        Edge[] edgeArray = new Edge[linkedList.size()];
        linkedList.toArray(edgeArray);
        return new Graph(this.nodecount, edgeArray);
    }

    public Graph getGraphWithoutMultipleEdges() {
        Edge[] edgeArray;
        LinkedList<Edge> linkedList = new LinkedList<Edge>();
        for (int i = 0; i < this.nodecount; ++i) {
            edgeArray = new HashSet();
            Iterator iterator = this.edgesFrom[i].iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                if (edgeArray.contains(n)) continue;
                linkedList.add(new Edge(i, n));
                edgeArray.add(n);
            }
        }
        edgeArray = new Edge[linkedList.size()];
        linkedList.toArray(edgeArray);
        return new Graph(this.nodecount, edgeArray);
    }

    public int[] componentIndex() {
        int n;
        int n2;
        int[] nArray = new int[this.nodecount];
        LinkedList[] linkedListArray = new LinkedList[this.nodecount];
        for (n2 = 0; n2 < this.nodecount; ++n2) {
            nArray[n2] = n2;
            linkedListArray[n2] = new LinkedList();
            linkedListArray[n2].add(new Integer(n2));
        }
        for (n2 = 0; n2 < this.edge.length; ++n2) {
            if (nArray[this.edge[n2].getFrom()] == nArray[this.edge[n2].getTo()]) continue;
            int n3 = nArray[this.edge[n2].getFrom()];
            if (n3 > (n = nArray[this.edge[n2].getTo()])) {
                int n4 = n3;
                n3 = n;
                n = n4;
            }
            Iterator iterator = linkedListArray[n].iterator();
            while (iterator.hasNext()) {
                int n5 = (Integer)iterator.next();
                nArray[n5] = n3;
                linkedListArray[n3].add(new Integer(n5));
            }
        }
        int[] nArray2 = new int[this.nodecount];
        n = 0;
        int n6 = 0;
        for (n2 = 0; n2 < this.nodecount; ++n2) {
            if (nArray[n2] > n) {
                n = nArray[n2];
                nArray2[nArray[n2]] = ++n6;
            }
            nArray[n2] = nArray2[nArray[n2]];
        }
        return nArray;
    }

    public Graph[] partition(int[] nArray, int[] nArray2) {
        Object object;
        int n;
        if (nArray.length != this.nodecount || nArray2.length != this.nodecount) {
            throw new IllegalArgumentException("partitionGraph received wrong sized argument");
        }
        int[] nArray3 = new int[this.nodecount];
        int n2 = 0;
        for (n = 0; n < this.nodecount; ++n) {
            int n3 = nArray[n];
            nArray3[n3] = nArray3[n3] + 1;
            if (nArray2[n] != 0) continue;
            ++n2;
        }
        LinkedList[] linkedListArray = new LinkedList[n2];
        for (n = 0; n < n2; ++n) {
            linkedListArray[n] = new LinkedList();
        }
        for (n = 0; n < this.edge.length; ++n) {
            object = this.edge[n];
            if (nArray[((Edge)object).getFrom()] != nArray[((Edge)object).getTo()]) continue;
            linkedListArray[nArray[((Edge)object).getFrom()]].add(new Edge(nArray2[((Edge)object).getFrom()], nArray2[((Edge)object).getTo()]));
        }
        object = new Graph[n2];
        for (n = 0; n < n2; ++n) {
            Edge[] edgeArray = new Edge[linkedListArray[n].size()];
            linkedListArray[n].toArray(edgeArray);
            object[n] = new Graph(nArray3[n], edgeArray);
        }
        return object;
    }

    public int[] getCycleEliminationVertexPriority() {
        Object object;
        int n;
        int[] nArray = new int[this.nodecount];
        int[] nArray2 = new int[this.nodecount];
        int[] nArray3 = new int[this.nodecount];
        if (this.nodecount == 0) {
            return nArray;
        }
        if (this.nodecount == 1) {
            nArray[0] = 0;
            return nArray;
        }
        Graph graph = this.getGraphWithoutMultipleEdges().getGraphWithoutOneOrTwoCycles();
        if (this.nodecount == 2) {
            if (graph.edgesFrom[0].size() == 0) {
                nArray[0] = 1;
                nArray[1] = 0;
            } else {
                nArray[0] = 0;
                nArray[1] = 1;
            }
            return nArray;
        }
        LinkedList[] linkedListArray = graph.edgesTo;
        LinkedList[] linkedListArray2 = graph.edgesFrom;
        LinkedList[] linkedListArray3 = new LinkedList[2 * this.nodecount - 3];
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        int n2 = this.nodecount / 2;
        for (n = 0; n < linkedListArray3.length; ++n) {
            linkedListArray3[n] = new LinkedList();
        }
        LinkedList linkedList3 = linkedListArray3[0];
        LinkedList linkedList4 = linkedListArray3[linkedListArray3.length - 1];
        for (n = 0; n < this.nodecount; ++n) {
            nArray2[n] = linkedListArray[n].size();
            nArray3[n] = linkedListArray2[n].size();
            if (nArray3[n] == 0) {
                linkedList3.add(new Integer(n));
                continue;
            }
            if (nArray2[n] == 0) {
                linkedList4.add(new Integer(n));
                continue;
            }
            linkedListArray3[nArray3[n] - nArray2[n] + n2].add(new Integer(n));
        }
        int n3 = linkedListArray3.length - 2;
        for (int i = this.nodecount; i != 0; --i) {
            int n4;
            int n5;
            int n6;
            int n7;
            Integer n8;
            boolean bl = false;
            if (linkedList3.size() > 0) {
                object = (Integer)linkedList3.removeFirst();
                bl = true;
            } else if (linkedList4.size() > 0) {
                object = (Integer)linkedList4.removeFirst();
            } else {
                while (linkedListArray3[n3].size() == 0) {
                    --n3;
                }
                object = (Integer)linkedListArray3[n3].removeFirst();
            }
            LinkedList linkedList5 = linkedListArray[(Integer)object];
            while (linkedList5.size() > 0) {
                n8 = (Integer)linkedList5.removeFirst();
                n7 = n8;
                n6 = nArray2[n7];
                n5 = nArray3[n7];
                if (n5 == 0) {
                    linkedList3.remove(n8);
                } else if (n6 == 0) {
                    linkedList4.remove(n8);
                } else {
                    linkedListArray3[n5 - n6 + n2].remove(n8);
                }
                linkedListArray2[n7].remove(object);
                int n9 = n7;
                nArray3[n9] = nArray3[n9] - 1;
                if (--n5 == 0) {
                    linkedList3.add(n8);
                    continue;
                }
                if (n6 == 0) {
                    linkedList4.add(n8);
                    continue;
                }
                n4 = n5 - n6 + n2;
                linkedListArray3[n4].add(n8);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            linkedList5 = linkedListArray2[(Integer)object];
            while (linkedList5.size() > 0) {
                n8 = (Integer)linkedList5.removeFirst();
                n7 = n8;
                n6 = nArray2[n7];
                n5 = nArray3[n7];
                if (n5 == 0) {
                    linkedList3.remove(n8);
                } else if (n6 == 0) {
                    linkedList4.remove(n8);
                } else {
                    linkedListArray3[n5 - n6 + n2].remove(n8);
                }
                linkedListArray[n7].remove(object);
                int n10 = n7;
                nArray2[n10] = nArray2[n10] - 1;
                --n6;
                if (n5 == 0) {
                    linkedList3.add(n8);
                    continue;
                }
                if (n6 == 0) {
                    linkedList4.add(n8);
                    continue;
                }
                n4 = n5 - n6 + n2;
                linkedListArray3[n4].add(n8);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            if (bl) {
                linkedList.addFirst(object);
                continue;
            }
            linkedList2.addLast(object);
        }
        n = 0;
        object = linkedList2.iterator();
        while (object.hasNext()) {
            nArray[n++] = (Integer)object.next();
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            nArray[n++] = (Integer)object.next();
        }
        return nArray;
    }

    public Graph getGraphWithoutCycles(int[] nArray) {
        int n;
        int[] nArray2 = new int[this.nodecount];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[nArray[n]] = n;
        }
        LinkedList<Edge> linkedList = new LinkedList<Edge>();
        for (n = 0; n < this.edge.length; ++n) {
            int n2;
            int n3 = this.edge[n].getFrom();
            if (n3 == (n2 = this.edge[n].getTo())) continue;
            if (nArray2[n3] > nArray2[n2]) {
                int n4 = n3;
                n3 = n2;
                n2 = n4;
                linkedList.add(new Edge(n3, n2));
                continue;
            }
            linkedList.add(this.edge[n]);
        }
        Edge[] edgeArray = new Edge[linkedList.size()];
        linkedList.toArray(edgeArray);
        Graph graph = new Graph(this.nodecount, edgeArray);
        graph.acyclic = true;
        return graph;
    }

    public Graph getReducedGraph(int[] nArray) {
        Object object;
        if (nArray.length != this.nodecount) {
            throw new IllegalArgumentException("topological ordering of nodes does not match nodecount");
        }
        if (!this.acyclic) {
            throw new RuntimeException("attempt to compute transitive reduction on a graph with cycles");
        }
        int[] nArray2 = new int[this.nodecount];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray[i]] = i;
        }
        LinkedList<Edge> linkedList = new LinkedList<Edge>();
        LinkedHashSet[] linkedHashSetArray = new LinkedHashSet[this.nodecount];
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n;
            int n2 = nArray[i];
            object = new LinkedHashSet(this.edgesFrom[n2]);
            Object[] objectArray = new IntSortNode[((HashSet)object).size()];
            int n3 = 0;
            Iterator iterator = ((HashSet)object).iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                objectArray[n3++] = new IntSortNode(nArray2[n], n);
            }
            Arrays.sort(objectArray);
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                n = ((IntSortNode)objectArray[n3]).getSecond();
                Integer n4 = new Integer(n);
                if (linkedHashSetArray[n2] == null) {
                    linkedHashSetArray[n2] = linkedHashSetArray[n] == null ? new LinkedHashSet() : new LinkedHashSet(linkedHashSetArray[n]);
                    linkedList.add(new Edge(n2, n));
                } else {
                    if (!linkedHashSetArray[n2].contains(n4)) {
                        linkedList.add(new Edge(n2, n));
                    }
                    if (linkedHashSetArray[n] != null) {
                        linkedHashSetArray[n2].addAll(linkedHashSetArray[n]);
                    }
                }
                linkedHashSetArray[n2].add(n4);
            }
        }
        Edge[] edgeArray = new Edge[linkedList.size()];
        linkedList.toArray(edgeArray);
        object = new Graph(this.nodecount, edgeArray);
        ((Graph)object).acyclic = true;
        ((Graph)object).reduced = true;
        return object;
    }

    public Graph getReducedGraph() {
        int[] nArray = this.getCycleEliminationVertexPriority();
        Graph graph = this.getGraphWithoutCycles(nArray);
        return graph.getReducedGraph(nArray);
    }

    public static boolean orderedSetComparison(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            return false;
        }
        if (nArray == null) {
            return true;
        }
        int n = Math.min(nArray.length, nArray2.length);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= nArray2[i]) continue;
            return true;
        }
        return nArray.length < nArray2.length;
    }

    public int[] getVertexLayers() {
        int n;
        Object object;
        int n2;
        int n3;
        Serializable serializable;
        Iterator iterator;
        int n4;
        if (!this.reduced) {
            throw new RuntimeException("attempt to compute vertex layers in a non-reduced graph");
        }
        int n5 = Math.max((int)Math.pow(this.nodecount, 0.6366197723675814), 10);
        int[] nArray = new int[this.nodecount];
        for (n4 = 0; n4 < this.nodecount; ++n4) {
            nArray[n4] = 0;
        }
        int[][] nArrayArray = new int[this.nodecount][];
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>(this.nodecount * 3 / 2);
        boolean[] blArray = new boolean[this.nodecount];
        for (n4 = 0; n4 < this.nodecount; ++n4) {
            if (this.edgesTo[n4].size() == 0) {
                linkedHashSet.add(new Integer(n4));
                blArray[n4] = true;
                continue;
            }
            blArray[n4] = false;
        }
        int n6 = 1;
        while (linkedHashSet.size() > 0) {
            iterator = linkedHashSet.iterator();
            serializable = (Integer)iterator.next();
            n3 = (Integer)serializable;
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                if (!Graph.orderedSetComparison(nArrayArray[n2], nArrayArray[n3])) continue;
                n3 = n2;
            }
            nArray[n3] = n6++;
            linkedHashSet.remove(serializable);
            blArray[n3] = false;
            iterator = this.edgesFrom[n3].iterator();
            block4: while (iterator.hasNext()) {
                int n7;
                n2 = (Integer)iterator.next();
                if (blArray[n2]) continue;
                object = this.edgesTo[n2].iterator();
                int[] nArray2 = new int[this.edgesTo[n2].size()];
                n = 0;
                while (object.hasNext()) {
                    n7 = (Integer)object.next();
                    if (nArray[n7] == 0) continue block4;
                    nArray2[n++] = n7;
                }
                Arrays.sort(nArray2);
                nArrayArray[n2] = new int[nArray2.length];
                n7 = 0;
                for (n4 = nArray2.length - 1; n4 >= 0; --n4) {
                    nArrayArray[n2][n7++] = nArray[nArray2[n4]];
                }
                linkedHashSet.add(new Integer(n2));
                blArray[n2] = true;
            }
        }
        iterator = (Iterator)new int[this.nodecount];
        for (n4 = 0; n4 < this.nodecount; ++n4) {
            iterator[n4] = false;
        }
        linkedHashSet.clear();
        serializable = new LinkedHashSet();
        for (n4 = 0; n4 < this.nodecount; ++n4) {
            if (this.edgesFrom[n4].size() != 0) continue;
            linkedHashSet.add(new Integer(n4));
        }
        n3 = 1;
        while (linkedHashSet.size() > 0) {
            n2 = 0;
            object = new Integer[linkedHashSet.size()];
            linkedHashSet.toArray((T[])object);
            Arrays.sort((Object[])object);
            for (int i = ((Object[])object).length - 1; i >= 0 && n2 != n5; --i) {
                n = (Integer)object[i];
                iterator[n] = (Iterator)n3;
                ++n2;
                Iterator iterator2 = this.edgesTo[n].iterator();
                block11: while (iterator2.hasNext()) {
                    Integer n8 = (Integer)iterator2.next();
                    int n9 = n8;
                    if (iterator[n9] > 0) continue;
                    Iterator iterator3 = this.edgesFrom[n9].iterator();
                    while (iterator3.hasNext()) {
                        int n10 = (Integer)iterator3.next();
                        if (iterator[n10] != false) continue;
                        continue block11;
                    }
                    ((HashSet)serializable).add(n8);
                }
                linkedHashSet.remove(new Integer(n));
                ((HashSet)serializable).remove(new Integer(n));
            }
            ++n3;
            linkedHashSet.addAll((Collection<Integer>)((Object)serializable));
        }
        return iterator;
    }

    public int[] getHorizontalPosition(int[] nArray) {
        double d;
        int n;
        int n2;
        int n3;
        double[] dArray;
        double[] dArray2;
        int n4;
        int n5;
        int n6;
        double[] dArray3;
        int n7;
        int n8;
        int n9;
        boolean bl;
        int n10;
        double d2;
        int n11;
        int n12;
        if (!this.reduced) {
            throw new RuntimeException("attempt to compute horizontal position in a non-reduced graph");
        }
        int[] nArray2 = new int[this.nodecount];
        if (this.nodecount == 1) {
            nArray2[0] = 1;
            return nArray2;
        }
        double[] dArray4 = new double[this.nodecount];
        double[] dArray5 = new double[this.nodecount];
        double[] dArray6 = new double[this.nodecount];
        int[] nArray3 = new int[this.nodecount + 1];
        LinkedList[] linkedListArray = new LinkedList[this.nodecount + 1];
        int n13 = 0;
        for (n12 = 0; n12 < this.nodecount; ++n12) {
            nArray2[n12] = 0;
            nArray3[n12 + 1] = 1;
            int n14 = nArray[n12];
            if (linkedListArray[n14] == null) {
                linkedListArray[n14] = new LinkedList();
            }
            linkedListArray[n14].add(new Integer(n12));
            if (n14 <= n13) continue;
            n13 = n14;
        }
        ListIterator listIterator = linkedListArray[n13].listIterator();
        double d3 = 0.0;
        while (listIterator.hasNext()) {
            n11 = (Integer)listIterator.next();
            dArray4[n11] = d3;
            dArray5[n11] = d3;
            dArray6[n11] = d3;
            d3 += 1.0;
        }
        for (n11 = n13 - 1; n11 > 0; --n11) {
            int n15;
            int n16 = 0;
            Object[] objectArray = new TwinDoubleSortNode[linkedListArray[n11].size()];
            listIterator = linkedListArray[n11].listIterator();
            while (listIterator.hasNext()) {
                int n17 = (Integer)listIterator.next();
                if (this.edgesTo[n17].isEmpty()) {
                    dArray5[n17] = 0.0;
                    dArray6[n17] = 0.0;
                } else {
                    int n18 = 0;
                    double[] dArray7 = new double[this.edgesTo[n17].size()];
                    ListIterator listIterator2 = this.edgesTo[n17].listIterator();
                    dArray6[n17] = 0.0;
                    while (listIterator2.hasNext()) {
                        n15 = (Integer)listIterator2.next();
                        int n19 = n17;
                        dArray6[n19] = dArray6[n19] + dArray4[n15];
                        dArray7[n18++] = dArray4[n15];
                    }
                    Arrays.sort(dArray7);
                    dArray5[n17] = dArray7[dArray7.length / 2];
                    int n20 = n17;
                    dArray6[n20] = dArray6[n20] / (double)this.edgesTo[n17].size();
                }
                objectArray[n16++] = new TwinDoubleSortNode(dArray5[n17], dArray6[n17], n17);
            }
            d2 = -1.7976931348623157E308;
            int n21 = 0;
            Arrays.sort(objectArray);
            for (n12 = 0; n12 < objectArray.length; ++n12) {
                int n22 = ((TwinDoubleSortNode)objectArray[n12]).getValue();
                if (n12 > 0 && dArray5[n22] == dArray5[((TwinDoubleSortNode)objectArray[n12 - 1]).getValue()]) {
                    if (d2 == -1.7976931348623157E308) {
                        n21 = 1;
                        for (n15 = n12 + 1; n15 < objectArray.length; ++n15) {
                            if (dArray5[((TwinDoubleSortNode)objectArray[n15]).getValue()] > dArray5[((TwinDoubleSortNode)objectArray[n15 - 1]).getValue()]) {
                                d2 = dArray5[((TwinDoubleSortNode)objectArray[n15]).getValue()];
                                break;
                            }
                            ++n21;
                        }
                        if (d2 == -1.7976931348623157E308) {
                            d2 = dArray5[((TwinDoubleSortNode)objectArray[n12]).getValue()] + 1.0;
                        }
                    }
                    dArray4[n22] = dArray4[((TwinDoubleSortNode)objectArray[n12 - 1]).getValue()] + (d2 - dArray4[((TwinDoubleSortNode)objectArray[n12 - 1]).getValue()]) / (double)(n21-- + 1);
                    continue;
                }
                d2 = -1.7976931348623157E308;
                dArray4[n22] = dArray5[n22];
            }
            for (n12 = 0; n12 < objectArray.length; ++n12) {
                nArray2[((TwinDoubleSortNode)objectArray[n12]).getValue()] = n12 + 1;
            }
        }
        double d4 = 4.9E-323;
        d2 = 0.0;
        n12 = 0;
        while (n12 < this.nodecount) {
            int n23 = n12++;
            dArray4[n23] = dArray4[n23] + d2;
            d2 += d4;
        }
        Object[] objectArray = new Object[this.nodecount];
        Object[] objectArray2 = new Object[this.nodecount];
        for (n11 = n13 - 1; n11 > 1; --n11) {
            int[] nArray4 = new int[linkedListArray[n11].size()];
            listIterator = linkedListArray[n11].listIterator();
            while (listIterator.hasNext()) {
                nArray4[nArray2[n10] - 1] = n10 = ((Integer)listIterator.next()).intValue();
            }
            n10 = MAX_ADJACENT_EXCHANGE_PASSES;
            bl = false;
            while (!bl && n10-- > 0) {
                bl = true;
                for (n9 = 1; n9 < nArray4.length; ++n9) {
                    ListIterator listIterator3;
                    n8 = nArray4[n9 - 1];
                    n7 = nArray4[n9];
                    if (objectArray[n8] == null) {
                        dArray3 = new double[this.edgesTo[n8].size()];
                        listIterator3 = this.edgesTo[n8].listIterator();
                        n6 = 0;
                        while (listIterator3.hasNext()) {
                            n5 = (Integer)listIterator3.next();
                            dArray3[n6++] = dArray4[n5];
                        }
                        Arrays.sort(dArray3);
                        objectArray[n8] = dArray3;
                    }
                    if (objectArray2[n8] == null) {
                        dArray3 = new double[this.edgesFrom[n8].size()];
                        listIterator3 = this.edgesFrom[n8].listIterator();
                        n6 = 0;
                        while (listIterator3.hasNext()) {
                            n5 = (Integer)listIterator3.next();
                            dArray3[n6++] = dArray4[n5];
                        }
                        Arrays.sort(dArray3);
                        objectArray2[n8] = dArray3;
                    }
                    if (objectArray[n7] == null) {
                        dArray3 = new double[this.edgesTo[n7].size()];
                        listIterator3 = this.edgesTo[n7].listIterator();
                        n6 = 0;
                        while (listIterator3.hasNext()) {
                            n5 = (Integer)listIterator3.next();
                            dArray3[n6++] = dArray4[n5];
                        }
                        Arrays.sort(dArray3);
                        objectArray[n7] = dArray3;
                    }
                    if (objectArray2[n7] == null) {
                        dArray3 = new double[this.edgesFrom[n7].size()];
                        listIterator3 = this.edgesFrom[n7].listIterator();
                        n6 = 0;
                        while (listIterator3.hasNext()) {
                            n5 = (Integer)listIterator3.next();
                            dArray3[n6++] = dArray4[n5];
                        }
                        Arrays.sort(dArray3);
                        objectArray2[n7] = dArray3;
                    }
                    n4 = 0;
                    n5 = 0;
                    dArray2 = (double[])objectArray[n8];
                    dArray = (double[])objectArray[n7];
                    n3 = 0;
                    n2 = 0;
                    while (n3 < dArray2.length && n2 < dArray.length) {
                        if (dArray[n2] < dArray2[n3]) {
                            n4 += dArray2.length - n3;
                            ++n2;
                            continue;
                        }
                        ++n3;
                    }
                    n3 = 0;
                    n2 = 0;
                    while (n3 < dArray2.length && n2 < dArray.length) {
                        if (dArray[n2] > dArray2[n3]) {
                            n5 += dArray.length - n2;
                            ++n3;
                            continue;
                        }
                        ++n2;
                    }
                    dArray2 = (double[])objectArray2[n8];
                    dArray = (double[])objectArray2[n7];
                    n3 = 0;
                    n2 = 0;
                    while (n3 < dArray2.length && n2 < dArray.length) {
                        if (dArray[n2] < dArray2[n3]) {
                            n4 += dArray2.length - n3;
                            ++n2;
                            continue;
                        }
                        ++n3;
                    }
                    n3 = 0;
                    n2 = 0;
                    while (n3 < dArray2.length && n2 < dArray.length) {
                        if (dArray[n2] > dArray2[n3]) {
                            n5 += dArray.length - n2;
                            ++n3;
                            continue;
                        }
                        ++n2;
                    }
                    if (n4 <= n5) continue;
                    n = nArray2[n8];
                    nArray2[n8] = nArray2[n7];
                    nArray2[n7] = n;
                    nArray4[n9] = n8;
                    nArray4[n9 - 1] = n7;
                    d = dArray4[n8];
                    dArray4[n8] = dArray4[n7];
                    dArray4[n7] = d;
                    bl = false;
                }
            }
        }
        int[] nArray5 = new int[linkedListArray[1].size()];
        listIterator = linkedListArray[1].listIterator();
        while (listIterator.hasNext()) {
            nArray5[nArray2[n10] - 1] = n10 = ((Integer)listIterator.next()).intValue();
        }
        n10 = MAX_ADJACENT_EXCHANGE_PASSES;
        bl = false;
        while (!bl && n10-- > 0) {
            bl = true;
            for (n9 = 1; n9 < nArray5.length; ++n9) {
                n8 = nArray5[n9 - 1];
                n7 = nArray5[n9];
                if (objectArray[n8] == null) {
                    dArray3 = new double[this.edgesTo[n8].size()];
                    ListIterator listIterator4 = this.edgesTo[n8].listIterator();
                    n6 = 0;
                    while (listIterator4.hasNext()) {
                        n5 = (Integer)listIterator4.next();
                        dArray3[n6++] = dArray4[n5];
                    }
                    Arrays.sort(dArray3);
                    objectArray[n8] = dArray3;
                }
                if (objectArray[n7] == null) {
                    dArray3 = new double[this.edgesTo[n7].size()];
                    ListIterator listIterator5 = this.edgesTo[n7].listIterator();
                    n6 = 0;
                    while (listIterator5.hasNext()) {
                        n5 = (Integer)listIterator5.next();
                        dArray3[n6++] = dArray4[n5];
                    }
                    Arrays.sort(dArray3);
                    objectArray[n7] = dArray3;
                }
                n4 = 0;
                n5 = 0;
                dArray2 = (double[])objectArray[n8];
                dArray = (double[])objectArray[n7];
                n3 = 0;
                n2 = 0;
                while (n3 < dArray2.length && n2 < dArray.length) {
                    if (dArray[n2] < dArray2[n3]) {
                        n4 += dArray2.length - n3;
                        ++n2;
                        continue;
                    }
                    ++n3;
                }
                n3 = 0;
                n2 = 0;
                while (n3 < dArray2.length && n2 < dArray.length) {
                    if (dArray[n2] > dArray2[n3]) {
                        n5 += dArray.length - n2;
                        ++n3;
                        continue;
                    }
                    ++n2;
                }
                if (n4 <= n5) continue;
                n = nArray2[n8];
                nArray2[n8] = nArray2[n7];
                nArray2[n7] = n;
                nArray5[n9] = n8;
                nArray5[n9 - 1] = n7;
                d = dArray4[n8];
                dArray4[n8] = dArray4[n7];
                dArray4[n7] = d;
                bl = false;
            }
        }
        return nArray2;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            Graph graph = new Graph(new InputStreamReader(System.in));
            int[] nArray = graph.componentIndex();
            System.out.println("Node index:\n");
            for (n = 0; n < graph.getNodecount(); ++n) {
                System.out.println(Integer.toString(nArray[n]));
            }
            System.out.println("Partitioning into components:\n");
            int[] nArray2 = new int[nArray.length];
            Graph[] graphArray = graph.partition(nArray, nArray2);
            for (n = 0; n < graphArray.length; ++n) {
                int n2;
                System.out.println("layer assignment:\n");
                Graph graph2 = graphArray[n].getReducedGraph();
                int[] nArray3 = graph2.getVertexLayers();
                for (n2 = 0; n2 < nArray3.length; ++n2) {
                    System.out.println("" + n2 + " : " + nArray3[n2]);
                }
                System.out.println("horizontal position:\n");
                int[] nArray4 = graph2.getHorizontalPosition(nArray3);
                for (n2 = 0; n2 < nArray4.length; ++n2) {
                    System.out.println("" + n2 + " : " + nArray4[n2]);
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Error detected reading graph\nExiting\n");
        }
    }
}

