/*
 * Decompiled with CFR 0.152.
 */
package filter.view;

import filter.model.Filter;
import filter.model.FilterManager;
import filter.model.FilterNode;
import filter.view.FilterEditor;
import filter.view.FilterListPanel;
import filter.view.FilterTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class FilterTreeEditor
extends FilterEditor
implements PropertyChangeListener,
TreeSelectionListener,
ActionListener {
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    public FilterTree filterTree;
    String identifier = "FilterTree";
    public FilterListPanel filterListPanel;
    public JLabel status;
    public JComboBox filterTreeList;
    public JButton setTreeButton;
    public JPanel treePanel;
    public JButton addFilterChild;
    public JButton removeFilterChild;
    public JButton replaceFilter;

    public FilterTreeEditor() {
        this.initialize();
    }

    protected void initialize() {
        JPanel titlePanel = new JPanel();
        this.filterTreeList = new JComboBox();
        this.filterTreeList.setEditable(true);
        this.filterTreeList.addActionListener(this);
        this.setTreeButton = new JButton("Set");
        this.setTreeButton.addActionListener(this);
        titlePanel.add(new JLabel("Tree Filter Name:"));
        titlePanel.add(this.filterTreeList);
        titlePanel.add(this.setTreeButton);
        this.status = new JLabel();
        titlePanel.add(this.status);
        this.treePanel = new JPanel();
        this.filterTree = new FilterTree();
        this.treePanel.add(this.filterTree);
        JScrollPane scroll = new JScrollPane(this.treePanel);
        scroll.setPreferredSize(new Dimension(50, 100));
        this.addFilterChild = new JButton("<- Add Child");
        this.addFilterChild.addActionListener(this);
        this.removeFilterChild = new JButton("Remove Child ->");
        this.removeFilterChild.addActionListener(this);
        this.replaceFilter = new JButton("= Replace Filter =");
        this.removeFilterChild.addActionListener(this);
        JPanel filterControlPanel = new JPanel();
        filterControlPanel.setLayout(new GridLayout(0, 1));
        filterControlPanel.setBorder(new TitledBorder("Control"));
        filterControlPanel.add(this.addFilterChild);
        filterControlPanel.add(this.replaceFilter);
        filterControlPanel.add(this.removeFilterChild);
        this.filterListPanel = new FilterListPanel(FilterListPanel.SHOW_TOGETHER);
        JPanel a = new JPanel();
        a.add(titlePanel);
        a.add(filterControlPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)a, "North");
        this.add((Component)scroll, "Center");
        this.add((Component)this.filterListPanel, "West");
    }

    public Filter getFilter() {
        return this.filterTree;
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return FilterTree.FILTER_ID;
    }

    public void editFilter(Filter filter) {
        FilterTree tree = (FilterTree)filter;
        if (tree.getRoot() == null) {
            return;
        }
        this.filterTree = tree;
        this.treePanel.removeAll();
        this.treePanel.add(tree);
        for (int i = 0; i < this.filterTree.getRowCount(); ++i) {
            this.filterTree.expandRow(i);
        }
        this.validate();
    }

    public void reset() {
    }

    public void clear() {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.filterTreeList) {
            String name = (String)this.filterTreeList.getSelectedItem();
            if (FilterManager.defaultManager().filterExists(name)) {
                this.filterTreeList.setSelectedItem(name);
                this.editFilter(FilterManager.defaultManager().getFilterTree(name));
            } else if (this.filterTree == null) {
                this.filterTree = new FilterTree();
                FilterManager.defaultManager().addFilterTree(this.filterTree);
            } else if (this.filterTree.getRoot() == null) {
                this.filterTreeList.removeItem(this.filterTree.toString());
                FilterManager.defaultManager().removeFilterTree(this.filterTree.toString());
                this.filterTree.setIdentifier(name);
                FilterManager.defaultManager().addFilterTree(this.filterTree);
                this.filterTreeList.addItem(name);
                this.filterTreeList.setSelectedItem(name);
            } else {
                FilterTree new_tree = (FilterTree)this.filterTree.clone();
                new_tree.setIdentifier(name);
                FilterManager.defaultManager().addFilterTree(new_tree);
                this.filterTreeList.addItem(name);
                this.filterTreeList.setSelectedItem(name);
                this.editFilter(new_tree);
            }
        } else if (e.getSource() == this.addFilterChild) {
            Filter new_filter = this.filterListPanel.getLastSelectedFilter();
            if (this.filterTree == null) {
                this.filterTree = new FilterTree(new FilterNode(0, new_filter));
                return;
            }
            if (this.filterTree.getRoot() == null) {
                this.filterTree.setRoot(new FilterNode(0, new_filter));
                return;
            }
            this.filterTree.addFilterNode(new_filter);
        } else if (e.getSource() == this.removeFilterChild) {
            this.filterTree.removeSelectedNode();
        } else if (e.getSource() == this.replaceFilter) {
            Filter new_filter = this.filterListPanel.getLastSelectedFilter();
            this.filterTree.getSelectedNode().setFilter(new_filter);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        FilterNode filter_node = (FilterNode)e.getPath().getLastPathComponent();
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }
}

