/*
 * Decompiled with CFR 0.152.
 */
package filter.view;

import filter.model.Filter;
import filter.model.FilterNode;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilterTree
extends JTree
implements Filter {
    protected FilterNode root;
    protected String identifier;
    public static String FILTER_ID = "FilterTree";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public FilterTree() {
        this.setRoot(null);
    }

    public FilterTree(FilterNode root) {
        this.setRoot(root);
    }

    public void initialize() {
        this.setCellRenderer(new TreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = new JLabel();
                if (value == null) {
                    label.setText("null");
                }
                label.setText(value.toString());
                if (row % 2 != 0) {
                    label.setBackground(Color.white);
                    label.setForeground(Color.black);
                } else {
                    label.setBackground(Color.gray);
                    label.setForeground(Color.black);
                }
                return label;
            }
        });
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public void setRoot(FilterNode root) {
        this.root = root;
        this.setModel(new DefaultTreeModel(root));
    }

    public FilterNode getRoot() {
        return this.root;
    }

    public FilterNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return this.getRoot();
        }
        FilterNode selection = (FilterNode)path.getLastPathComponent();
        if (selection == null) {
            return this.getRoot();
        }
        return selection;
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public FilterNode addFilterNode(Filter filter) {
        FilterNode child = new FilterNode(0, filter);
        FilterNode parent = this.getSelectedNode();
        this.getTreeModel().insertNodeInto(child, parent, parent.getChildCount());
        this.scrollPathToVisible(new TreePath(child.getPath()));
        return child;
    }

    public FilterNode addFilterNode(FilterNode child) {
        FilterNode parent = this.getSelectedNode();
        this.getTreeModel().insertNodeInto(child, parent, parent.getChildCount());
        this.scrollPathToVisible(new TreePath(child.getPath()));
        return child;
    }

    public FilterNode removeSelectedNode() {
        FilterNode child = this.getSelectedNode();
        if (child == this.getRoot()) {
            return null;
        }
        FilterNode parent = (FilterNode)child.getParent();
        if (parent != null) {
            this.getTreeModel().removeNodeFromParent(child);
        }
        return child;
    }

    public FilterNode removeNode(FilterNode child) {
        if (child == this.getRoot()) {
            return null;
        }
        FilterNode parent = (FilterNode)child.getParent();
        if (parent != null) {
            this.getTreeModel().removeNodeFromParent(child);
        }
        return child;
    }

    public String toString() {
        return this.identifier;
    }

    public void setIdentifier(String new_id) {
        this.identifier = new_id;
    }

    public boolean passesFilter(Object object) {
        return this.root.passesFilter(object);
    }

    public Class[] getPassingTypes() {
        return this.root.getPassingTypes();
    }

    public boolean equals(Object other_object) {
        return other_object instanceof FilterTree && ((FilterTree)other_object).getRoot() == this.getRoot();
    }

    public Object clone() {
        FilterNode new_root = (FilterNode)this.root.clone();
        Enumeration<TreeNode> enm = this.root.children();
        while (enm.hasMoreElements()) {
            FilterNode child = (FilterNode)enm.nextElement();
            FilterNode new_child = (FilterNode)child.clone();
            new_root.add(new_child);
            this.cloneChildren(child, new_child);
        }
        return new FilterTree(new_root);
    }

    private void cloneChildren(FilterNode parent, FilterNode new_parent) {
        Enumeration<TreeNode> enm = parent.children();
        while (enm.hasMoreElements()) {
            FilterNode child = (FilterNode)enm.nextElement();
            FilterNode new_child = (FilterNode)child.clone();
            new_parent.add(new_child);
            this.cloneChildren(child, new_child);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public String output() {
        return null;
    }

    public Filter input(String desc) {
        return null;
    }
}

