/*
 * Decompiled with CFR 0.152.
 */
package filter.view;

import ViolinStrings.Strings;
import filter.model.Filter;
import filter.model.FilterManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.SwingPropertyChangeSupport;

public class FilterListPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
ListSelectionListener {
    JTextField searchField;
    JList filterList;
    JList filterTreeList;
    JList compoundList;
    DefaultListModel filterModel;
    DefaultListModel filterTreeModel;
    DefaultListModel compoundModel;
    public static int SHOW_SEPARATE = 0;
    public static int SHOW_TOGETHER = 1;
    public static int SHOW_TREES = 2;
    public static int SHOW_FILTERS = 3;
    public static String FILTER_SELECTED = "FILTER_SELECTED";
    int type;
    Object lastSelectedFilter;
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public FilterListPanel(int type) {
        this.type = type;
        this.initialize();
    }

    protected void initialize() {
        FilterManager.defaultManager().getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        JPanel searchPanel = new JPanel();
        searchPanel.setBorder(new TitledBorder("Search Filters"));
        this.searchField = new JTextField(10);
        this.searchField.addActionListener(this);
        searchPanel.add(this.searchField);
        searchPanel.add(new JButton(new AbstractAction("Go!"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).performSearch();
                    }
                });
            }

            static /* synthetic */ FilterListPanel access$000(1 x0) {
                return x0.FilterListPanel.this;
            }
        }));
        searchPanel.add(new JButton(new AbstractAction("Reset"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3.access$100(this.this$1).updateLists();
                    }
                });
            }

            static /* synthetic */ FilterListPanel access$100(3 x0) {
                return x0.FilterListPanel.this;
            }
        }));
        JPanel listPanel = new JPanel();
        listPanel.setBorder(new TitledBorder("Available Filters"));
        if (this.type == SHOW_SEPARATE) {
            this.filterList = new JList();
            this.filterTreeList = new JList();
            this.filterList.addListSelectionListener(this);
            this.filterTreeList.addListSelectionListener(this);
            this.updateLists();
            listPanel.setLayout(new GridLayout(1, 0));
            JScrollPane fl = new JScrollPane(this.filterList);
            JScrollPane tl = new JScrollPane(this.filterTreeList);
            JPanel flPanel = new JPanel();
            flPanel.setBorder(new TitledBorder("Filters"));
            flPanel.add(fl);
            JPanel tlPanel = new JPanel();
            tlPanel.setBorder(new TitledBorder("FilterTrees"));
            tlPanel.add(tl);
            listPanel.add(flPanel);
            listPanel.add(tlPanel);
        } else if (this.type == SHOW_TOGETHER) {
            this.compoundList = new JList();
            this.compoundList.setSelectionMode(0);
            this.compoundList.addListSelectionListener(this);
            this.updateLists();
            JScrollPane scroll = new JScrollPane(this.compoundList);
            listPanel.add((Component)scroll, "Center");
        } else if (this.type == SHOW_TREES) {
            this.filterTreeList = new JList();
            this.filterTreeList.addListSelectionListener(this);
            this.updateLists();
            JScrollPane scroll = new JScrollPane(this.filterTreeList);
            listPanel.add((Component)scroll, "Center");
        } else {
            this.filterList = new JList();
            this.filterList.setSelectionMode(0);
            this.filterList.addListSelectionListener(this);
            this.updateLists();
            JScrollPane scroll = new JScrollPane(this.filterList);
            listPanel.add((Component)scroll, "Center");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)listPanel, "Center");
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    protected void fireFilterSelected() {
        this.pcs.firePropertyChange(FILTER_SELECTED, null, this.lastSelectedFilter);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.filterList) {
            this.lastSelectedFilter = this.filterList.getSelectedValue();
        } else if (e.getSource() == this.filterTreeList) {
            this.lastSelectedFilter = this.filterTreeList.getSelectedValue();
        } else if (e.getSource() == this.compoundList) {
            this.lastSelectedFilter = this.compoundList.getSelectedValue();
        }
        this.fireFilterSelected();
    }

    public Filter getLastSelectedFilter() {
        return FilterManager.defaultManager().getFilter((String)this.lastSelectedFilter);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.searchField) {
            this.performSearch();
        }
    }

    protected void performSearch() {
        if (this.type == SHOW_SEPARATE) {
            this.searchFilters();
            this.searchFilterTrees();
        } else if (this.type == SHOW_TOGETHER) {
            this.searchCompound();
        } else if (this.type == SHOW_TREES) {
            this.searchFilterTrees();
        } else {
            this.searchFilters();
        }
    }

    public Filter getSelectedFilter() {
        return FilterManager.defaultManager().getFilter((String)this.compoundList.getSelectedValue());
    }

    public Filter[] getSelectedFilters() {
        if (this.type == SHOW_SEPARATE) {
            Object[] selected_filters = this.filterList.getSelectedValues();
            Object[] selected_filtertrees = this.filterTreeList.getSelectedValues();
            Filter[] filters = new Filter[selected_filters.length + selected_filtertrees.length];
            int i = 0;
            for (i = 0; i < selected_filters.length; ++i) {
                filters[i] = FilterManager.defaultManager().getFilter((String)selected_filters[i]);
            }
            for (int j = 0; j < selected_filtertrees.length; ++j) {
                filters[i] = FilterManager.defaultManager().getFilter((String)selected_filtertrees[i]);
                ++i;
            }
            return filters;
        }
        if (this.type == SHOW_TOGETHER) {
            Object[] selected_filters = this.compoundList.getSelectedValues();
            Filter[] filters = new Filter[selected_filters.length];
            int i = 0;
            for (i = 0; i < selected_filters.length; ++i) {
                filters[i] = FilterManager.defaultManager().getFilter((String)selected_filters[i]);
            }
            return filters;
        }
        if (this.type == SHOW_TREES) {
            Object[] selected_filters = this.filterTreeList.getSelectedValues();
            Filter[] filters = new Filter[selected_filters.length];
            int i = 0;
            for (i = 0; i < selected_filters.length; ++i) {
                filters[i] = FilterManager.defaultManager().getFilter((String)selected_filters[i]);
            }
            return filters;
        }
        Object[] selected_filters = this.filterList.getSelectedValues();
        Filter[] filters = new Filter[selected_filters.length];
        int i = 0;
        for (i = 0; i < selected_filters.length; ++i) {
            filters[i] = FilterManager.defaultManager().getFilter((String)selected_filters[i]);
        }
        return filters;
    }

    protected void searchFilters() {
        ArrayList<String> filters_pass = new ArrayList<String>();
        Enumeration filter_enum = this.filterModel.elements();
        String[] pattern = this.searchField.getText().split("\\s");
        while (filter_enum.hasMoreElements()) {
            String s = (String)filter_enum.nextElement();
            for (int p = 0; p < pattern.length; ++p) {
                if (!Strings.isLike((String)s.toString(), (String)pattern[p], (int)0, (boolean)true)) continue;
                filters_pass.add(s);
            }
        }
        Iterator fpi = filters_pass.iterator();
        DefaultListModel filter_passed_model = new DefaultListModel();
        while (fpi.hasNext()) {
            filter_passed_model.addElement(fpi.next());
        }
        this.filterList.setModel(filter_passed_model);
    }

    protected void searchFilterTrees() {
        ArrayList<String> filters_pass = new ArrayList<String>();
        Enumeration filter_enum = this.filterTreeModel.elements();
        String[] pattern = this.searchField.getText().split("\\s");
        while (filter_enum.hasMoreElements()) {
            String s = (String)filter_enum.nextElement();
            for (int p = 0; p < pattern.length; ++p) {
                if (!Strings.isLike((String)s.toString(), (String)pattern[p], (int)0, (boolean)true)) continue;
                filters_pass.add(s);
            }
        }
        Iterator fpi = filters_pass.iterator();
        DefaultListModel filter_passed_model = new DefaultListModel();
        while (fpi.hasNext()) {
            filter_passed_model.addElement(fpi.next());
        }
        this.filterTreeList.setModel(filter_passed_model);
    }

    protected void searchCompound() {
        ArrayList<String> filters_pass = new ArrayList<String>();
        Enumeration filter_enum = this.compoundModel.elements();
        String[] pattern = this.searchField.getText().split("\\s");
        while (filter_enum.hasMoreElements()) {
            String s = (String)filter_enum.nextElement();
            for (int p = 0; p < pattern.length; ++p) {
                if (!Strings.isLike((String)s.toString(), (String)pattern[p], (int)0, (boolean)true)) continue;
                filters_pass.add(s);
            }
        }
        Iterator fpi = filters_pass.iterator();
        DefaultListModel filter_passed_model = new DefaultListModel();
        while (fpi.hasNext()) {
            filter_passed_model.addElement(fpi.next());
        }
        this.compoundList.setModel(filter_passed_model);
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.updateLists();
    }

    protected void updateLists() {
        if (this.type == SHOW_SEPARATE) {
            this.updateFilters();
            this.updateFilterTrees();
        } else if (this.type == SHOW_TOGETHER) {
            this.updateCompound();
        } else if (this.type == SHOW_TREES) {
            this.updateFilterTrees();
        } else {
            this.updateFilters();
        }
    }

    protected void updateFilters() {
        Set filters = FilterManager.defaultManager().getFilters(false);
        this.filterModel = new DefaultListModel();
        this.filterModel.ensureCapacity(filters.size());
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            this.filterModel.addElement((String)i.next());
        }
        this.filterList.setModel(this.filterModel);
    }

    protected void updateFilterTrees() {
        Set filters = FilterManager.defaultManager().getFilterTrees();
        this.filterTreeModel = new DefaultListModel();
        this.filterTreeModel.ensureCapacity(filters.size());
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            this.filterTreeModel.addElement((String)i.next());
        }
        this.filterTreeList.setModel(this.filterTreeModel);
    }

    protected void updateCompound() {
        Set filters = FilterManager.defaultManager().getFilters(true);
        this.compoundModel = new DefaultListModel();
        this.compoundModel.ensureCapacity(filters.size());
        Iterator i = filters.iterator();
        while (i.hasNext()) {
            this.compoundModel.addElement((String)i.next());
        }
        this.compoundList.setModel(this.compoundModel);
    }
}

