/*
 * Decompiled with CFR 0.152.
 */
package filter.view;

import filter.model.Filter;
import filter.model.FilterManager;
import filter.view.FilterEditor;
import filter.view.FilterListPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class FilterEditorPanel
extends JPanel
implements PropertyChangeListener,
ActionListener {
    JTabbedPane editorTabs;
    Map editorIndexMap;
    int editorCount;
    protected JButton addButton;
    protected JButton removeButton;
    protected JButton resetButton;

    public FilterEditorPanel() {
        this.initialize();
    }

    public void initialize() {
        this.editorIndexMap = new HashMap();
        this.editorCount = 0;
        this.editorTabs = new JTabbedPane();
        this.add(this.editorTabs);
        Iterator i = FilterManager.defaultManager().getEditors();
        while (i.hasNext()) {
            FilterEditor fe = (FilterEditor)i.next();
            this.addEditor(fe);
        }
        FilterManager.defaultManager().getSwingPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public void addEditor(FilterEditor new_editor) {
        this.editorIndexMap.put(new_editor.getFilterID(), new Integer(this.editorCount));
        this.editorTabs.insertTab(new_editor.toString(), null, new_editor, new_editor.toString(), this.editorCount);
        ++this.editorCount;
    }

    public void setEditorActive(String name) {
        int index = (Integer)this.editorIndexMap.get(name);
        this.editorTabs.setSelectedIndex(index);
    }

    public FilterEditor getSelectedEditor() {
        return (FilterEditor)this.editorTabs.getSelectedComponent();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == FilterManager.EDITOR_ADDED) {
            this.addEditor((FilterEditor)e.getNewValue());
        } else if (e.getPropertyName() == FilterListPanel.FILTER_SELECTED) {
            Filter f = FilterManager.defaultManager().getFilter((String)e.getNewValue());
            if (f == null) {
                return;
            }
            this.setEditorActive(f.getFilterID());
            FilterEditor fe = (FilterEditor)this.editorTabs.getSelectedComponent();
            fe.editFilter(f);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            FilterManager.defaultManager().addFilter(this.getSelectedEditor().getFilter());
        }
        if (e.getSource() == this.removeButton) {
            FilterManager.defaultManager().removeFilter(this.getSelectedEditor().getFilter());
            this.getSelectedEditor().clear();
        }
        if (e.getSource() == this.resetButton) {
            FilterManager.defaultManager().removeFilter(this.getSelectedEditor().getFilter());
            this.getSelectedEditor().reset();
        }
    }
}

