/*
 * Decompiled with CFR 0.152.
 */
package filter.view;

import filter.model.DefaultFilter;
import filter.model.Filter;
import filter.view.FilterEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DefaultFilterEditor
extends FilterEditor
implements ActionListener {
    protected String identifier = "Default";
    protected JTextField searchField;
    protected JTextField nameField;
    protected String searchString;
    protected DefaultFilter filter;
    protected String DEFAULT_SEARCH_STRING = "";
    protected String RESET_SEARCH_STRING;
    protected String DEFAULT_FILTER_NAME = "toString Match: ";
    protected String RESET_FITLER_NAME;

    public DefaultFilterEditor() {
        this.setBorder(new TitledBorder("Simple String Filter"));
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(15);
        namePanel.add(new JLabel("Filter Name"));
        namePanel.add(this.nameField);
        this.add(namePanel);
        this.searchField = new JTextField(30);
        this.add(new JLabel("Search Field"));
        this.add(this.searchField);
        this.setDefaults();
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return DefaultFilter.FILTER_ID;
    }

    public Filter getFilter() {
        if (this.searchField.getText() == null || this.nameField.getText() == null) {
            return null;
        }
        return new DefaultFilter(this.searchField.getText(), this.nameField.getText());
    }

    public void editFilter(Filter filter) {
        if (filter instanceof DefaultFilter) {
            this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
            this.filter = (DefaultFilter)filter;
            this.readInFilter();
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filter);
        }
    }

    public void reset() {
        if (this.filter == null) {
            this.setDefaults();
        } else {
            this.resetFilter();
        }
    }

    public void clear() {
        this.filter = null;
        this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
        this.setDefaults();
    }

    public String getSearchString() {
        return this.searchField.getText();
    }

    public void setSearchString(String search_string) {
        this.searchField.setText(search_string);
    }

    public String getFilterName() {
        return this.nameField.getText();
    }

    public void setFilterName(String name) {
        this.nameField.setText(name);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.searchField) {
            this.fireSearchStringChanged();
        } else if (e.getSource() == this.nameField) {
            this.fireFilterNameChanged();
        }
    }

    public void fireSearchStringChanged() {
        this.pcs.firePropertyChange(DefaultFilter.SEARCH_STRING_EVENT, null, this.searchField.getText());
    }

    public void fireFilterNameChanged() {
        this.pcs.firePropertyChange(DefaultFilter.FILTER_NAME_EVENT, null, this.nameField.getText());
    }

    public void setDefaults() {
        this.searchField.setText(this.DEFAULT_SEARCH_STRING);
        this.nameField.setText(this.DEFAULT_FILTER_NAME);
    }

    public void readInFilter() {
        this.RESET_SEARCH_STRING = this.filter.getSearchString();
        this.RESET_FITLER_NAME = this.filter.toString();
        this.resetFilter();
    }

    public void resetFilter() {
        this.setSearchString(this.RESET_SEARCH_STRING);
        this.fireSearchStringChanged();
        this.setFilterName(this.RESET_FITLER_NAME);
        this.fireFilterNameChanged();
    }
}

