/*
 * Decompiled with CFR 0.152.
 */
package filter.model;

import filter.model.Filter;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class FilterNode
extends DefaultMutableTreeNode
implements Filter {
    public static int CHILDREN_ARE_AND = 0;
    public static int CHILDREN_ARE_OR = 1;
    public static int CHILDREN_ARE_XOR = 2;
    private int childrenType = CHILDREN_ARE_AND;
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public FilterNode(int children_type, Filter filter) {
        super(filter);
        this.childrenType = children_type;
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public String getEditorName() {
        return "Node";
    }

    public int getChildrenType() {
        return this.childrenType;
    }

    public void setChildrenType(int type) {
        this.childrenType = type;
    }

    public void add(FilterNode child) {
        super.add(child);
    }

    public String toString() {
        return ((Object)this.getFilter()).toString();
    }

    public String getFilterID() {
        return ((Object)this.getFilter()).toString();
    }

    public Object clone() {
        return super.clone();
    }

    public Class[] getPassingTypes() {
        return this.getFilter().getPassingTypes();
    }

    public boolean equals(Object other_object) {
        return other_object instanceof FilterNode && ((FilterNode)other_object).getChildrenType() == this.getChildrenType() && ((FilterNode)other_object).getFilter() == this.getFilter();
    }

    public Filter getFilter() {
        return (Filter)this.getUserObject();
    }

    public Filter setFilter(Filter new_filter) {
        Filter old_filter = this.getFilter();
        this.setUserObject(new_filter);
        return old_filter;
    }

    public boolean passesFilterNode(Object o) {
        return this.passesFilter(o);
    }

    public boolean passesFilter(Object o) {
        boolean my_result = this.getFilter().passesFilter(o);
        if (this.childrenType == CHILDREN_ARE_AND) {
            if (!my_result) {
                return false;
            }
            if (my_result && this.getChildCount() == 0) {
                return true;
            }
            return this.passesChildren(o);
        }
        if (this.childrenType == CHILDREN_ARE_OR) {
            if (my_result) {
                return true;
            }
            return this.passesChildren(o);
        }
        if (this.childrenType == CHILDREN_ARE_XOR) {
            boolean children_pass = this.passesChildren(o);
            if (my_result && !children_pass) {
                return true;
            }
            if (my_result && children_pass) {
                return false;
            }
            return !my_result && children_pass;
        }
        return false;
    }

    public boolean passesChildren(Object o) {
        if (this.getChildCount() == 0) {
            return false;
        }
        Enumeration<TreeNode> children = this.children();
        if (this.childrenType == CHILDREN_ARE_AND) {
            boolean child_passed = true;
            while (child_passed && children.hasMoreElements()) {
                FilterNode node = (FilterNode)children.nextElement();
                child_passed = node.passesFilterNode(o);
            }
            return child_passed;
        }
        if (this.childrenType == CHILDREN_ARE_XOR) {
            boolean child_passed = false;
            while (children.hasMoreElements()) {
                FilterNode node = (FilterNode)children.nextElement();
                boolean passed_node = node.passesFilterNode(o);
                if (child_passed && passed_node) {
                    return false;
                }
                child_passed = passed_node;
            }
            return child_passed;
        }
        if (this.childrenType == CHILDREN_ARE_OR) {
            boolean child_passed = false;
            while (!child_passed && children.hasMoreElements()) {
                FilterNode node = (FilterNode)children.nextElement();
                if (!node.passesFilterNode(o)) continue;
                return true;
            }
            return child_passed;
        }
        return false;
    }

    public String output() {
        return null;
    }

    public Filter input(String desc) {
        return null;
    }
}

