/*
 * Decompiled with CFR 0.152.
 */
package filter.model;

import filter.cytoscape.BooleanMetaFilter;
import filter.cytoscape.InteractionFilter;
import filter.cytoscape.NodeTopologyFilter;
import filter.cytoscape.NumericAttributeFilter;
import filter.cytoscape.StringPatternFilter;
import filter.model.Filter;
import filter.view.FilterEditor;
import filter.view.FilterTree;
import filter.view.FilterView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.event.SwingPropertyChangeSupport;

public class FilterManager {
    protected static FilterManager DEFAULT_MANAGER;
    protected static FilterView DEFAULT_VIEW;
    protected static JDialog VIEW_DIALOG;
    public static String FILTER_EVENT;
    public static String EDITOR_ADDED;
    public static String EDITOR_EVENT;
    protected Map filterTreeMap;
    protected Map filterMap;
    protected Map editorMap;
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public static FilterManager defaultManager() {
        if (DEFAULT_MANAGER == null) {
            DEFAULT_MANAGER = new FilterManager();
        }
        return DEFAULT_MANAGER;
    }

    private FilterManager() {
        this.filterMap = new HashMap();
        this.filterTreeMap = new HashMap();
        this.editorMap = new HashMap();
    }

    public static FilterView defaultView() {
        if (DEFAULT_VIEW == null) {
            VIEW_DIALOG = new JDialog();
            DEFAULT_VIEW = new FilterView();
            VIEW_DIALOG.getContentPane().add(DEFAULT_VIEW);
        }
        return DEFAULT_VIEW;
    }

    public static void showFilterView() {
        VIEW_DIALOG.show();
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void fireFilterEvent() {
        this.pcs.firePropertyChange(FILTER_EVENT, null, null);
    }

    public void fireEditorEvent() {
        this.pcs.firePropertyChange(EDITOR_EVENT, null, null);
    }

    public boolean addEditor(FilterEditor editor) {
        if (this.editorExists(editor.getFilterID())) {
            return false;
        }
        this.editorMap.put(editor.toString(), editor);
        this.pcs.firePropertyChange(EDITOR_ADDED, null, editor);
        return true;
    }

    public boolean editorExists(String name) {
        return this.editorMap.get(name) != null;
    }

    public FilterEditor getEditor(String name) {
        return (FilterEditor)this.editorMap.get(name);
    }

    public void removeEditor(String name) {
        this.editorMap.remove(name);
        this.fireEditorEvent();
    }

    public Iterator getEditors() {
        ArrayList editor_list = new ArrayList();
        Set keys = this.editorMap.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            editor_list.add(this.editorMap.get(i.next()));
        }
        return editor_list.iterator();
    }

    public boolean filterExists(String name) {
        return this.filterMap.get(name) != null || this.filterTreeMap.get(name) != null;
    }

    public boolean filterTreeExists(String name) {
        return this.filterTreeMap.get(name) != null;
    }

    public Set getFilters(boolean include_trees) {
        if (include_trees) {
            HashSet filters = new HashSet(this.filterMap.keySet());
            Set tree_filters = this.filterTreeMap.keySet();
            Iterator tfi = tree_filters.iterator();
            while (tfi.hasNext()) {
                filters.add(tfi.next());
            }
            return filters;
        }
        return this.filterMap.keySet();
    }

    public Set getFilterTrees() {
        return this.filterTreeMap.keySet();
    }

    public boolean addFilterTree(FilterTree tree) {
        if (this.filterTreeExists(tree.toString())) {
            return false;
        }
        this.filterTreeMap.put(tree.toString(), tree);
        this.fireFilterEvent();
        return true;
    }

    public boolean addFilter(Filter filter) {
        if (filter == null) {
            return false;
        }
        this.filterMap.put(((Object)filter).toString(), filter);
        this.fireFilterEvent();
        return true;
    }

    public FilterTree getFilterTree(String name) {
        return (FilterTree)this.filterTreeMap.get(name);
    }

    public Filter getFilter(String name) {
        if (this.filterTreeExists(name)) {
            return (Filter)this.filterTreeMap.get(name);
        }
        return (Filter)this.filterMap.get(name);
    }

    public void renameFilter(String old_name, String new_name) {
        Filter f = this.getFilter(old_name);
        this.removeFilter(old_name);
        this.addFilter(f);
    }

    public void removeFilter(String name) {
        this.filterMap.remove(name);
        this.fireFilterEvent();
    }

    public void removeFilter(Filter f) {
        this.filterMap.remove(((Object)f).toString());
        this.fireFilterEvent();
    }

    public void removeFilterTree(String name) {
        this.filterTreeMap.remove(name);
        this.fireFilterEvent();
    }

    public Filter createFilterFromString(String desc) {
        String[] array = desc.split(",");
        if (array[0].equals("filter.cytoscape.StringPatternFilter")) {
            StringPatternFilter new_filter = new StringPatternFilter(array[1], array[2], array[3], array[4]);
            this.addFilter(new_filter);
            return new_filter;
        }
        if (array[0].equals("filter.cytoscape.NumericAttributeFilter")) {
            NumericAttributeFilter new_filter = new NumericAttributeFilter(array[1], array[2], array[3], array[4], array[5]);
            this.addFilter(new_filter);
            return new_filter;
        }
        if (array[0].equals("filter.cytoscape.NodeTopologyFilter")) {
            NodeTopologyFilter new_filter = new NodeTopologyFilter(array[1], array[2], array[3], array[4]);
            this.addFilter(new_filter);
            return new_filter;
        }
        if (array[0].equals("filter.cytoscape.BooleanMetaFilter")) {
            BooleanMetaFilter new_filter = new BooleanMetaFilter(array[1], array[2], array[3]);
            this.addFilter(new_filter);
            return new_filter;
        }
        if (array[0].equals("filter.cytoscape.InteractionFilter")) {
            InteractionFilter new_filter = new InteractionFilter(array[1], array[2], array[3]);
            this.addFilter(new_filter);
            return new_filter;
        }
        return null;
    }

    static {
        FILTER_EVENT = "FILTER_EVENT";
        EDITOR_ADDED = "EDITOR_ADDED";
        EDITOR_EVENT = "EDITOR_EVENT";
    }
}

