/*
 * Decompiled with CFR 0.152.
 */
package filter.model;

import ViolinStrings.Strings;
import filter.model.Filter;
import filter.model.FilterManager;
import java.beans.PropertyChangeEvent;
import javax.swing.event.SwingPropertyChangeSupport;

public class DefaultFilter
implements Filter {
    protected String searchString;
    protected String identifier = "default";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    public static String SEARCH_STRING_EVENT = "SEARCH_STRING_EVENT";
    public static String FILTER_NAME_EVENT = "FILTER_NAME_EVENT";
    public static String FILTER_ID = "DefaultFilter";

    public DefaultFilter() {
    }

    public DefaultFilter(String search_string, String identifier) {
        this.searchString = search_string;
        this.identifier = identifier;
    }

    public DefaultFilter(String search_string) {
        this.searchString = search_string;
        this.identifier = "default";
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public void setIdentifier(String new_id) {
        FilterManager.defaultManager().renameFilter(this.identifier, new_id);
        this.identifier = new_id;
    }

    public String getEditorName() {
        return "Default";
    }

    public boolean passesFilter(Object object) {
        String object_string = object.toString();
        String[] pattern = this.searchString.split("\\s");
        for (int p = 0; p < pattern.length; ++p) {
            if (!Strings.isLike((String)object_string, (String)pattern[p], (int)0, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public Class[] getPassingTypes() {
        return null;
    }

    public boolean equals(Object other_object) {
        return other_object instanceof DefaultFilter && ((DefaultFilter)other_object).getSearchString().equals(this.getSearchString());
    }

    public Object clone() {
        return new DefaultFilter(this.searchString);
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == SEARCH_STRING_EVENT) {
            this.setSearchString((String)e.getNewValue());
        } else if (e.getPropertyName() == FILTER_NAME_EVENT) {
            this.setIdentifier((String)e.getNewValue());
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String search_string) {
        this.searchString = search_string;
    }

    public void fireSearchStringChanged() {
        this.pcs.firePropertyChange("FILTER_MODIFIED", null, this.searchString);
    }

    public String output() {
        return null;
    }

    public Filter input(String desc) {
        return null;
    }
}

