/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape.network;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import filter.model.Filter;
import filter.view.FilterListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class NetworkManagement
extends JFrame
implements ActionListener,
PropertyChangeListener {
    FilterListPanel filterListPanel;
    JTextArea nodeListArea;
    JComboBox networkBox;
    JTextField newNetworkField;
    JRadioButton append;
    JRadioButton create;
    JRadioButton addNodes;
    JRadioButton removeNodes;
    JTextField fileField;
    JButton browse;
    JButton filterApply;
    JButton listApply;
    JButton fileApply;
    Map titleIdMap;

    public NetworkManagement() {
        super("Network +/-");
        this.initialize();
    }

    protected void initialize() {
        this.titleIdMap = new HashMap();
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        JPanel main_panel = new JPanel();
        main_panel.setLayout(new BorderLayout());
        JPanel top_panel = new JPanel();
        JPanel add_to_panel = new JPanel();
        add_to_panel.setLayout(new BorderLayout());
        this.append = new JRadioButton("Append to:");
        this.append.setSelected(true);
        this.networkBox = this.getNetworkBox();
        this.networkBox.setMaximumSize(new Dimension(15, (int)this.networkBox.getPreferredSize().getHeight()));
        add_to_panel.add((Component)this.append, "North");
        add_to_panel.add((Component)this.networkBox, "Center");
        add_to_panel.setBorder(new TitledBorder(""));
        JPanel add_remove_panel = new JPanel();
        ButtonGroup add_remove = new ButtonGroup();
        this.addNodes = new JRadioButton("Add Nodes");
        this.addNodes.setSelected(true);
        this.removeNodes = new JRadioButton("RemoveNodes");
        add_remove.add(this.addNodes);
        add_remove.add(this.removeNodes);
        add_remove_panel.add(this.addNodes);
        add_remove_panel.add(this.removeNodes);
        JPanel create_new_panel = new JPanel();
        create_new_panel.setLayout(new BorderLayout());
        this.create = new JRadioButton("Create new Network:");
        this.newNetworkField = new JTextField(10);
        create_new_panel.add((Component)this.create, "North");
        create_new_panel.add((Component)this.newNetworkField, "Center");
        create_new_panel.setBorder(new TitledBorder(""));
        top_panel.add(add_to_panel);
        top_panel.add(create_new_panel);
        main_panel.add((Component)top_panel, "North");
        ButtonGroup group = new ButtonGroup();
        group.add(this.append);
        group.add(this.create);
        JPanel tab_panel = new JPanel();
        tab_panel.setLayout(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        tab_panel.add((Component)tabs, "Center");
        tab_panel.add((Component)add_remove_panel, "South");
        JPanel filter = new JPanel();
        filter.setLayout(new BorderLayout());
        filter.setBorder(new TitledBorder("Filter"));
        filter.add((Component)new JLabel("All Nodes that match the selected Filter."), "North");
        this.filterListPanel = new FilterListPanel(1);
        filter.add((Component)this.filterListPanel, "Center");
        this.filterApply = new JButton("Apply");
        this.filterApply.addActionListener(this);
        filter.add((Component)this.filterApply, "South");
        tabs.addTab("Filter", filter);
        JPanel list = new JPanel();
        list.setLayout(new BorderLayout());
        list.setBorder(new TitledBorder("List"));
        list.add((Component)new JLabel("All Nodes that are in this list."), "North");
        this.nodeListArea = new JTextArea(7, 15);
        JScrollPane scroll = new JScrollPane(this.nodeListArea);
        list.add((Component)scroll, "Center");
        this.listApply = new JButton("Apply");
        this.listApply.addActionListener(this);
        list.add((Component)this.listApply, "South");
        tabs.addTab("List", list);
        JPanel file = new JPanel();
        file.setLayout(new BorderLayout());
        file.setBorder(new TitledBorder("File"));
        file.add((Component)new JLabel("All Nodes that are in this File."), "North");
        JPanel browse_panel = new JPanel();
        this.fileField = new JTextField(13);
        browse_panel.add(this.fileField);
        this.browse = new JButton("Browse");
        this.browse.addActionListener(this);
        browse_panel.add(this.browse);
        file.add((Component)browse_panel, "Center");
        this.fileApply = new JButton("Apply");
        this.fileApply.addActionListener(this);
        file.add((Component)this.fileApply, "South");
        tabs.addTab("File", file);
        main_panel.add((Component)tab_panel, "South");
        this.setContentPane(main_panel);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.filterApply) {
            this.getMatchingNodes("filter");
        } else if (e.getSource() == this.listApply) {
            this.getMatchingNodes("list");
        } else if (e.getSource() == this.fileApply) {
            this.getMatchingNodes("file");
        } else if (e.getSource() == this.browse) {
            File currentDirectory = Cytoscape.getCytoscapeObj().getCurrentDirectory();
            JFileChooser fChooser = new JFileChooser(currentDirectory);
            fChooser.setDialogTitle("Load Node File");
            switch (fChooser.showOpenDialog((Component)Cytoscape.getDesktop())) {
                case 0: {
                    this.fileField.setText(fChooser.getSelectedFile().getAbsolutePath());
                    currentDirectory = fChooser.getCurrentDirectory();
                    Cytoscape.getCytoscapeObj().setCurrentDirectory(currentDirectory);
                }
            }
        }
    }

    protected void getMatchingNodes(String function) {
        CyNode node;
        Iterator edges_i = Cytoscape.getRootGraph().edgesList().iterator();
        Iterator nodes_i = Cytoscape.getRootGraph().nodesList().iterator();
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        HashSet<CyEdge> edges = new HashSet<CyEdge>();
        if (function.equals("filter") && this.filterListPanel.getSelectedFilter() != null) {
            Filter filter = this.filterListPanel.getSelectedFilter();
            while (edges_i.hasNext()) {
                CyEdge edge = (CyEdge)edges_i.next();
                try {
                    if (!filter.passesFilter(edge)) continue;
                    edges.add(edge);
                }
                catch (StackOverflowError soe) {
                    return;
                }
            }
            while (nodes_i.hasNext()) {
                node = (CyNode)nodes_i.next();
                try {
                    if (!filter.passesFilter(node)) continue;
                    nodes.add(node);
                }
                catch (StackOverflowError soe) {
                    return;
                }
            }
        } else if (function.equals("list")) {
            String node_list = this.nodeListArea.getText();
            String[] list_array = node_list.split("[ \n\t\r]");
            for (int i = 0; i < list_array.length; ++i) {
                node = Cytoscape.getCyNode((String)list_array[i], (boolean)false);
                if (node == null) continue;
                nodes.add(node);
            }
        } else if (function.equals("file")) {
            File file = new File(this.fileField.getText());
            try {
                String s;
                FileReader fin = new FileReader(file);
                BufferedReader bin = new BufferedReader(fin);
                while ((s = bin.readLine()) != null) {
                    String trimName = s.trim();
                    node = Cytoscape.getCyNode((String)s, (boolean)false);
                    if (node == null) continue;
                    nodes.add(node);
                }
                fin.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        CyNode[] node_array = nodes.toArray(new CyNode[0]);
        for (int i = 0; i < node_array.length; ++i) {
            System.out.println(node_array[i].getIdentifier());
        }
        this.operateOnNetwork(new ArrayList(nodes), true, new ArrayList(edges));
    }

    protected void operateOnNetwork(List nodes, boolean restore_incident_edges, List edges) {
        if (this.append.isSelected() && this.addNodes.isSelected()) {
            String network_id = (String)this.titleIdMap.get(this.networkBox.getSelectedItem());
            if (network_id == null && this.networkBox.getSelectedItem().equals("Current Network")) {
                Cytoscape.getCurrentNetwork().restoreNodes(nodes, restore_incident_edges);
                Cytoscape.getCurrentNetwork().restoreEdges(edges);
            }
            Cytoscape.getNetwork((String)network_id).restoreNodes(nodes, restore_incident_edges);
            Cytoscape.getNetwork((String)network_id).restoreEdges(edges);
        } else if (this.append.isSelected() && this.removeNodes.isSelected()) {
            String network_id = (String)this.titleIdMap.get(this.networkBox.getSelectedItem());
            if (network_id == null && this.networkBox.getSelectedItem().equals("Current Network")) {
                Cytoscape.getCurrentNetwork().hideNodes(nodes);
                Cytoscape.getCurrentNetwork().hideEdges(edges);
            }
            Cytoscape.getNetwork((String)network_id).hideNodes(nodes);
            Cytoscape.getNetwork((String)network_id).hideEdges(edges);
        } else {
            String network_title = this.newNetworkField.getText();
            CyNetwork network = Cytoscape.createNetwork((String)network_title);
            network.restoreNodes(nodes, restore_incident_edges);
            network.restoreEdges(edges);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals(Cytoscape.NETWORK_CREATED) || e.getPropertyName().equals(Cytoscape.NETWORK_DESTROYED)) {
            this.updateNetworkBox();
        }
    }

    protected void updateNetworkBox() {
        Iterator i = Cytoscape.getNetworkSet().iterator();
        Vector<String> vector = new Vector<String>();
        vector.add("Current Network");
        while (i.hasNext()) {
            CyNetwork net = Cytoscape.getNetwork((String)((String)i.next()));
            this.titleIdMap.put(net.getTitle(), net.getIdentifier());
            vector.add(net.getTitle());
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(vector);
        this.networkBox.setModel(model);
    }

    protected JComboBox getNetworkBox() {
        Iterator i = Cytoscape.getNetworkSet().iterator();
        Vector<String> vector = new Vector<String>();
        vector.add("Current Network");
        while (i.hasNext()) {
            CyNetwork net = Cytoscape.getNetwork((String)((String)i.next()));
            this.titleIdMap.put(net.getTitle(), net.getIdentifier());
            vector.add(net.getTitle());
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(vector);
        return new JComboBox(model);
    }
}

