/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape.network;

import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.browsers.TabbedBrowser;
import cytoscape.util.Misc;
import filter.model.Filter;
import filter.view.FilterListPanel;
import giny.model.Edge;
import giny.model.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FilterBrowserSelection
extends JFrame
implements ActionListener {
    JButton dispayAttributes;
    FilterListPanel filterListPanel;
    static final String invisibilityPropertyName = "nodeAttributeCategories.invisibleToBrowser";

    public FilterBrowserSelection() {
        super("Filter Browser Selection");
        this.initialize();
    }

    protected void initialize() {
        JPanel main_panel = new JPanel();
        this.dispayAttributes = new JButton("Broswer");
        this.dispayAttributes.addActionListener(this);
        this.filterListPanel = new FilterListPanel(1);
        main_panel.setLayout(new BorderLayout());
        main_panel.add((Component)this.filterListPanel, "Center");
        main_panel.add((Component)this.dispayAttributes, "South");
        this.setContentPane(main_panel);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Filter filter = this.filterListPanel.getSelectedFilter();
        Iterator nodes_i = Cytoscape.getRootGraph().nodesList().iterator();
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        while (nodes_i.hasNext()) {
            CyNode node = (CyNode)nodes_i.next();
            try {
                if (!filter.passesFilter(node)) continue;
                nodes.add(node);
            }
            catch (StackOverflowError soe) {
                return;
            }
        }
        Iterator edges_i = Cytoscape.getRootGraph().edgesList().iterator();
        HashSet<CyEdge> edges = new HashSet<CyEdge>();
        while (edges_i.hasNext()) {
            CyEdge edge = (CyEdge)edges_i.next();
            try {
                if (!filter.passesFilter(edge)) continue;
                edges.add(edge);
            }
            catch (StackOverflowError soe) {
                return;
            }
        }
        Properties configProps = Cytoscape.getCytoscapeObj().getConfiguration().getProperties();
        Vector attributeCategoriesToIgnore = Misc.getPropertyValues((Properties)configProps, (String)invisibilityPropertyName);
        String webBrowserScript = configProps.getProperty("webBrowserScript", "noScriptDefined");
        TabbedBrowser nodeBrowser = null;
        TabbedBrowser edgeBrowser = null;
        Object[] selectedNodes = nodes.toArray(new Node[0]);
        Object[] selectedEdges = edges.toArray(new Edge[0]);
        if (selectedNodes.length > 0) {
            nodeBrowser = new TabbedBrowser(selectedNodes, Cytoscape.getNodeNetworkData(), attributeCategoriesToIgnore, webBrowserScript, 1);
        }
        if (selectedEdges.length > 0) {
            edgeBrowser = new TabbedBrowser(selectedEdges, Cytoscape.getEdgeNetworkData(), attributeCategoriesToIgnore, webBrowserScript, 2);
        }
    }
}

