/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.data.GraphObjAttributes;
import cytoscape.view.CyWindow;
import filter.cytoscape.StringPatternFilter;
import filter.model.Filter;
import filter.view.FilterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class StringPatternFilterEditor
extends FilterEditor
implements ActionListener {
    protected String identifier;
    protected JTextField nameField;
    protected JComboBox classBox;
    protected JTextField searchField;
    protected JComboBox attributeBox;
    protected String searchString;
    protected String selectedAttribute;
    protected StringPatternFilter filter;
    protected CyWindow cyWindow;
    protected String DEFAULT_SEARCH_STRING = "";
    protected String RESET_SEARCH_STRING;
    protected String DEFAULT_FILTER_NAME = "Regex: ";
    protected String RESET_FITLER_NAME;
    protected String DEFAULT_SELECTED_ATTRIBUTE = "";
    protected String RESET_SELECTED_ATTRIBUTE;
    protected String RESET_CLASS;
    protected Class NODE_CLASS;
    protected Class EDGE_CLASS;
    protected Class STRING_CLASS;
    protected String DEFAULT_CLASS = StringPatternFilter.NODE;

    public StringPatternFilterEditor(CyWindow cyWindow) {
        this.cyWindow = cyWindow;
        try {
            this.STRING_CLASS = Class.forName("java.lang.String");
            this.NODE_CLASS = Class.forName("giny.model.Node");
            this.EDGE_CLASS = Class.forName("giny.model.Edge");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.identifier = "String Filter";
        this.setBorder(new TitledBorder("String Filter - Select nodes or edges based on regular expression match to text attribute"));
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(15);
        namePanel.add(new JLabel("Filter Name"));
        namePanel.add(this.nameField);
        this.add((Component)namePanel, "North");
        JPanel all_panel = new JPanel();
        all_panel.setLayout(new GridLayout(3, 1));
        JPanel topPanel = new JPanel();
        topPanel.add(new JLabel("Select graph objects of type "));
        this.classBox = new JComboBox();
        this.classBox.addItem(StringPatternFilter.NODE);
        this.classBox.addItem(StringPatternFilter.EDGE);
        this.classBox.setEditable(false);
        this.classBox.addActionListener(this);
        topPanel.add(this.classBox);
        JPanel middlePanel = new JPanel();
        middlePanel.add(new JLabel(" with a value for text attribute "));
        this.attributeBox = new JComboBox();
        this.attributeBox.setEditable(false);
        this.attributeBox.addActionListener(this);
        middlePanel.add(this.attributeBox);
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(new JLabel(" that matches the regular expression "));
        this.searchField = new JTextField(10);
        this.searchField.setEditable(true);
        this.searchField.addActionListener(this);
        bottomPanel.add(this.searchField);
        all_panel.add(topPanel);
        all_panel.add(middlePanel);
        all_panel.add(bottomPanel);
        this.add((Component)new JButton(new AbstractAction("Update List of Attributes"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).updateAttributeBox();
                    }
                });
            }

            static /* synthetic */ StringPatternFilterEditor access$000(1 x0) {
                return x0.StringPatternFilterEditor.this;
            }
        }), "South");
        this.add((Component)all_panel, "Center");
        this.setDefaults();
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return StringPatternFilter.FILTER_ID;
    }

    public Filter getFilter() {
        this.updateName();
        String search_item = this.getSearchString();
        String attr_item = this.getSelectedAttribute();
        String currentClass = this.getSelectedClass();
        if (currentClass == null || search_item == null || attr_item == null || this.nameField.getText() == null) {
            return null;
        }
        return new StringPatternFilter(this.cyWindow, currentClass, attr_item, search_item, this.nameField.getText());
    }

    public void editFilter(Filter filter) {
        if (filter instanceof StringPatternFilter) {
            this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
            this.filter = (StringPatternFilter)filter;
            this.readInFilter();
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filter);
        }
    }

    public void reset() {
        if (this.filter == null) {
            this.setDefaults();
        } else {
            this.resetFilter();
        }
    }

    public void clear() {
        this.filter = null;
        this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
        this.setDefaults();
    }

    public String getFilterName() {
        return this.nameField.getText();
    }

    public void setFilterName(String name) {
        this.nameField.setText(name);
    }

    public String getSearchString() {
        return this.searchField.getText();
    }

    public void setSearchString(String search_string) {
        this.searchField.setText(search_string);
    }

    public String getSelectedAttribute() {
        if (this.attributeBox.getItemCount() == 0) {
            return null;
        }
        return (String)this.attributeBox.getSelectedItem();
    }

    public void setSelectedAttribute(String new_attr) {
        this.updateAttributeBox();
        this.attributeBox.setSelectedItem(new_attr);
    }

    public String getSelectedClass() {
        return (String)this.classBox.getSelectedItem();
    }

    public void setSelectedClass(String newClass) {
        this.classBox.setSelectedItem(newClass);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.searchField) {
            this.fireSearchStringChanged();
        } else if (e.getSource() == this.nameField) {
            this.fireFilterNameChanged();
        } else if (e.getSource() == this.attributeBox) {
            this.fireAttributeChanged();
        } else if (e.getSource() == this.classBox) {
            this.fireClassChanged();
        }
        this.updateName();
    }

    public void updateName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getSelectedClass() + " : ");
        buffer.append(this.getSelectedAttribute() + " ~ ");
        buffer.append(this.getSearchString());
        this.nameField.setText(buffer.toString());
    }

    public void fireSearchStringChanged() {
        this.pcs.firePropertyChange(StringPatternFilter.SEARCH_STRING_EVENT, null, this.getSearchString());
    }

    public void fireFilterNameChanged() {
        this.pcs.firePropertyChange(StringPatternFilter.FILTER_NAME_EVENT, null, this.nameField.getText());
    }

    public void fireClassChanged() {
        this.updateAttributeBox();
        this.pcs.firePropertyChange(StringPatternFilter.CLASS_TYPE_EVENT, null, this.getSelectedClass());
    }

    public void fireAttributeChanged() {
        String new_attr = this.getSelectedAttribute();
        this.pcs.firePropertyChange(StringPatternFilter.SELECTED_ATTRIBUTE_EVENT, null, this.getSelectedAttribute());
    }

    public void updateAttributeBox() {
        GraphObjAttributes objectAttributes = null;
        String type = this.getSelectedClass();
        objectAttributes = type.equals(StringPatternFilter.NODE) ? this.cyWindow.getNetwork().getNodeAttributes() : this.cyWindow.getNetwork().getEdgeAttributes();
        Object[] attributeNames = objectAttributes.getAttributeNames();
        Arrays.sort(attributeNames);
        Vector<Object> stringAttributes = new Vector<Object>();
        for (int idx = 0; idx < attributeNames.length; ++idx) {
            if (!this.STRING_CLASS.isAssignableFrom(objectAttributes.getClass((String)attributeNames[idx]))) continue;
            stringAttributes.add(attributeNames[idx]);
        }
        this.attributeBox.removeAllItems();
        Iterator attrIt = stringAttributes.iterator();
        while (attrIt.hasNext()) {
            this.attributeBox.addItem(attrIt.next());
        }
        if (this.attributeBox.getItemCount() != 0) {
            this.attributeBox.setSelectedIndex(0);
        }
        this.fireAttributeChanged();
    }

    public void setDefaults() {
        this.setSearchString(this.DEFAULT_SEARCH_STRING);
        this.setFilterName(this.DEFAULT_FILTER_NAME);
        this.setSelectedClass(this.DEFAULT_CLASS);
        this.setSelectedAttribute(this.DEFAULT_SELECTED_ATTRIBUTE);
    }

    public void readInFilter() {
        this.RESET_SEARCH_STRING = this.filter.getSearchString();
        this.RESET_FITLER_NAME = this.filter.toString();
        this.RESET_SELECTED_ATTRIBUTE = this.filter.getSelectedAttribute();
        this.RESET_CLASS = this.filter.getClassType();
        this.resetFilter();
    }

    public void resetFilter() {
        this.setSearchString(this.RESET_SEARCH_STRING);
        this.setFilterName(this.RESET_FITLER_NAME);
        this.setSelectedClass(this.RESET_CLASS);
        this.setSelectedAttribute(this.RESET_SELECTED_ATTRIBUTE);
        this.fireFilterNameChanged();
    }
}

