/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import ViolinStrings.Strings;
import cytoscape.Cytoscape;
import cytoscape.data.GraphObjAttributes;
import cytoscape.view.CyWindow;
import filter.model.Filter;
import filter.model.FilterManager;
import java.beans.PropertyChangeEvent;
import javax.swing.event.SwingPropertyChangeSupport;

public class StringPatternFilter
implements Filter {
    protected String selectedAttribute;
    protected String searchString;
    protected Class classType;
    protected Class NODE_CLASS;
    protected Class EDGE_CLASS;
    public static String NODE = "Node";
    public static String EDGE = "Edge";
    public static String SEARCH_STRING_EVENT = "SEARCH_STRING_EVENT";
    public static String SELECTED_ATTRIBUTE_EVENT = "SELECTED_ATTRIBUTE_EVENT";
    public static String FILTER_NAME_EVENT = "FILTER_NAME_EVENT";
    public static String CLASS_TYPE_EVENT = "CLASS_TYPE";
    public static String FILTER_ID = "StringPatternFilter";
    protected CyWindow cyWindow;
    protected String identifier = "default";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public StringPatternFilter(CyWindow cyWindow, String classString, String selectedAttribute, String searchString, String identifier) {
        this.cyWindow = cyWindow;
        try {
            this.NODE_CLASS = Class.forName("giny.model.Node");
            this.EDGE_CLASS = Class.forName("giny.model.Edge");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.selectedAttribute = selectedAttribute;
        this.searchString = searchString;
        this.identifier = identifier;
        this.setClassType(classString);
    }

    public StringPatternFilter(String classString, String selectedAttribute, String searchString, String identifier) {
        this.cyWindow = Cytoscape.getDesktop();
        try {
            this.NODE_CLASS = Class.forName("giny.model.Node");
            this.EDGE_CLASS = Class.forName("giny.model.Edge");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.selectedAttribute = selectedAttribute;
        this.searchString = searchString;
        this.identifier = identifier;
        this.setClassType(classString);
    }

    public String toString() {
        return this.identifier;
    }

    public void setIdentifier(String new_id) {
        FilterManager.defaultManager().renameFilter(this.identifier, new_id);
        this.identifier = new_id;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public boolean passesFilter(Object object) {
        String value = "";
        if (!this.classType.isInstance(object)) {
            return false;
        }
        GraphObjAttributes objectAttributes = null;
        objectAttributes = this.classType.equals(this.NODE_CLASS) ? Cytoscape.getNodeNetworkData() : Cytoscape.getEdgeNetworkData();
        String name = objectAttributes.getCanonicalName(object);
        if (name == null) {
            return false;
        }
        Object valueObj = objectAttributes.getValue(this.selectedAttribute, name);
        if (valueObj == null) {
            return false;
        }
        value = valueObj.toString();
        String[] pattern = this.searchString.split("\\s");
        for (int p = 0; p < pattern.length; ++p) {
            if (!Strings.isLike((String)value, (String)pattern[p], (int)0, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public Class[] getPassingTypes() {
        return null;
    }

    public boolean equals(Object other_object) {
        return other_object instanceof StringPatternFilter && ((StringPatternFilter)other_object).getSearchString().equals(this.getSearchString());
    }

    public Object clone() {
        return new StringPatternFilter(this.cyWindow, this.getClassType(), this.selectedAttribute, this.searchString, this.identifier + "_new");
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == SEARCH_STRING_EVENT) {
            this.setSearchString((String)e.getNewValue());
        } else if (e.getPropertyName() == FILTER_NAME_EVENT) {
            this.setIdentifier((String)e.getNewValue());
        } else if (e.getPropertyName() == SELECTED_ATTRIBUTE_EVENT) {
            this.setSelectedAttribute((String)e.getNewValue());
        } else if (e.getPropertyName() == CLASS_TYPE_EVENT) {
            this.setClassType((String)e.getNewValue());
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String search_string) {
        this.searchString = search_string;
        this.fireSearchStringChanged();
    }

    public void fireSearchStringChanged() {
        this.pcs.firePropertyChange(SEARCH_STRING_EVENT, null, this.searchString);
    }

    public String getSelectedAttribute() {
        return this.selectedAttribute;
    }

    public void setSelectedAttribute(String new_attr) {
        this.selectedAttribute = new_attr;
        this.fireSelectedAttributeModified();
    }

    public void fireSelectedAttributeModified() {
        this.pcs.firePropertyChange(SELECTED_ATTRIBUTE_EVENT, null, this.selectedAttribute);
    }

    public void setClassType(String classString) {
        this.classType = classString == NODE || classString.equals("Node") ? this.NODE_CLASS : this.EDGE_CLASS;
        this.pcs.firePropertyChange(CLASS_TYPE_EVENT, null, this.classType);
    }

    public String getClassType() {
        if (this.classType == this.NODE_CLASS) {
            return NODE;
        }
        return EDGE;
    }

    public String output() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("filter.cytoscape.StringPatternFilter,");
        buffer.append(this.getClassType() + ",");
        buffer.append(this.getSelectedAttribute() + ",");
        buffer.append(this.getSearchString() + ",");
        buffer.append(this.toString());
        return buffer.toString();
    }

    public Filter input(String desc) {
        String[] array = desc.split(",");
        if (array[0].equals("filter.cytoscape.StringPatternFilter")) {
            System.out.println("Found Filter");
            StringPatternFilter new_filter = new StringPatternFilter(array[1], array[2], array[3], array[4]);
            return new_filter;
        }
        return null;
    }
}

