/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.data.GraphObjAttributes;
import cytoscape.view.CyWindow;
import filter.cytoscape.NumericAttributeFilter;
import filter.model.Filter;
import filter.view.FilterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class NumericAttributeFilterEditor
extends FilterEditor
implements ActionListener {
    protected String identifier;
    protected JTextField nameField;
    protected JComboBox classBox;
    protected JTextField searchField;
    protected JComboBox attributeBox;
    protected JComboBox comparisonBox;
    protected Number searchNumber;
    protected String selectedAttribute;
    protected NumericAttributeFilter filter;
    protected CyWindow cyWindow;
    protected Number DEFAULT_SEARCH_NUMBER = new Double(0.0);
    protected Number RESET_SEARCH_NUMBER;
    protected String DEFAULT_FILTER_NAME = "Numeric: ";
    protected String RESET_FITLER_NAME;
    protected String DEFAULT_SELECTED_ATTRIBUTE = "";
    protected String RESET_SELECTED_ATTRIBUTE;
    protected String DEFAULT_COMPARISON = NumericAttributeFilter.EQUAL;
    protected String RESET_COMPARISON = "";
    protected String RESET_CLASS;
    protected Class NODE_CLASS;
    protected Class EDGE_CLASS;
    protected Class NUMBER_CLASS;
    protected String DEFAULT_CLASS = NumericAttributeFilter.NODE;

    public NumericAttributeFilterEditor(CyWindow cyWindow) {
        this.cyWindow = cyWindow;
        try {
            this.NUMBER_CLASS = Class.forName("java.lang.Number");
            this.NODE_CLASS = Class.forName("giny.model.Node");
            this.EDGE_CLASS = Class.forName("giny.model.Edge");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.identifier = "Numeric Filter";
        this.setBorder(new TitledBorder("Numeric Filter - Select nodes or edges based on the value of numeric attributes"));
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(15);
        namePanel.add(new JLabel("Filter Name"));
        namePanel.add(this.nameField);
        this.add((Component)namePanel, "North");
        JPanel all_panel = new JPanel();
        all_panel.setLayout(new GridLayout(3, 1));
        JPanel topPanel = new JPanel();
        topPanel.add(new JLabel("Select graph objects of type "));
        this.classBox = new JComboBox();
        this.classBox.addItem(NumericAttributeFilter.NODE);
        this.classBox.addItem(NumericAttributeFilter.EDGE);
        this.classBox.setEditable(false);
        this.classBox.addActionListener(this);
        topPanel.add(this.classBox);
        JPanel middlePanel = new JPanel();
        middlePanel.add(new JLabel(" with a value for numeric attribute "));
        this.attributeBox = new JComboBox();
        this.attributeBox.setEditable(false);
        this.attributeBox.addActionListener(this);
        middlePanel.add(this.attributeBox);
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(new JLabel(" that is "));
        this.comparisonBox = new JComboBox();
        this.comparisonBox.addItem(NumericAttributeFilter.LESS);
        this.comparisonBox.addItem(NumericAttributeFilter.EQUAL);
        this.comparisonBox.addItem(NumericAttributeFilter.GREATER);
        this.comparisonBox.setSelectedIndex(0);
        this.comparisonBox.setEditable(false);
        this.comparisonBox.addActionListener(this);
        bottomPanel.add(this.comparisonBox);
        this.searchField = new JTextField(10);
        this.searchField.setEditable(true);
        this.searchField.addActionListener(this);
        bottomPanel.add(this.searchField);
        all_panel.add(topPanel);
        all_panel.add(middlePanel);
        all_panel.add(bottomPanel);
        this.add((Component)new JButton(new AbstractAction("Update List of Attributes"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).updateAttributeBox();
                    }
                });
            }

            static /* synthetic */ NumericAttributeFilterEditor access$000(1 x0) {
                return x0.NumericAttributeFilterEditor.this;
            }
        }), "South");
        this.setDefaults();
        this.add((Component)all_panel, "Center");
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return NumericAttributeFilter.FILTER_ID;
    }

    public Filter getFilter() {
        this.updateName();
        Number search_item = this.getSearchNumber();
        String attr_item = this.getSelectedAttribute();
        String currentClass = this.getSelectedClass();
        String currentComparison = this.getSelectedComparison();
        if (currentClass == null || currentComparison == null || search_item == null || attr_item == null || this.nameField.getText() == null) {
            return null;
        }
        return new NumericAttributeFilter(this.cyWindow, currentComparison, currentClass, attr_item, search_item, this.nameField.getText());
    }

    public void editFilter(Filter filter) {
        if (filter instanceof NumericAttributeFilter) {
            this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
            this.filter = (NumericAttributeFilter)filter;
            this.readInFilter();
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filter);
        }
    }

    public void reset() {
        if (this.filter == null) {
            this.setDefaults();
        } else {
            this.resetFilter();
        }
    }

    public void clear() {
        this.filter = null;
        this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
        this.setDefaults();
    }

    public String getFilterName() {
        return this.nameField.getText();
    }

    public void setFilterName(String name) {
        this.nameField.setText(name);
    }

    public Number getSearchNumber() {
        String numberString = this.searchField.getText();
        try {
            this.searchNumber = new Double(numberString);
        }
        catch (Exception e) {
            this.searchNumber = this.DEFAULT_SEARCH_NUMBER;
            this.searchField.setText(this.searchNumber.toString());
        }
        return this.searchNumber;
    }

    public void setSearchNumber(Number searchNumber) {
        this.searchNumber = searchNumber;
        this.searchField.setText(searchNumber.toString());
    }

    public String getSelectedAttribute() {
        if (this.attributeBox.getItemCount() == 0) {
            return null;
        }
        return (String)this.attributeBox.getSelectedItem();
    }

    public void setSelectedAttribute(String new_attr) {
        this.updateAttributeBox();
        this.attributeBox.setSelectedItem(new_attr);
    }

    public String getSelectedClass() {
        return (String)this.classBox.getSelectedItem();
    }

    public void setSelectedClass(String newClass) {
        this.classBox.setSelectedItem(newClass);
    }

    public String getSelectedComparison() {
        return (String)this.comparisonBox.getSelectedItem();
    }

    public void setSelectedComparison(String comparison) {
        this.comparisonBox.setSelectedItem(comparison);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.searchField) {
            this.fireSearchNumberChanged();
        } else if (e.getSource() == this.nameField) {
            this.fireFilterNameChanged();
        } else if (e.getSource() == this.attributeBox) {
            this.fireAttributeChanged();
        } else if (e.getSource() == this.classBox) {
            this.fireClassChanged();
        } else if (e.getSource() == this.comparisonBox) {
            this.fireComparisonChanged();
        }
        this.updateName();
    }

    public void updateName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getSelectedClass() + " : ");
        buffer.append(this.getSelectedAttribute());
        buffer.append(this.getSelectedComparison());
        buffer.append(this.getSearchNumber());
        this.nameField.setText(buffer.toString());
    }

    public void fireSearchNumberChanged() {
        this.pcs.firePropertyChange(NumericAttributeFilter.SEARCH_NUMBER_EVENT, null, this.getSearchNumber());
    }

    public void fireFilterNameChanged() {
        this.pcs.firePropertyChange(NumericAttributeFilter.FILTER_NAME_EVENT, null, this.nameField.getText());
    }

    public void fireComparisonChanged() {
        this.pcs.firePropertyChange(NumericAttributeFilter.COMPARISON_EVENT, null, this.getSelectedComparison());
    }

    public void fireClassChanged() {
        this.updateAttributeBox();
        this.pcs.firePropertyChange(NumericAttributeFilter.CLASS_TYPE_EVENT, null, this.getSelectedClass());
    }

    public void fireAttributeChanged() {
        String new_attr = this.getSelectedAttribute();
        this.pcs.firePropertyChange(NumericAttributeFilter.SELECTED_ATTRIBUTE_EVENT, null, this.getSelectedAttribute());
    }

    public void updateAttributeBox() {
        GraphObjAttributes objectAttributes = null;
        String type = this.getSelectedClass();
        objectAttributes = type.equals(NumericAttributeFilter.NODE) ? this.cyWindow.getNetwork().getNodeAttributes() : this.cyWindow.getNetwork().getEdgeAttributes();
        String[] attributeNames = objectAttributes.getAttributeNames();
        Vector<String> stringAttributes = new Vector<String>();
        for (int idx = 0; idx < attributeNames.length; ++idx) {
            if (!this.NUMBER_CLASS.isAssignableFrom(objectAttributes.getClass(attributeNames[idx]))) continue;
            stringAttributes.add(attributeNames[idx]);
        }
        this.attributeBox.removeAllItems();
        Iterator attrIt = stringAttributes.iterator();
        while (attrIt.hasNext()) {
            this.attributeBox.addItem(attrIt.next());
        }
        if (this.attributeBox.getItemCount() != 0) {
            this.attributeBox.setSelectedIndex(0);
        }
        this.fireAttributeChanged();
    }

    public void setDefaults() {
        this.setSearchNumber(this.DEFAULT_SEARCH_NUMBER);
        this.setFilterName(this.DEFAULT_FILTER_NAME);
        this.setSelectedClass(this.DEFAULT_CLASS);
        this.setSelectedAttribute(this.DEFAULT_SELECTED_ATTRIBUTE);
        this.setSelectedComparison(this.DEFAULT_COMPARISON);
    }

    public void readInFilter() {
        this.RESET_SEARCH_NUMBER = this.filter.getSearchNumber();
        this.RESET_FITLER_NAME = this.filter.toString();
        this.RESET_SELECTED_ATTRIBUTE = this.filter.getSelectedAttribute();
        this.RESET_CLASS = this.filter.getClassType();
        this.RESET_COMPARISON = this.filter.getComparison();
        this.resetFilter();
    }

    public void resetFilter() {
        this.setSearchNumber(this.RESET_SEARCH_NUMBER);
        this.setFilterName(this.RESET_FITLER_NAME);
        this.setSelectedClass(this.RESET_CLASS);
        this.setSelectedComparison(this.RESET_COMPARISON);
        this.setSelectedAttribute(this.RESET_SELECTED_ATTRIBUTE);
        this.fireFilterNameChanged();
    }
}

