/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.Cytoscape;
import cytoscape.data.GraphObjAttributes;
import cytoscape.view.CyWindow;
import filter.model.Filter;
import filter.model.FilterManager;
import java.beans.PropertyChangeEvent;
import javax.swing.event.SwingPropertyChangeSupport;

public class NumericAttributeFilter
implements Filter {
    protected String selectedAttribute;
    protected Number searchNumber;
    protected String comparison;
    protected Class classType;
    protected Class NODE_CLASS;
    protected Class EDGE_CLASS;
    public static String EQUAL = "=";
    public static String LESS = "<";
    public static String GREATER = ">";
    public static String NODE = "Node";
    public static String EDGE = "Edge";
    public static String SEARCH_NUMBER_EVENT = "SEARCH_STRING_EVENT";
    public static String SELECTED_ATTRIBUTE_EVENT = "SELECTED_ATTRIBUTE_EVENT";
    public static String FILTER_NAME_EVENT = "FILTER_NAME_EVENT";
    public static String CLASS_TYPE_EVENT = "CLASS_TYPE";
    public static String FILTER_ID = "NumericAttributeFilter";
    public static String COMPARISON_EVENT = "COMPARISON_EVENT";
    protected CyWindow cyWindow;
    protected String identifier = "default";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public NumericAttributeFilter(CyWindow cyWindow, String comparison, String classString, String selectedAttribute, Number searchNumber, String identifier) {
        this.cyWindow = cyWindow;
        this.comparison = comparison;
        try {
            this.NODE_CLASS = Class.forName("giny.model.Node");
            this.EDGE_CLASS = Class.forName("giny.model.Edge");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.selectedAttribute = selectedAttribute;
        this.searchNumber = searchNumber;
        this.identifier = identifier;
        this.setClassType(classString);
    }

    public NumericAttributeFilter(String comparison, String classString, String selectedAttribute, String searchNumber, String identifier) {
        this.cyWindow = Cytoscape.getDesktop();
        this.comparison = comparison;
        try {
            this.NODE_CLASS = Class.forName("giny.model.Node");
            this.EDGE_CLASS = Class.forName("giny.model.Edge");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.selectedAttribute = selectedAttribute;
        this.searchNumber = new Double(searchNumber);
        this.identifier = identifier;
        this.setClassType(classString);
    }

    public String toString() {
        return this.identifier;
    }

    public void setIdentifier(String new_id) {
        FilterManager.defaultManager().renameFilter(this.identifier, new_id);
        this.identifier = new_id;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public boolean passesFilter(Object object) {
        if (!this.classType.isInstance(object)) {
            return false;
        }
        GraphObjAttributes objectAttributes = null;
        objectAttributes = this.classType.equals(this.NODE_CLASS) ? this.cyWindow.getNetwork().getNodeAttributes() : this.cyWindow.getNetwork().getEdgeAttributes();
        String name = objectAttributes.getCanonicalName(object);
        if (name == null) {
            return false;
        }
        Number value = (Number)objectAttributes.getValue(this.selectedAttribute, name);
        if (value == null) {
            return false;
        }
        if (this.comparison == EQUAL) {
            return this.searchNumber.doubleValue() == value.doubleValue();
        }
        if (this.comparison == LESS) {
            return this.searchNumber.doubleValue() > value.doubleValue();
        }
        if (this.comparison == GREATER) {
            return this.searchNumber.doubleValue() < value.doubleValue();
        }
        return false;
    }

    public Class[] getPassingTypes() {
        return null;
    }

    public boolean equals(Object other_object) {
        return super.equals(other_object);
    }

    public Object clone() {
        return new NumericAttributeFilter(this.cyWindow, this.comparison, this.getClassType(), this.selectedAttribute, this.searchNumber, this.identifier + "_new");
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == SEARCH_NUMBER_EVENT) {
            this.setSearchNumber((Number)e.getNewValue());
        } else if (e.getPropertyName() == FILTER_NAME_EVENT) {
            this.setIdentifier((String)e.getNewValue());
        } else if (e.getPropertyName() == SELECTED_ATTRIBUTE_EVENT) {
            this.setSelectedAttribute((String)e.getNewValue());
        } else if (e.getPropertyName() == CLASS_TYPE_EVENT) {
            this.setClassType((String)e.getNewValue());
        } else if (e.getPropertyName() == COMPARISON_EVENT) {
            this.setComparison((String)e.getNewValue());
        }
    }

    public Number getSearchNumber() {
        return this.searchNumber;
    }

    public void setSearchNumber(Number searchNumber) {
        this.searchNumber = searchNumber;
        this.fireSearchNumberChanged();
    }

    public void fireSearchNumberChanged() {
        this.pcs.firePropertyChange(SEARCH_NUMBER_EVENT, null, this.searchNumber);
    }

    public String getSelectedAttribute() {
        return this.selectedAttribute;
    }

    public void setSelectedAttribute(String new_attr) {
        this.selectedAttribute = new_attr;
        this.fireSelectedAttributeModified();
    }

    public void fireSelectedAttributeModified() {
        this.pcs.firePropertyChange(SELECTED_ATTRIBUTE_EVENT, null, this.selectedAttribute);
    }

    public void setClassType(String classString) {
        this.classType = classString == NODE || classString.equals("Node") ? this.NODE_CLASS : this.EDGE_CLASS;
        this.pcs.firePropertyChange(CLASS_TYPE_EVENT, null, classString);
    }

    public String getClassType() {
        if (this.classType == this.NODE_CLASS) {
            return NODE;
        }
        return EDGE;
    }

    public void setComparison(String comparison) {
        this.comparison = comparison;
        this.pcs.firePropertyChange(COMPARISON_EVENT, null, comparison);
    }

    public String getComparison() {
        return this.comparison;
    }

    public String output() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("filter.cytoscape.NumericAttributeFilter,");
        buffer.append(this.getComparison() + ",");
        buffer.append(this.getClassType() + ",");
        buffer.append(this.getSelectedAttribute() + ",");
        buffer.append(this.getSearchNumber() + ",");
        buffer.append(this.toString());
        return buffer.toString();
    }

    public Filter input(String desc) {
        return null;
    }
}

