/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.view.CyWindow;
import filter.cytoscape.NodeTopologyFilter;
import filter.model.Filter;
import filter.model.FilterManager;
import filter.view.FilterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class NodeTopologyFilterEditor
extends FilterEditor
implements ActionListener {
    protected String identifier;
    protected JTextField nameField;
    protected JComboBox filterBox;
    protected JTextField distanceField;
    protected JTextField countField;
    protected Set filters;
    protected CyWindow cyWindow;
    protected NodeTopologyFilter filter;
    protected String DEFAULT_FILTER_NAME = "NodeTopology: ";
    protected String RESET_FITLER_NAME;
    protected Integer DEFAULT_DISTANCE = new Integer(1);
    protected Integer RESET_DISTANCE;
    protected Integer DEFAULT_COUNT = new Integer(1);
    protected Integer RESET_COUNT;
    protected Filter DEFAULT_FILTER = null;
    protected Filter RESET_FILTER;
    protected Class RESET_CLASS;
    protected Class NODE_CLASS;
    protected Class EDGE_CLASS;
    protected Class NUMBER_CLASS;
    protected Class DEFAULT_CLASS;

    public NodeTopologyFilterEditor(CyWindow cyWindow, Set filters) {
        this.filters = filters;
        this.cyWindow = cyWindow;
        this.identifier = "Topology Filter";
        this.setBorder(new TitledBorder("Node Topology Filter - Select nodes based on network topology"));
        this.setLayout(new BorderLayout());
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(15);
        this.nameField.setText(this.identifier);
        namePanel.add(new JLabel("Filter Name"));
        namePanel.add(this.nameField);
        this.add((Component)namePanel, "North");
        JPanel all_panel = new JPanel();
        all_panel.setLayout(new GridLayout(3, 1));
        JPanel topPanel = new JPanel();
        topPanel.add(new JLabel("Select nodes with "));
        this.countField = new JTextField(10);
        this.countField.setEditable(true);
        this.countField.addActionListener(this);
        topPanel.add(this.countField);
        topPanel.add(new JLabel(" neighbors"));
        JPanel middlePanel = new JPanel();
        middlePanel.add(new JLabel("within distance "));
        this.distanceField = new JTextField(10);
        this.distanceField.setEditable(true);
        this.distanceField.addActionListener(this);
        middlePanel.add(this.distanceField);
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(new JLabel("that pass the filter "));
        this.filterBox = new JComboBox();
        this.filterBox.addActionListener(this);
        bottomPanel.add(this.filterBox);
        all_panel.add(topPanel);
        all_panel.add(middlePanel);
        all_panel.add(bottomPanel);
        this.add((Component)new JButton(new AbstractAction("Update List of Filters"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        NodeTopologyFilterEditor.access$100(1.access$000(this.this$1));
                    }
                });
            }

            static /* synthetic */ NodeTopologyFilterEditor access$000(1 x0) {
                return x0.NodeTopologyFilterEditor.this;
            }
        }), "South");
        this.add((Component)all_panel, "Center");
        this.setDefaults();
    }

    private void updateFilterBox() {
        this.filterBox.removeAllItems();
        Iterator filterNameIt = this.filters.iterator();
        while (filterNameIt.hasNext()) {
            Filter nextFilter = FilterManager.defaultManager().getFilter((String)filterNameIt.next());
            if (nextFilter == null) continue;
            this.filterBox.addItem(nextFilter);
        }
        if (this.filterBox.getItemCount() > 0) {
            this.filterBox.setSelectedIndex(0);
        }
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return NodeTopologyFilter.FILTER_ID;
    }

    public Filter getFilter() {
        Filter currentFilter = this.getSelectedFilter();
        Integer currentCount = this.getCount();
        Integer currentDistance = this.getDistance();
        if (currentFilter == null || this.nameField.getText() == null) {
            return null;
        }
        return new NodeTopologyFilter(this.cyWindow, currentCount, currentDistance, currentFilter, this.nameField.getText());
    }

    public void editFilter(Filter filter) {
        if (filter instanceof NodeTopologyFilter) {
            this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
            this.filter = (NodeTopologyFilter)filter;
            this.readInFilter();
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filter);
        }
    }

    public void reset() {
        if (this.filter == null) {
            this.setDefaults();
        } else {
            this.resetFilter();
        }
    }

    public void clear() {
        this.filter = null;
        this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
        this.setDefaults();
    }

    public String getFilterName() {
        return this.nameField.getText();
    }

    public void setFilterName(String name) {
        this.nameField.setText(name);
    }

    public Filter getSelectedFilter() {
        if (this.filterBox.getItemCount() == 0) {
            return null;
        }
        return (Filter)this.filterBox.getSelectedItem();
    }

    public void setSelectedFilter(Filter newFilter) {
        this.updateFilterBox();
        if (newFilter != null) {
            this.filterBox.setSelectedItem(newFilter);
        }
    }

    public Integer getCount() {
        String countString = this.countField.getText();
        Integer countInteger = this.DEFAULT_COUNT;
        try {
            countInteger = new Integer(countString);
            if (countInteger < 1) {
                countInteger = this.DEFAULT_COUNT;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.countField.setText(countInteger.toString());
        return countInteger;
    }

    public void setCount(Integer count) {
        this.countField.setText(count.toString());
    }

    public Integer getDistance() {
        String distanceString = this.distanceField.getText();
        Integer distanceInteger = this.DEFAULT_DISTANCE;
        try {
            distanceInteger = new Integer(distanceString);
            if (distanceInteger < 1) {
                distanceInteger = this.DEFAULT_DISTANCE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.distanceField.setText(distanceInteger.toString());
        return distanceInteger;
    }

    public void setDistance(Integer distance) {
        this.distanceField.setText(distance.toString());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.nameField) {
            this.fireFilterNameChanged();
        } else if (e.getSource() == this.filterBox) {
            this.fireFilterChanged();
        } else if (e.getSource() == this.countField) {
            this.fireCountChanged();
        } else if (e.getSource() == this.distanceField) {
            this.fireDistanceChanged();
        }
    }

    public void fireFilterNameChanged() {
        this.pcs.firePropertyChange(NodeTopologyFilter.FILTER_NAME_EVENT, null, this.nameField.getText());
    }

    public void fireFilterChanged() {
        this.pcs.firePropertyChange(NodeTopologyFilter.FILTER_BOX_EVENT, null, this.getSelectedFilter());
    }

    public void fireCountChanged() {
        this.pcs.firePropertyChange(NodeTopologyFilter.COUNT_EVENT, null, this.getCount());
    }

    public void fireDistanceChanged() {
        this.pcs.firePropertyChange(NodeTopologyFilter.DISTANCE_EVENT, null, this.getDistance());
    }

    public void setDefaults() {
        this.setSelectedFilter(this.DEFAULT_FILTER);
        this.setCount(this.DEFAULT_COUNT);
        this.setDistance(this.DEFAULT_DISTANCE);
    }

    public void readInFilter() {
        this.RESET_COUNT = this.filter.getCount();
        this.RESET_DISTANCE = this.filter.getDistance();
        this.RESET_FILTER = this.filter.getFilter();
        this.resetFilter();
    }

    public void resetFilter() {
        this.setSelectedFilter(this.RESET_FILTER);
        this.setCount(this.RESET_COUNT);
        this.setDistance(this.RESET_DISTANCE);
        this.fireFilterNameChanged();
    }

    static /* synthetic */ void access$100(NodeTopologyFilterEditor x0) {
        x0.updateFilterBox();
    }
}

