/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.Cytoscape;
import cytoscape.view.CyWindow;
import filter.model.Filter;
import filter.model.FilterManager;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.beans.PropertyChangeEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;

public class NodeTopologyFilter
implements Filter {
    protected Filter filter;
    protected Integer count;
    protected Integer distance;
    protected HashSet seenNodes;
    protected CyWindow cyWindow;
    protected GraphPerspective myPerspective;
    public static String FILTER_NAME_EVENT = "FILTER_NAME_EVENT";
    public static String FILTER_ID = "NodeTopologyFilter";
    public static String FILTER_EVENT = "FILTER_EVENT";
    public static String FILTER_BOX_EVENT = "FILTER_BOX";
    public static String COUNT_EVENT = "COUNT";
    public static String DISTANCE_EVENT = "DISTANCE";
    protected String identifier = "default";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public NodeTopologyFilter(CyWindow cyWindow, Integer count, Integer distance, Filter filter, String identifier) {
        this.cyWindow = cyWindow;
        this.count = count;
        this.distance = distance;
        this.filter = filter;
        this.identifier = identifier;
    }

    public NodeTopologyFilter(String count, String distance, String filter, String identifier) {
        this.cyWindow = Cytoscape.getDesktop();
        this.count = new Integer(count);
        this.distance = new Integer(distance);
        this.filter = FilterManager.defaultManager().getFilter(filter);
        this.identifier = identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public void setIdentifier(String new_id) {
        FilterManager.defaultManager().renameFilter(this.identifier, new_id);
        this.identifier = new_id;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public boolean passesFilter(Object object) {
        if (object instanceof Node) {
            this.seenNodes = new HashSet();
            this.myPerspective = this.cyWindow.getView().getGraphPerspective();
            int totalSum = this.countNeighbors((Node)object, 0);
            return totalSum >= this.count;
        }
        return false;
    }

    private int countNeighbors(Node currentNode, int currentDistance) {
        if (currentDistance == this.distance) {
            if (this.filter.passesFilter(currentNode)) {
                return 1;
            }
            return 0;
        }
        int sum = 0;
        List neighbors = this.myPerspective.neighborsList(currentNode);
        Iterator nodeIt = neighbors.iterator();
        while (nodeIt.hasNext() && sum < this.count) {
            Node nextNode = (Node)nodeIt.next();
            if (this.seenNodes.contains(nextNode)) continue;
            this.seenNodes.add(nextNode);
            sum += this.countNeighbors(nextNode, currentDistance + 1);
        }
        if (sum >= this.count) {
            return sum;
        }
        if (this.filter.passesFilter(currentNode)) {
            return sum + 1;
        }
        return sum;
    }

    public Class[] getPassingTypes() {
        return null;
    }

    public boolean equals(Object other_object) {
        return super.equals(other_object);
    }

    public Object clone() {
        return new NodeTopologyFilter(this.cyWindow, this.count, this.distance, this.filter, this.identifier + "_new");
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == FILTER_NAME_EVENT) {
            this.setIdentifier((String)e.getNewValue());
        } else if (e.getPropertyName() == FILTER_BOX_EVENT) {
            this.setFilter((Filter)e.getNewValue());
        } else if (e.getPropertyName() == COUNT_EVENT) {
            this.setCount((Integer)e.getNewValue());
        } else if (e.getPropertyName() == DISTANCE_EVENT) {
            this.setDistance((Integer)e.getNewValue());
        }
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        this.pcs.firePropertyChange(FILTER_BOX_EVENT, null, filter);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setCount(Integer count) {
        this.count = count;
        this.pcs.firePropertyChange(COUNT_EVENT, null, count);
    }

    public Integer getCount() {
        return this.count;
    }

    public void setDistance(Integer distance) {
        this.distance = distance;
        this.pcs.firePropertyChange(DISTANCE_EVENT, null, distance);
    }

    public Integer getDistance() {
        return this.distance;
    }

    public String output() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("filter.cytoscape.NodeTopologyFilter,");
        buffer.append(this.getCount() + ",");
        buffer.append(this.getDistance() + ",");
        buffer.append(((Object)this.getFilter()).toString() + ",");
        buffer.append(this.toString());
        return buffer.toString();
    }

    public Filter input(String desc) {
        return null;
    }
}

