/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.view.CyWindow;
import filter.cytoscape.InteractionFilter;
import filter.model.Filter;
import filter.model.FilterManager;
import filter.view.FilterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class InteractionFilterEditor
extends FilterEditor
implements ActionListener {
    protected String identifier;
    protected JTextField nameField;
    protected JComboBox filterBox;
    protected JComboBox targetBox;
    protected InteractionFilter filter;
    protected Set filters;
    protected CyWindow cyWindow;
    protected String DEFAULT_FILTER_NAME = "NodeInteraction: ";
    protected String RESET_FITLER_NAME;
    protected Filter DEFAULT_FILTER = null;
    protected Filter RESET_FILTER;
    protected String DEFAULT_TARGET = InteractionFilter.SOURCE;
    protected String RESET_TARGET;

    public InteractionFilterEditor(CyWindow cyWindow, Set filters) {
        this.filters = filters;
        this.cyWindow = cyWindow;
        this.identifier = "Node Interactions";
        this.setBorder(new TitledBorder("Select nodes based on adjacent edges"));
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 250));
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(15);
        namePanel.add(new JLabel("Filter Name"));
        namePanel.add(this.nameField);
        this.add((Component)namePanel, "North");
        this.add((Component)new JButton(new AbstractAction("Update List of Filters"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        InteractionFilterEditor.access$100(1.access$000(this.this$1));
                    }
                });
            }

            static /* synthetic */ InteractionFilterEditor access$000(1 x0) {
                return x0.InteractionFilterEditor.this;
            }
        }), "South");
        JPanel all_panel = new JPanel();
        all_panel.setLayout(new GridLayout(2, 1));
        JPanel topPanel = new JPanel();
        topPanel.add(new JLabel("Select nodes which are the "));
        this.targetBox = new JComboBox();
        this.targetBox.addItem(InteractionFilter.SOURCE);
        this.targetBox.addItem(InteractionFilter.TARGET);
        this.targetBox.addActionListener(this);
        topPanel.add(this.targetBox);
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(new JLabel("of at least one edge which passes the filter "));
        this.filterBox = new JComboBox();
        this.filterBox.addActionListener(this);
        bottomPanel.add(this.filterBox);
        all_panel.add(topPanel);
        all_panel.add(bottomPanel);
        this.add((Component)all_panel, "Center");
        this.setDefaults();
    }

    private void updateFilterBox() {
        this.filterBox.removeAllItems();
        Iterator filterNameIt = this.filters.iterator();
        while (filterNameIt.hasNext()) {
            Filter nextFilter = FilterManager.defaultManager().getFilter((String)filterNameIt.next());
            if (nextFilter == null) continue;
            this.filterBox.addItem(nextFilter);
        }
        if (this.filterBox.getItemCount() > 0) {
            this.filterBox.setSelectedIndex(0);
        }
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return InteractionFilter.FILTER_ID;
    }

    public Filter getFilter() {
        Filter currentFilter = this.getSelectedFilter();
        String target = this.getTarget();
        if (target == null || currentFilter == null || this.nameField.getText() == null) {
            return null;
        }
        return new InteractionFilter(this.cyWindow, currentFilter, target, this.nameField.getText());
    }

    public void editFilter(Filter filter) {
        if (filter instanceof InteractionFilter) {
            this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
            this.filter = (InteractionFilter)filter;
            this.readInFilter();
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filter);
        }
    }

    public void reset() {
        if (this.filter == null) {
            this.setDefaults();
        } else {
            this.resetFilter();
        }
    }

    public void clear() {
        this.filter = null;
        this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
        this.setDefaults();
    }

    public String getFilterName() {
        return this.nameField.getText();
    }

    public void setFilterName(String name) {
        this.nameField.setText(name);
    }

    public String getTarget() {
        return (String)this.targetBox.getSelectedItem();
    }

    public void setTarget(String target) {
        this.targetBox.setSelectedItem(target);
    }

    public Filter getSelectedFilter() {
        if (this.filterBox.getItemCount() == 0) {
            return null;
        }
        return (Filter)this.filterBox.getSelectedItem();
    }

    public void setSelectedFilter(Filter newFilter) {
        this.updateFilterBox();
        if (newFilter != null) {
            this.filterBox.setSelectedItem(newFilter);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.nameField) {
            this.fireFilterNameChanged();
        } else if (e.getSource() == this.filterBox) {
            this.fireFilterBoxChanged();
        } else if (e.getSource() == this.targetBox) {
            this.fireTargetBoxChanged();
        }
    }

    public void fireFilterNameChanged() {
        this.pcs.firePropertyChange(InteractionFilter.FILTER_NAME_EVENT, null, this.nameField.getText());
    }

    public void fireFilterBoxChanged() {
        this.pcs.firePropertyChange(InteractionFilter.FILTER_BOX_EVENT, null, this.getSelectedFilter());
    }

    public void fireTargetBoxChanged() {
        this.pcs.firePropertyChange(InteractionFilter.TARGET_BOX_EVENT, null, this.getTarget());
    }

    public void setDefaults() {
        this.setFilterName(this.DEFAULT_FILTER_NAME);
        this.setSelectedFilter(this.DEFAULT_FILTER);
        this.setTarget(this.DEFAULT_TARGET);
    }

    public void readInFilter() {
        this.RESET_FITLER_NAME = this.filter.toString();
        this.RESET_FILTER = this.filter.getFilter();
        this.RESET_TARGET = this.filter.getTarget();
        this.resetFilter();
    }

    public void resetFilter() {
        this.setFilterName(this.RESET_FITLER_NAME);
        this.setSelectedFilter(this.RESET_FILTER);
        this.setTarget(this.RESET_TARGET);
        this.fireFilterNameChanged();
    }

    static /* synthetic */ void access$100(InteractionFilterEditor x0) {
        x0.updateFilterBox();
    }
}

