/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.Cytoscape;
import cytoscape.view.CyWindow;
import filter.model.Filter;
import filter.model.FilterManager;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;

public class InteractionFilter
implements Filter {
    protected Filter filter;
    protected String target;
    public static String FILTER_NAME_EVENT = "FILTER_NAME_EVENT";
    public static String FILTER_BOX_EVENT = "FILTER_BOX_EVENT";
    public static String TARGET_BOX_EVENT = "TARGET_BOX_EVENT";
    public static String FILTER_ID = "InteractionFilter";
    public static String SOURCE = "source";
    public static String TARGET = "target";
    protected CyWindow cyWindow;
    protected String identifier = "InteractionFilter";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public InteractionFilter(CyWindow cyWindow, Filter filter, String target, String identifier) {
        this.cyWindow = cyWindow;
        this.filter = filter;
        this.target = target;
        this.identifier = identifier;
    }

    public InteractionFilter(String filter, String target, String identifier) {
        this.cyWindow = Cytoscape.getDesktop();
        this.filter = FilterManager.defaultManager().getFilter(filter);
        this.target = target;
        this.identifier = identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public void setIdentifier(String new_id) {
        FilterManager.defaultManager().renameFilter(this.identifier, new_id);
        this.identifier = new_id;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public boolean passesFilter(Object object) {
        if (!(object instanceof Node)) {
            return false;
        }
        Node node = (Node)object;
        GraphPerspective myPerspective = this.cyWindow.getView().getGraphPerspective();
        List adjacentEdges = this.target == SOURCE ? myPerspective.getAdjacentEdgesList(node, true, false, true) : myPerspective.getAdjacentEdgesList(node, true, true, false);
        Iterator edgeIt = adjacentEdges.iterator();
        while (edgeIt.hasNext()) {
            if (!this.filter.passesFilter(edgeIt.next())) continue;
            return true;
        }
        return false;
    }

    public Class[] getPassingTypes() {
        return null;
    }

    public boolean equals(Object other_object) {
        return super.equals(other_object);
    }

    public Object clone() {
        return new InteractionFilter(this.cyWindow, this.filter, this.target, this.identifier + "_new");
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == FILTER_NAME_EVENT) {
            this.setIdentifier((String)e.getNewValue());
        } else if (e.getPropertyName() == FILTER_BOX_EVENT) {
            this.setFilter((Filter)e.getNewValue());
        } else if (e.getPropertyName() == TARGET_BOX_EVENT) {
            this.setTarget((String)e.getNewValue());
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        this.pcs.firePropertyChange(TARGET_BOX_EVENT, null, target);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        this.pcs.firePropertyChange(FILTER_BOX_EVENT, null, filter);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String output() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("filter.cytoscape.InteractionFilter,");
        buffer.append(((Object)this.getFilter()).toString() + ",");
        buffer.append(this.getTarget() + ",");
        buffer.append(this.toString());
        return buffer.toString();
    }

    public Filter input(String desc) {
        return null;
    }
}

