/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.view.CyWindow;
import filter.model.Filter;
import filter.model.FilterManager;
import filter.view.FilterEditorPanel;
import filter.view.FilterListPanel;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import phoebe.PGraphView;

public class FilterUsePanel
extends JPanel
implements PropertyChangeListener,
ActionListener {
    FilterEditorPanel filterEditorPanel;
    FilterListPanel filterListPanel;
    JRadioButton hideFailed;
    JRadioButton grayFailed;
    JRadioButton selectPassed;
    JButton apply;
    JButton addFilters;
    JButton removeFilters;
    JList selectedFilters;
    JRadioButton and;
    JRadioButton or;
    JRadioButton xor;
    CyNetwork network;
    CyWindow window;
    JButton addButton;
    JButton removeButton;
    JCheckBox select;
    JCheckBox gray;
    JCheckBox hide;
    JCheckBox overwrite;
    JRadioButton pulsate;
    JRadioButton spiral;

    public FilterUsePanel(CyNetwork network, CyWindow window) {
        this.network = network;
        this.window = window;
        this.filterEditorPanel = new FilterEditorPanel();
        JPanel selected_filter_panel = new JPanel();
        selected_filter_panel.setLayout(new BorderLayout());
        this.filterListPanel = new FilterListPanel(FilterListPanel.SHOW_TOGETHER);
        selected_filter_panel.add((Component)this.filterListPanel, "Center");
        selected_filter_panel.add((Component)this.createManagePanel(), "North");
        selected_filter_panel.add((Component)this.createActionPanel(), "South");
        JSplitPane pane0 = new JSplitPane(1, selected_filter_panel, this.filterEditorPanel);
        this.add(pane0);
        this.filterListPanel.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filterEditorPanel);
    }

    public FilterListPanel getFilterListPanel() {
        return this.filterListPanel;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == FilterListPanel.FILTER_SELECTED) {
            // empty if block
        }
    }

    public JPanel createManagePanel() {
        JPanel result = new JPanel();
        result.setBorder(new TitledBorder("Manage Filters"));
        this.addButton = new JButton("Add current filter");
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("Remove selected filter");
        this.removeButton.addActionListener(this);
        result.add(this.addButton);
        result.add(this.removeButton);
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        Filter filter;
        if (e.getSource() == this.addButton) {
            FilterManager.defaultManager().addFilter(this.filterEditorPanel.getSelectedEditor().getFilter());
        }
        if (e.getSource() == this.removeButton && (filter = this.filterListPanel.getSelectedFilter()) != null) {
            FilterManager.defaultManager().removeFilter(filter);
        }
    }

    protected void testObjects() {
        Filter filter = this.filterListPanel.getSelectedFilter();
        this.network = this.window.getNetwork();
        List nodes_list = this.network.getGraphPerspective().nodesList();
        List edges_list = this.network.getGraphPerspective().edgesList();
        if (filter != null) {
            Iterator nodes = nodes_list.iterator();
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                try {
                    this.passObject(node, filter.passesFilter(node));
                }
                catch (StackOverflowError soe) {
                    return;
                }
            }
            Iterator edges = edges_list.iterator();
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                try {
                    this.passObject(edge, filter.passesFilter(edge));
                }
                catch (StackOverflowError soe) {
                    return;
                }
            }
        }
    }

    protected void passObject(Object object, boolean passes) {
        if (passes) {
            if (object instanceof Node) {
                NodeView nv = this.window.getView().getNodeView((Node)object);
                if (this.select.isSelected()) {
                    nv.setSelected(true);
                }
            } else if (object instanceof Edge) {
                EdgeView nv = this.window.getView().getEdgeView((Edge)object);
                if (this.select.isSelected()) {
                    nv.setSelected(true);
                }
            }
        } else if (object instanceof Node) {
            NodeView nv = this.window.getView().getNodeView((Node)object);
            if (this.hide.isSelected()) {
                ((PGraphView)this.window.getView()).hideNodeView(nv);
            }
        } else if (object instanceof Edge) {
            EdgeView nv = this.window.getView().getEdgeView((Edge)object);
            if (this.hide.isSelected()) {
                ((PGraphView)this.window.getView()).hideEdgeView(nv);
            }
        }
    }

    public JPanel createActionPanel() {
        JPanel actionPanel = new JPanel();
        actionPanel.setBorder(new TitledBorder("Available Actions"));
        this.select = new JCheckBox("Select Passed");
        this.hide = new JCheckBox("Hide Failed");
        actionPanel.add(this.select);
        actionPanel.add(this.hide);
        actionPanel.add(new JButton(new AbstractAction("Go!"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).testObjects();
                    }
                });
            }

            static /* synthetic */ FilterUsePanel access$000(1 x0) {
                return x0.FilterUsePanel.this;
            }
        }));
        return actionPanel;
    }
}

