/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.data.GraphObjAttributes;
import filter.cytoscape.CsNodeTypeFilter;
import filter.model.Filter;
import filter.view.FilterEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class CsNodeTypeFilterEditor
extends FilterEditor
implements ActionListener {
    protected String identifier;
    protected JTextField nameField;
    protected JComboBox searchBox;
    protected JComboBox attributeBox;
    protected String searchString;
    protected String selectedAttribute;
    protected CsNodeTypeFilter filter;
    protected CyNetwork network;
    protected GraphObjAttributes nodeAttributes;
    protected String DEFAULT_SEARCH_STRING = "";
    protected String RESET_SEARCH_STRING;
    protected String DEFAULT_FILTER_NAME = "NodeType: ";
    protected String RESET_FITLER_NAME;
    protected String DEFAULT_SELECTED_ATTRIBUTE = "";
    protected String RESET_SELECTED_ATTRIBUTE;

    public CsNodeTypeFilterEditor(CyNetwork network) {
        this.network = network;
        this.nodeAttributes = network.getNodeAttributes();
        this.identifier = "Node Attribute";
        this.setBorder(new TitledBorder("Node Attribute Filter"));
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(15);
        namePanel.add(new JLabel("Filter Name"));
        namePanel.add(this.nameField);
        this.add(namePanel);
        JPanel attribute_panel = new JPanel();
        this.attributeBox = new JComboBox<String>(this.nodeAttributes.getAttributeNames());
        this.attributeBox.setEditable(false);
        this.attributeBox.addActionListener(this);
        attribute_panel.add(this.attributeBox);
        this.add(attribute_panel);
        JPanel search_panel = new JPanel();
        this.searchBox = new JComboBox();
        this.searchBox.setEditable(true);
        this.searchBox.addActionListener(this);
        search_panel.add(this.searchBox);
        this.add(search_panel);
        this.add(new JButton(new AbstractAction("Update"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        String[] atts = 1.access$000(this.this$1).nodeAttributes.getAttributeNames();
                        System.out.println("There are: " + atts.length + " attributes.");
                        for (int i = 0; i < atts.length; ++i) {
                            System.out.println(i + ". " + atts[i]);
                        }
                        1.access$000(this.this$1).attributeBox.setModel(new DefaultComboBoxModel<String>(1.access$000(this.this$1).nodeAttributes.getAttributeNames()));
                    }
                });
            }

            static /* synthetic */ CsNodeTypeFilterEditor access$000(1 x0) {
                return x0.CsNodeTypeFilterEditor.this;
            }
        }));
        this.setDefaults();
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return CsNodeTypeFilter.FILTER_ID;
    }

    public Filter getFilter() {
        String search_item = (String)this.searchBox.getSelectedItem();
        String attr_item = (String)this.attributeBox.getSelectedItem();
        if (search_item == null || attr_item == null || this.nameField.getText() == null) {
            return null;
        }
        return new CsNodeTypeFilter(this.network, attr_item, search_item, this.nameField.getText());
    }

    public void editFilter(Filter filter) {
        if (filter instanceof CsNodeTypeFilter) {
            this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
            this.filter = (CsNodeTypeFilter)filter;
            this.readInFilter();
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filter);
        }
    }

    public void reset() {
        if (this.filter == null) {
            this.setDefaults();
        } else {
            this.resetFilter();
        }
    }

    public void clear() {
        this.filter = null;
        this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
        this.setDefaults();
    }

    public String getFilterName() {
        return this.nameField.getText();
    }

    public void setFilterName(String name) {
        this.nameField.setText(name);
    }

    public String getSearchString() {
        return (String)this.searchBox.getSelectedItem();
    }

    public void setSearchString(String search_string) {
        this.searchBox.setSelectedItem(search_string);
    }

    public String getSelectedAttribute() {
        return (String)this.attributeBox.getSelectedItem();
    }

    public void setSelectedAttribute(String new_attr) {
        this.attributeBox.setSelectedItem(new_attr);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.searchBox) {
            this.fireSearchStringChanged();
        } else if (e.getSource() == this.nameField) {
            this.fireFilterNameChanged();
        } else if (e.getSource() == this.attributeBox) {
            this.fireAttributeChanged();
        }
    }

    public void fireSearchStringChanged() {
        this.pcs.firePropertyChange(CsNodeTypeFilter.SEARCH_STRING_EVENT, null, this.getSearchString());
    }

    public void fireFilterNameChanged() {
        this.pcs.firePropertyChange(CsNodeTypeFilter.FILTER_NAME_EVENT, null, this.nameField.getText());
    }

    public void fireAttributeChanged() {
        String new_attr = this.getSelectedAttribute();
        this.searchBox.setModel(new DefaultComboBoxModel<Object>(this.nodeAttributes.getUniqueValues(new_attr)));
        this.pcs.firePropertyChange(CsNodeTypeFilter.SELECTED_ATTRIBUTE_EVENT, null, this.getSelectedAttribute());
    }

    public void setDefaults() {
        this.setSelectedAttribute(this.DEFAULT_SELECTED_ATTRIBUTE);
        this.setSearchString(this.DEFAULT_SEARCH_STRING);
        this.setFilterName(this.DEFAULT_FILTER_NAME);
    }

    public void readInFilter() {
        this.RESET_SEARCH_STRING = this.filter.getSearchString();
        this.RESET_FITLER_NAME = this.filter.toString();
        this.RESET_SELECTED_ATTRIBUTE = this.filter.getSelectedAttribute();
        this.resetFilter();
    }

    public void resetFilter() {
        this.setSelectedAttribute(this.RESET_SELECTED_ATTRIBUTE);
        this.setSearchString(this.RESET_SEARCH_STRING);
        this.setFilterName(this.RESET_FITLER_NAME);
        this.fireFilterNameChanged();
    }
}

