/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.data.GraphObjAttributes;
import filter.cytoscape.CsNodeInteractionFilter;
import filter.model.Filter;
import filter.view.FilterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class CsNodeInteractionFilterEditor
extends FilterEditor
implements ActionListener {
    protected String identifier;
    protected JTextField nameField;
    protected JComboBox searchBox;
    protected JComboBox edgeAttributeBox;
    protected JRadioButton sourceNodeButton;
    protected JRadioButton targetNodeButton;
    protected JRadioButton bothNodesButton;
    protected String searchString;
    protected String selectedEdgeAttribute;
    protected boolean sourceNode;
    protected boolean targetNode;
    protected CsNodeInteractionFilter filter;
    protected CyNetwork network;
    protected GraphObjAttributes edgeAttributes;
    protected String DEFAULT_SEARCH_STRING = "";
    protected String RESET_SEARCH_STRING;
    protected String DEFAULT_FILTER_NAME = "NodeInteraction: ";
    protected String RESET_FITLER_NAME;
    protected String DEFAULT_SELECTED_EDGE_ATTRIBUTE = "";
    protected String RESET_SELECTED_EDGE_ATTRIBUTE;
    protected boolean DEFAULT_SOURCE_NODE = true;
    protected boolean RESET_SOURCE_NODE;
    protected boolean DEFAULT_TARGET_NODE = true;
    protected boolean RESET_TARGET_NODE;

    public CsNodeInteractionFilterEditor(CyNetwork network) {
        this.network = network;
        this.edgeAttributes = network.getEdgeAttributes();
        this.identifier = "Node Interactions";
        this.setBorder(new TitledBorder("Node Interaction Based on Edges Filter"));
        this.setLayout(new BorderLayout());
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(15);
        namePanel.add(new JLabel("Filter Name"));
        namePanel.add(this.nameField);
        namePanel.add(new JButton(new AbstractAction("Update"){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        String[] atts = 1.access$000(this.this$1).edgeAttributes.getAttributeNames();
                        System.out.println("There are: " + atts.length + " attributes.");
                        for (int i = 0; i < atts.length; ++i) {
                            System.out.println(i + ". " + atts[i]);
                        }
                        1.access$000(this.this$1).edgeAttributeBox.setModel(new DefaultComboBoxModel<String>(1.access$000(this.this$1).edgeAttributes.getAttributeNames()));
                    }
                });
            }

            static /* synthetic */ CsNodeInteractionFilterEditor access$000(1 x0) {
                return x0.CsNodeInteractionFilterEditor.this;
            }
        }));
        this.add((Component)namePanel, "North");
        JPanel attribute_panel = new JPanel();
        this.edgeAttributeBox = new JComboBox<String>(this.edgeAttributes.getAttributeNames());
        this.edgeAttributeBox.setEditable(false);
        this.edgeAttributeBox.addActionListener(this);
        attribute_panel.add(this.edgeAttributeBox);
        this.searchBox = new JComboBox();
        this.searchBox.setEditable(true);
        this.searchBox.addActionListener(this);
        attribute_panel.add(this.searchBox);
        this.add((Component)attribute_panel, "Center");
        JPanel end_panel = new JPanel();
        this.sourceNodeButton = new JRadioButton("source");
        this.targetNodeButton = new JRadioButton("target");
        this.bothNodesButton = new JRadioButton("both");
        ButtonGroup group = new ButtonGroup();
        group.add(this.sourceNodeButton);
        group.add(this.targetNodeButton);
        group.add(this.bothNodesButton);
        end_panel.add(this.sourceNodeButton);
        end_panel.add(this.targetNodeButton);
        end_panel.add(this.bothNodesButton);
        this.sourceNodeButton.addActionListener(this);
        this.targetNodeButton.addActionListener(this);
        this.bothNodesButton.addActionListener(this);
        attribute_panel.add((Component)end_panel, "South");
        this.setDefaults();
    }

    public String toString() {
        return this.identifier;
    }

    public String getFilterID() {
        return CsNodeInteractionFilter.FILTER_ID;
    }

    public Filter getFilter() {
        String search_item = (String)this.searchBox.getSelectedItem();
        String attr_item = (String)this.edgeAttributeBox.getSelectedItem();
        boolean source = this.sourceNodeButton.isSelected();
        boolean target = this.targetNodeButton.isSelected();
        boolean both = this.bothNodesButton.isSelected();
        if (search_item == null || attr_item == null || this.nameField.getText() == null) {
            return null;
        }
        if (both) {
            return new CsNodeInteractionFilter(this.network, attr_item, search_item, true, true, this.nameField.getText());
        }
        return new CsNodeInteractionFilter(this.network, attr_item, search_item, source, target, this.nameField.getText());
    }

    public void editFilter(Filter filter) {
        if (filter instanceof CsNodeInteractionFilter) {
            this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
            this.filter = (CsNodeInteractionFilter)filter;
            this.readInFilter();
            this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.filter);
        }
    }

    public void reset() {
        if (this.filter == null) {
            this.setDefaults();
        } else {
            this.resetFilter();
        }
    }

    public void clear() {
        this.filter = null;
        this.getSwingPropertyChangeSupport().removePropertyChangeListener(this.filter);
        this.setDefaults();
    }

    public String getFilterName() {
        return this.nameField.getText();
    }

    public void setFilterName(String name) {
        this.nameField.setText(name);
    }

    public String getSearchString() {
        return (String)this.searchBox.getSelectedItem();
    }

    public void setSearchString(String search_string) {
        this.searchBox.setSelectedItem(search_string);
    }

    public String getSelectedEdgeAttribute() {
        return (String)this.edgeAttributeBox.getSelectedItem();
    }

    public void setSelectedEdgeAttribute(String new_attr) {
        this.edgeAttributeBox.setSelectedItem(new_attr);
    }

    public boolean getSourceNode() {
        return this.bothNodesButton.isSelected() || this.sourceNodeButton.isSelected();
    }

    public void setSourceNode(boolean new_val) {
        if (this.getTargetNode() && new_val) {
            this.bothNodesButton.setSelected(true);
        } else if (!this.getTargetNode() && new_val) {
            this.sourceNodeButton.setSelected(true);
        } else {
            this.sourceNodeButton.setSelected(false);
        }
    }

    public boolean getTargetNode() {
        return this.bothNodesButton.isSelected() || this.targetNodeButton.isSelected();
    }

    public void setTargetNode(boolean new_val) {
        if (this.getTargetNode() && new_val) {
            this.bothNodesButton.setSelected(true);
        } else if (!this.getTargetNode() && new_val) {
            this.targetNodeButton.setSelected(true);
        } else {
            this.targetNodeButton.setSelected(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.searchBox) {
            this.fireSearchStringChanged();
        } else if (e.getSource() == this.nameField) {
            this.fireFilterNameChanged();
        } else if (e.getSource() == this.edgeAttributeBox) {
            this.fireEdgeAttributeChanged();
        } else if (e.getSource() == this.sourceNodeButton) {
            this.fireSourceNodeChanged();
        } else if (e.getSource() == this.targetNodeButton) {
            this.fireTargetNodeChanged();
        } else if (e.getSource() == this.bothNodesButton) {
            this.fireBothChanged();
        }
    }

    public void fireSearchStringChanged() {
        this.pcs.firePropertyChange(CsNodeInteractionFilter.SEARCH_STRING_EVENT, null, this.getSearchString());
    }

    public void fireFilterNameChanged() {
        this.pcs.firePropertyChange(CsNodeInteractionFilter.FILTER_NAME_EVENT, null, this.nameField.getText());
    }

    public void fireEdgeAttributeChanged() {
        String new_attr = this.getSelectedEdgeAttribute();
        this.searchBox.setModel(new DefaultComboBoxModel<Object>(this.edgeAttributes.getUniqueValues(new_attr)));
        this.pcs.firePropertyChange(CsNodeInteractionFilter.SELECTED_EDGE_ATTRIBUTE_EVENT, null, this.getSelectedEdgeAttribute());
    }

    public void fireSourceNodeChanged() {
        this.sourceNode = this.sourceNodeButton.isSelected();
        this.pcs.firePropertyChange(CsNodeInteractionFilter.SOURCE_NODE_EVENT, null, new Boolean(this.sourceNode));
    }

    public void fireTargetNodeChanged() {
        this.targetNode = this.targetNodeButton.isSelected();
        this.pcs.firePropertyChange(CsNodeInteractionFilter.TARGET_NODE_EVENT, null, new Boolean(this.targetNode));
    }

    public void fireBothChanged() {
        this.targetNode = true;
        this.sourceNode = true;
        this.pcs.firePropertyChange(CsNodeInteractionFilter.SOURCE_NODE_EVENT, null, new Boolean(this.sourceNode));
        this.pcs.firePropertyChange(CsNodeInteractionFilter.TARGET_NODE_EVENT, null, new Boolean(this.targetNode));
    }

    public void setDefaults() {
        this.setSelectedEdgeAttribute(this.DEFAULT_SELECTED_EDGE_ATTRIBUTE);
        this.setSearchString(this.DEFAULT_SEARCH_STRING);
        this.setFilterName(this.DEFAULT_FILTER_NAME);
        this.setSourceNode(this.DEFAULT_SOURCE_NODE);
        this.setTargetNode(this.DEFAULT_TARGET_NODE);
    }

    public void readInFilter() {
        this.RESET_SEARCH_STRING = this.filter.getSearchString();
        this.RESET_FITLER_NAME = this.filter.toString();
        this.RESET_SELECTED_EDGE_ATTRIBUTE = this.filter.getSelectedEdgeAttribute();
        this.RESET_SOURCE_NODE = this.filter.getSourceNode();
        this.RESET_TARGET_NODE = this.filter.getTargetNode();
        this.resetFilter();
    }

    public void resetFilter() {
        this.setSelectedEdgeAttribute(this.RESET_SELECTED_EDGE_ATTRIBUTE);
        this.setSearchString(this.RESET_SEARCH_STRING);
        this.setFilterName(this.RESET_FITLER_NAME);
        this.setSourceNode(this.RESET_SOURCE_NODE);
        this.setTargetNode(this.RESET_TARGET_NODE);
        this.fireFilterNameChanged();
    }
}

