/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import ViolinStrings.Strings;
import cytoscape.CyNetwork;
import cytoscape.data.GraphObjAttributes;
import filter.model.Filter;
import filter.model.FilterManager;
import giny.model.Edge;
import giny.model.Node;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;

public class CsNodeInteractionFilter
implements Filter {
    protected String selectedEdgeAttribute;
    protected String searchString;
    protected boolean sourceNode;
    protected boolean targetNode;
    public static String SOURCE_NODE_EVENT = "SOURCE_NODE_EVENT";
    public static String TARGET_NODE_EVENT = "TARGET_NODE_EVENT";
    public static String SEARCH_STRING_EVENT = "SEARCH_STRING_EVENT";
    public static String SELECTED_EDGE_ATTRIBUTE_EVENT = "SELECTED_EDGE_ATTRIBUTE_EVENT";
    public static String FILTER_NAME_EVENT = "FILTER_NAME_EVENT";
    public static String FILTER_ID = "CsNodeInteractionFilter";
    protected CyNetwork network;
    protected GraphObjAttributes edgeAttributes;
    protected String identifier = "CsNodeInteractionFilter";
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public CsNodeInteractionFilter(CyNetwork network, String selectedEdgeAttribute, String searchString, boolean sourceNode, boolean targetNode, String identifier) {
        this.network = network;
        this.edgeAttributes = network.getEdgeAttributes();
        this.selectedEdgeAttribute = selectedEdgeAttribute;
        this.searchString = searchString;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.identifier = identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public void setIdentifier(String new_id) {
        FilterManager.defaultManager().renameFilter(this.identifier, new_id);
        this.identifier = new_id;
    }

    public String getFilterID() {
        return FILTER_ID;
    }

    public boolean passesFilter(Object object) {
        if (!(object instanceof Node)) {
            return false;
        }
        Node node = (Node)object;
        System.out.println("Network: " + this.network);
        boolean passes = false;
        List adjacent_edges = this.network.getGraphPerspective().getAdjacentEdgesList(node, true, this.targetNode, this.sourceNode);
        if (adjacent_edges == null) {
            System.out.println("Was NUll");
            return true;
        }
        Iterator aei = adjacent_edges.iterator();
        while (aei.hasNext() && !passes) {
            Edge edge = (Edge)aei.next();
            Object value = this.edgeAttributes.getValue(this.selectedEdgeAttribute, this.edgeAttributes.getCanonicalName((Object)edge));
            System.out.println("Testing node: " + node + " against edge: " + edge + " value: " + value + " of attr: " + this.selectedEdgeAttribute + " ss: " + this.searchString);
            if (!(value instanceof String)) continue;
            String[] pattern = this.searchString.split("\\s");
            for (int p = 0; p < pattern.length; ++p) {
                if (!Strings.isLike((String)((String)value), (String)pattern[p], (int)0, (boolean)true)) continue;
                passes = true;
            }
        }
        return passes;
    }

    public Class[] getPassingTypes() {
        return null;
    }

    public boolean equals(Object other_object) {
        return other_object instanceof CsNodeInteractionFilter && ((CsNodeInteractionFilter)other_object).getSearchString().equals(this.getSearchString());
    }

    public Object clone() {
        return new CsNodeInteractionFilter(this.network, this.selectedEdgeAttribute, this.searchString, this.sourceNode, this.targetNode, this.identifier + "_new");
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == SEARCH_STRING_EVENT) {
            System.out.println("Search String Changed to " + (String)e.getNewValue());
            this.setSearchString((String)e.getNewValue());
        } else if (e.getPropertyName() == FILTER_NAME_EVENT) {
            this.setIdentifier((String)e.getNewValue());
        } else if (e.getPropertyName() == SELECTED_EDGE_ATTRIBUTE_EVENT) {
            this.setSelectedEdgeAttribute((String)e.getNewValue());
        } else if (e.getPropertyName() == SOURCE_NODE_EVENT) {
            this.setSourceNode((Boolean)e.getNewValue());
        } else if (e.getPropertyName() == TARGET_NODE_EVENT) {
            this.setTargetNode((Boolean)e.getNewValue());
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String search_string) {
        this.searchString = search_string;
        this.fireSearchStringChanged();
    }

    public void fireSearchStringChanged() {
        this.pcs.firePropertyChange(SEARCH_STRING_EVENT, null, this.searchString);
    }

    public String getSelectedEdgeAttribute() {
        return this.selectedEdgeAttribute;
    }

    public void setSelectedEdgeAttribute(String new_attr) {
        this.selectedEdgeAttribute = new_attr;
        this.fireSelectedEdgeAttributeModified();
    }

    public void fireSelectedEdgeAttributeModified() {
        this.pcs.firePropertyChange(SELECTED_EDGE_ATTRIBUTE_EVENT, null, this.selectedEdgeAttribute);
    }

    public boolean getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(Boolean new_val) {
        this.sourceNode = new_val;
        this.fireSourceNodeModified();
    }

    public void setSourceNode(boolean new_val) {
        this.sourceNode = new_val;
        this.fireSourceNodeModified();
    }

    public void fireSourceNodeModified() {
        this.pcs.firePropertyChange(SOURCE_NODE_EVENT, null, new Boolean(this.sourceNode));
    }

    public boolean getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(Boolean new_val) {
        this.targetNode = new_val;
        this.fireTargetNodeModified();
    }

    public void setTargetNode(boolean new_val) {
        this.targetNode = new_val;
        this.fireTargetNodeModified();
    }

    public void fireTargetNodeModified() {
        this.pcs.firePropertyChange(TARGET_NODE_EVENT, null, new Boolean(this.targetNode));
    }

    public String output() {
        return null;
    }

    public Filter input(String desc) {
        return null;
    }
}

