/*
 * Decompiled with CFR 0.152.
 */
package filter.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.plugin.AbstractPlugin;
import cytoscape.plugin.jar.JarLoader;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyWindow;
import filter.cytoscape.BooleanMetaFilterEditor;
import filter.cytoscape.FilterMenuItem;
import filter.cytoscape.FilterPlugin;
import filter.cytoscape.FilterUsePanel;
import filter.cytoscape.InteractionFilterEditor;
import filter.cytoscape.NodeTopologyFilterEditor;
import filter.cytoscape.NumericAttributeFilterEditor;
import filter.cytoscape.StringPatternFilterEditor;
import filter.cytoscape.network.CreateAddNetwork;
import filter.cytoscape.network.FilterDataView;
import filter.model.FilterManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class CsFilter
extends AbstractPlugin
implements PropertyChangeListener {
    protected JFrame frame;
    protected CyWindow window;
    protected CyNetwork network;
    protected FilterUsePanel filterUsePanel;

    public CsFilter(CyWindow window) {
        this.window = window;
        this.network = window.getNetwork();
        this.initialize();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == Cytoscape.CYTOSCAPE_EXIT) {
            Set filters = FilterManager.defaultManager().getFilters(true);
            Iterator i = filters.iterator();
            try {
                File filter_file = Cytoscape.getCytoscapeObj().getConfigFile("filter.props");
                BufferedWriter writer = new BufferedWriter(new FileWriter(filter_file));
                while (i.hasNext()) {
                    try {
                        writer.write(FilterManager.defaultManager().getFilter((String)i.next()).output());
                        writer.newLine();
                    }
                    catch (Exception ex) {
                        System.out.println("Error with Filter output");
                    }
                }
                writer.close();
            }
            catch (Exception ex) {
                System.out.println("Filter Write error");
                ex.printStackTrace();
            }
        }
    }

    public void initialize() {
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        try {
            File filter_file = Cytoscape.getCytoscapeObj().getConfigFile("filter.props");
            BufferedReader in = new BufferedReader(new FileReader(filter_file));
            String oneLine = in.readLine();
            while (oneLine != null) {
                if (!oneLine.startsWith("#")) {
                    FilterManager.defaultManager().createFilterFromString(oneLine);
                }
                oneLine = in.readLine();
            }
            in.close();
        }
        catch (Exception ex) {
            System.out.println("Filter Read error");
            ex.printStackTrace();
        }
        ImageIcon icon = new ImageIcon(JarLoader.getLoader().getObjectIfYouWantIt("filter36.gif"));
        ImageIcon icon2 = new ImageIcon(JarLoader.getLoader().getObjectIfYouWantIt("filter16.gif"));
        FilterPlugin action = new FilterPlugin(this.network, this.window, icon, this);
        FilterMenuItem menu_action = new FilterMenuItem(this.network, this.window, icon2, this);
        this.window.getCyMenus().addCytoscapeAction((CytoscapeAction)action);
        this.window.getCyMenus().addCytoscapeAction((CytoscapeAction)menu_action);
        CreateAddNetwork can = new CreateAddNetwork(null);
        this.window.getCyMenus().addCytoscapeAction((CytoscapeAction)can);
        FilterDataView fdv = new FilterDataView(null);
        this.window.getCyMenus().addCytoscapeAction((CytoscapeAction)fdv);
        FilterManager.defaultManager().addEditor(new InteractionFilterEditor(this.window, FilterManager.defaultManager().getFilters(false)));
        FilterManager.defaultManager().addEditor(new NodeTopologyFilterEditor(this.window, FilterManager.defaultManager().getFilters(false)));
        FilterManager.defaultManager().addEditor(new BooleanMetaFilterEditor(FilterManager.defaultManager().getFilters(false)));
        FilterManager.defaultManager().addEditor(new NumericAttributeFilterEditor(this.window));
        FilterManager.defaultManager().addEditor(new StringPatternFilterEditor(this.window));
    }

    public String describe() {
        return "New Filters";
    }

    public FilterUsePanel getFilterUsePanel() {
        if (this.filterUsePanel == null) {
            this.filterUsePanel = new FilterUsePanel(this.network, this.window);
        }
        return this.filterUsePanel;
    }

    public void show() {
        if (this.frame == null) {
            this.frame = new JFrame("Use Filters");
            this.frame.getContentPane().add(this.getFilterUsePanel());
            this.frame.pack();
        }
        this.frame.setVisible(true);
    }
}

